/*
 * Decompiled with CFR 0.152.
 */
package org.mov.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.mov.main.Module;
import org.mov.portfolio.Portfolio;
import org.mov.quote.QuoteBundle;
import org.mov.table.PortfolioModel;
import org.mov.ui.AbstractTable;
import org.mov.ui.MenuHelper;
import org.mov.util.Locale;

public class PortfolioTableModule
extends AbstractTable
implements Module,
ActionListener {
    private JMenuBar menuBar;
    private JMenuItem tableClose;
    private PropertyChangeSupport propertySupport;
    private QuoteBundle quoteBundle;
    private Portfolio portfolio;
    private PortfolioModel model;
    private String frameIcon = "org/mov/images/TableIcon.gif";
    static final /* synthetic */ boolean $assertionsDisabled;

    public PortfolioTableModule(Portfolio portfolio, QuoteBundle quoteBundle) {
        this.quoteBundle = quoteBundle;
        this.portfolio = portfolio;
        this.propertySupport = new PropertyChangeSupport(this);
        this.model = new PortfolioModel(portfolio, quoteBundle);
        this.setModel(this.model, 0, 1);
        this.model.addTableModelListener(this);
        this.showColumns(this.model);
        this.resort();
        this.addMenu();
    }

    private void addMenu() {
        this.menuBar = new JMenuBar();
        JMenu tableMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("TABLE"));
        tableMenu.add(this.createShowColumnMenu(this.model));
        tableMenu.addSeparator();
        this.tableClose = MenuHelper.addMenuItem((ActionListener)this, tableMenu, Locale.getString("CLOSE"));
    }

    public void save() {
    }

    public String getTitle() {
        return Locale.getString("TABLE_OF", this.portfolio.getName());
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return new ImageIcon(ClassLoader.getSystemClassLoader().getResource(this.frameIcon));
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tableClose) {
            this.propertySupport.firePropertyChange("window close", 0, 1);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !PortfolioTableModule.class.desiredAssertionStatus();
    }
}

