/*
 * Decompiled with CFR 0.152.
 */
package org.mov.table;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mov.main.CommandManager;
import org.mov.main.Module;
import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.ExpressionException;
import org.mov.parser.Parser;
import org.mov.parser.Variables;
import org.mov.quote.Quote;
import org.mov.quote.ScriptQuoteBundle;
import org.mov.quote.Symbol;
import org.mov.quote.WeekendDateException;
import org.mov.ui.AbstractTable;
import org.mov.ui.DesktopManager;
import org.mov.ui.MenuHelper;
import org.mov.ui.QuoteModel;
import org.mov.ui.SymbolListDialog;
import org.mov.util.ExpressionQuery;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class QuoteModule
extends AbstractTable
implements Module,
ActionListener {
    private JMenuBar menuBar;
    private JMenuItem findSymbol;
    private JMenuItem graphSymbols;
    private JMenuItem tableSymbols;
    private JMenuItem applyEquations;
    private JMenuItem applyFilter;
    private JMenuItem sortByMostActive;
    private JMenuItem tableClose;
    private JMenuItem popupGraphSymbols = null;
    private JMenuItem popupTableSymbols = null;
    private PropertyChangeSupport propertySupport;
    private ScriptQuoteBundle quoteBundle;
    private QuoteModel model;
    private String frameIcon = "org/mov/images/TableIcon.gif";
    private String filterEquationString;
    private boolean singleDate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QuoteModule(ScriptQuoteBundle quoteBundle, boolean singleDate) {
        this(quoteBundle, null, singleDate);
    }

    public QuoteModule(ScriptQuoteBundle quoteBundle, String filterEquationString, boolean singleDate) {
        this.filterEquationString = filterEquationString;
        this.quoteBundle = quoteBundle;
        this.singleDate = singleDate;
        this.propertySupport = new PropertyChangeSupport(this);
        List quotes = this.extractQuotesUsingRule(filterEquationString, quoteBundle);
        this.model = new QuoteModel(quoteBundle, quotes, singleDate ? 0 : 1, quoteBundle.getAllSymbols().size() == 1 ? 0 : 1);
        this.setModel(this.model, quoteBundle.getAllSymbols().size() == 1 ? 1 : 9, 1);
        this.model.addTableModelListener(this);
        this.showColumns(this.model);
        this.resort();
        this.addMenu();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                QuoteModule.this.handleMouseClicked(evt);
            }
        });
    }

    private void checkMenuDisabledStatus() {
        int numberOfSelectedRows = this.getSelectedRowCount();
        this.graphSymbols.setEnabled(numberOfSelectedRows > 0);
        this.tableSymbols.setEnabled(numberOfSelectedRows > 0);
    }

    private void handleMouseClicked(MouseEvent event) {
        Point point = event.getPoint();
        if (event.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            this.popupGraphSymbols = MenuHelper.addMenuItem((ActionListener)this, menu, Locale.getString("GRAPH"));
            this.popupGraphSymbols.setEnabled(this.getSelectedRowCount() > 0);
            this.popupTableSymbols = MenuHelper.addMenuItem((ActionListener)this, menu, Locale.getString("TABLE"));
            this.popupTableSymbols.setEnabled(this.getSelectedRowCount() > 0);
            menu.show(this, point.x, point.y);
        } else if (event.getButton() == 1 && event.getClickCount() == 2) {
            int[] selectedRows = this.getSelectedRows();
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (int i = 0; i < selectedRows.length; ++i) {
                Symbol symbol = (Symbol)this.model.getValueAt(selectedRows[i], 0);
                symbols.add(symbol);
            }
            CommandManager.getInstance().graphStockBySymbol(symbols);
        }
    }

    private List extractAllQuotes(ScriptQuoteBundle quoteBundle) {
        ArrayList<Quote> quotes = new ArrayList<Quote>();
        Iterator iterator = quoteBundle.iterator();
        TradingDate lastDate = quoteBundle.getLastDate();
        while (iterator.hasNext()) {
            Quote quote = (Quote)iterator.next();
            if (this.singleDate && !lastDate.equals(quote.getDate())) continue;
            quotes.add(quote);
        }
        return quotes;
    }

    private List extractQuotesUsingRule(String filterEquation, ScriptQuoteBundle quoteBundle) {
        Expression expression;
        block8: {
            if (filterEquation == null || filterEquation.length() == 0) {
                return this.extractAllQuotes(quoteBundle);
            }
            expression = null;
            try {
                expression = Parser.parse(this.filterEquationString);
            }
            catch (ExpressionException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        ArrayList<Quote> quotes = new ArrayList<Quote>();
        Iterator iterator = quoteBundle.iterator();
        TradingDate lastDate = quoteBundle.getLastDate();
        try {
            while (iterator.hasNext()) {
                int dateOffset;
                Symbol symbol;
                Quote quote;
                block9: {
                    quote = (Quote)iterator.next();
                    symbol = quote.getSymbol();
                    TradingDate date = quote.getDate();
                    dateOffset = 0;
                    try {
                        dateOffset = quoteBundle.dateToOffset(date);
                    }
                    catch (WeekendDateException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
                if (this.singleDate && !lastDate.equals(quote.getDate())) continue;
                Variables variables = new Variables();
                if (!(expression.evaluate(variables, quoteBundle, symbol, dateOffset) >= 0.1)) continue;
                quotes.add(quote);
            }
            return quotes;
        }
        catch (EvaluationException e) {
            JOptionPane.showInternalMessageDialog(DesktopManager.getDesktop(), e.getReason() + ": " + ((Object)expression).toString(), Locale.getString("ERROR_EVALUATION_EQUATION"), 0);
            expression = null;
            return this.extractAllQuotes(quoteBundle);
        }
    }

    private void addMenu() {
        this.menuBar = new JMenuBar();
        JMenu tableMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("TABLE"));
        tableMenu.add(this.createShowColumnMenu(this.model));
        tableMenu.addSeparator();
        this.applyEquations = MenuHelper.addMenuItem((ActionListener)this, tableMenu, Locale.getString("APPLY_EQUATIONS"));
        this.applyFilter = MenuHelper.addMenuItem((ActionListener)this, tableMenu, Locale.getString("APPLY_FILTER"));
        this.sortByMostActive = MenuHelper.addMenuItem((ActionListener)this, tableMenu, Locale.getString("SORT_BY_MOST_ACTIVE"));
        tableMenu.addSeparator();
        this.tableClose = MenuHelper.addMenuItem((ActionListener)this, tableMenu, Locale.getString("CLOSE"));
        JMenu symbolsMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("SYMBOLS"));
        this.findSymbol = MenuHelper.addMenuItem((ActionListener)this, symbolsMenu, Locale.getString("FIND"));
        symbolsMenu.addSeparator();
        this.graphSymbols = MenuHelper.addMenuItem((ActionListener)this, symbolsMenu, Locale.getString("GRAPH"));
        this.tableSymbols = MenuHelper.addMenuItem((ActionListener)this, symbolsMenu, Locale.getString("TABLE"));
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                QuoteModule.this.checkMenuDisabledStatus();
            }
        });
        this.checkMenuDisabledStatus();
    }

    private void applyFilter() {
        Thread thread2 = new Thread(){

            public void run() {
                JDesktopPane desktop = DesktopManager.getDesktop();
                String equationString = ExpressionQuery.getExpression(desktop, Locale.getString("FILTER_BY_RULE"), Locale.getString("BY_RULE"), QuoteModule.this.filterEquationString);
                if (equationString != null) {
                    QuoteModule.this.filterEquationString = equationString;
                    List quotes = QuoteModule.this.extractQuotesUsingRule(QuoteModule.this.filterEquationString, QuoteModule.this.quoteBundle);
                    SwingUtilities.invokeLater(new Runnable(this, quotes){
                        private final /* synthetic */ List val$quotes;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$quotes = val$quotes;
                        }

                        public void run() {
                            QuoteModule.access$600(3.access$500(this.this$1)).setQuotes(this.val$quotes);
                        }
                    });
                }
            }

            static /* synthetic */ QuoteModule access$500(3 x0) {
                return x0.QuoteModule.this;
            }
        };
        thread2.start();
    }

    private void findSymbol() {
        Thread thread2 = new Thread(){

            public void run() {
                JDesktopPane desktop = DesktopManager.getDesktop();
                Symbol symbol = SymbolListDialog.getSymbol(desktop, Locale.getString("FIND_SYMBOL"));
                if (symbol != null) {
                    List quotes = QuoteModule.this.model.getQuotes();
                    int i = 0;
                    Iterator iterator = quotes.iterator();
                    while (iterator.hasNext()) {
                        Quote quote = (Quote)iterator.next();
                        if (symbol.equals(quote.getSymbol())) {
                            QuoteModule.this.setRowSelectionInterval(i, i);
                            QuoteModule.this.setVisible(i, 0);
                            return;
                        }
                        ++i;
                    }
                    JOptionPane.showInternalMessageDialog(DesktopManager.getDesktop(), Locale.getString("SYMBOL_X_NOT_FOUND", symbol.toString()), Locale.getString("SYMBOL_NOT_FOUND"), 1);
                }
            }
        };
        thread2.start();
    }

    public void save() {
    }

    public String getTitle() {
        String title = Locale.getString("TABLE_OF", this.quoteBundle.getQuoteRange().getDescription());
        if (this.singleDate) {
            title = title.concat(" (" + this.quoteBundle.getLastDate().toString("dd/mm/yyyy") + ")");
        }
        return title;
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return new ImageIcon(ClassLoader.getSystemClassLoader().getResource(this.frameIcon));
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tableClose) {
            this.propertySupport.firePropertyChange("window close", 0, 1);
        } else if (e.getSource() == this.applyEquations) {
            this.applyEquations(this.quoteBundle, this.model);
        } else if (e.getSource() == this.applyFilter) {
            this.applyFilter();
        } else if (e.getSource() == this.sortByMostActive) {
            this.setColumnSortStatus(9, 1);
            this.resort();
            this.validate();
            this.repaint();
        } else if (e.getSource() == this.findSymbol) {
            this.findSymbol();
        } else if (this.popupGraphSymbols != null && e.getSource() == this.popupGraphSymbols || e.getSource() == this.graphSymbols) {
            int[] selectedRows = this.getSelectedRows();
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (int i = 0; i < selectedRows.length; ++i) {
                Symbol symbol = (Symbol)this.model.getValueAt(selectedRows[i], 0);
                symbols.add(symbol);
            }
            CommandManager.getInstance().graphStockBySymbol(symbols);
        } else if (this.popupTableSymbols != null && e.getSource() == this.popupTableSymbols || e.getSource() == this.tableSymbols) {
            int[] selectedRows = this.getSelectedRows();
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (int i = 0; i < selectedRows.length; ++i) {
                Symbol symbol = (Symbol)this.model.getValueAt(selectedRows[i], 0);
                symbols.add(symbol);
            }
            CommandManager.getInstance().tableStocks(symbols);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !QuoteModule.class.desiredAssertionStatus();
    }
}

