/*
 * Decompiled with CFR 0.152.
 */
package org.mov.table;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mov.main.CommandManager;
import org.mov.main.Module;
import org.mov.prefs.PreferencesManager;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.Quote;
import org.mov.quote.ScriptQuoteBundle;
import org.mov.quote.Symbol;
import org.mov.table.WatchScreen;
import org.mov.ui.AbstractTable;
import org.mov.ui.DesktopManager;
import org.mov.ui.MainMenu;
import org.mov.ui.MenuHelper;
import org.mov.ui.QuoteModel;
import org.mov.ui.SymbolListDialog;
import org.mov.ui.TextDialog;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class WatchScreenModule
extends AbstractTable
implements Module,
ActionListener {
    private JMenuBar menuBar;
    private JMenuItem addSymbols;
    private JMenuItem removeSymbols;
    private JMenuItem graphSymbols;
    private JMenuItem graphIndexSymbols;
    private JMenuItem tableSymbols;
    private JMenuItem tableClose;
    private JMenuItem renameWatchScreen;
    private JMenuItem deleteWatchScreen;
    private JMenuItem applyEquationsMenuItem;
    private JMenuItem popupRemoveSymbols = null;
    private JMenuItem popupGraphSymbols = null;
    private JMenuItem popupTableSymbols = null;
    private PropertyChangeSupport propertySupport;
    private ScriptQuoteBundle quoteBundle;
    private WatchScreen watchScreen;
    private QuoteModel model;
    private String frameIcon = "org/mov/images/TableIcon.gif";
    private boolean isDeleted = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WatchScreenModule(WatchScreen watchScreen, ScriptQuoteBundle quoteBundle) {
        this.watchScreen = watchScreen;
        this.quoteBundle = quoteBundle;
        this.propertySupport = new PropertyChangeSupport(this);
        this.model = new QuoteModel(quoteBundle, this.getQuotes(), 0, 1);
        this.setModel(this.model, 0, 1);
        this.showColumns(this.model);
        this.addMenu();
        this.model.addTableModelListener(this);
        this.resort();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                WatchScreenModule.this.handleMouseClicked(evt);
            }
        });
    }

    private void checkMenuDisabledStatus() {
        int numberOfSelectedRows = this.getSelectedRowCount();
        this.removeSymbols.setEnabled(numberOfSelectedRows > 0);
        this.graphSymbols.setEnabled(numberOfSelectedRows > 0);
        this.graphIndexSymbols.setEnabled(numberOfSelectedRows > 0);
        this.tableSymbols.setEnabled(numberOfSelectedRows > 0);
    }

    private void handleMouseClicked(MouseEvent event) {
        Point point = event.getPoint();
        if (event.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            this.popupGraphSymbols = MenuHelper.addMenuItem((ActionListener)this, menu, Locale.getString("GRAPH"));
            this.popupGraphSymbols.setEnabled(this.getSelectedRowCount() > 0);
            this.popupTableSymbols = MenuHelper.addMenuItem((ActionListener)this, menu, Locale.getString("TABLE"));
            this.popupTableSymbols.setEnabled(this.getSelectedRowCount() > 0);
            menu.addSeparator();
            this.popupRemoveSymbols = MenuHelper.addMenuItem((ActionListener)this, menu, Locale.getString("REMOVE"));
            this.popupRemoveSymbols.setEnabled(this.getSelectedRowCount() > 0);
            menu.show(this, point.x, point.y);
        } else if (event.getButton() == 1 && event.getClickCount() == 2) {
            int[] selectedRows = this.getSelectedRows();
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (int i = 0; i < selectedRows.length; ++i) {
                Symbol symbol = (Symbol)this.model.getValueAt(selectedRows[i], 0);
                symbols.add(symbol);
            }
            CommandManager.getInstance().graphStockBySymbol(symbols);
        }
    }

    private void addMenu() {
        this.menuBar = new JMenuBar();
        JMenu tableMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("WATCH_SCREEN"));
        tableMenu.add(this.createShowColumnMenu(this.model));
        tableMenu.addSeparator();
        this.applyEquationsMenuItem = MenuHelper.addMenuItem((ActionListener)this, tableMenu, Locale.getString("APPLY_EQUATIONS"));
        tableMenu.addSeparator();
        this.deleteWatchScreen = MenuHelper.addMenuItem((ActionListener)this, tableMenu, Locale.getString("DELETE"));
        this.renameWatchScreen = MenuHelper.addMenuItem((ActionListener)this, tableMenu, Locale.getString("RENAME"));
        tableMenu.addSeparator();
        this.tableClose = MenuHelper.addMenuItem((ActionListener)this, tableMenu, Locale.getString("CLOSE"));
        JMenu symbolsMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("SYMBOLS"));
        this.addSymbols = MenuHelper.addMenuItem((ActionListener)this, symbolsMenu, Locale.getString("ADD"));
        this.removeSymbols = MenuHelper.addMenuItem((ActionListener)this, symbolsMenu, Locale.getString("REMOVE"));
        symbolsMenu.addSeparator();
        this.graphSymbols = MenuHelper.addMenuItem((ActionListener)this, symbolsMenu, Locale.getString("GRAPH"));
        this.graphIndexSymbols = MenuHelper.addMenuItem((ActionListener)this, symbolsMenu, Locale.getString("GRAPH_INDEX"));
        this.tableSymbols = MenuHelper.addMenuItem((ActionListener)this, symbolsMenu, Locale.getString("TABLE"));
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                WatchScreenModule.this.checkMenuDisabledStatus();
            }
        });
        this.checkMenuDisabledStatus();
    }

    public void save() {
        if (!this.isDeleted) {
            PreferencesManager.saveWatchScreen(this.watchScreen);
        }
    }

    public String getTitle() {
        return this.watchScreen.getName();
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return new ImageIcon(ClassLoader.getSystemClassLoader().getResource(this.frameIcon));
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tableClose) {
            this.propertySupport.firePropertyChange("window close", 0, 1);
        } else if (this.popupGraphSymbols != null && e.getSource() == this.popupGraphSymbols || e.getSource() == this.graphSymbols || e.getSource() == this.graphIndexSymbols) {
            int[] selectedRows = this.getSelectedRows();
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (int i = 0; i < selectedRows.length; ++i) {
                Symbol symbol = (Symbol)this.model.getValueAt(selectedRows[i], 0);
                symbols.add(symbol);
            }
            if (e.getSource() == this.graphSymbols) {
                CommandManager.getInstance().graphStockBySymbol(symbols);
            }
            if (e.getSource() == this.graphIndexSymbols) {
                CommandManager.getInstance().graphIndexBySymbol(symbols);
            }
        } else if (this.popupRemoveSymbols != null && e.getSource() == this.popupRemoveSymbols || e.getSource() == this.removeSymbols) {
            int[] selectedRows = this.getSelectedRows();
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (int i = 0; i < selectedRows.length; ++i) {
                Symbol symbol = (Symbol)this.model.getValueAt(selectedRows[i], 0);
                symbols.add(symbol);
            }
            this.watchScreen.removeAllSymbols(symbols);
            this.model.setQuotes(this.getQuotes());
            this.model.fireTableDataChanged();
        } else if (e.getSource() == this.addSymbols) {
            this.addSymbols();
        } else if (e.getSource() == this.applyEquationsMenuItem) {
            this.applyEquations(this.quoteBundle, this.model);
        } else if (e.getSource() == this.deleteWatchScreen) {
            this.deleteWatchScreen();
        } else if (e.getSource() == this.renameWatchScreen) {
            this.renameWatchScreen();
        } else if (this.popupTableSymbols != null && e.getSource() == this.popupTableSymbols || e.getSource() == this.tableSymbols) {
            int[] selectedRows = this.getSelectedRows();
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (int i = 0; i < selectedRows.length; ++i) {
                Symbol symbol = (Symbol)this.model.getValueAt(selectedRows[i], 0);
                symbols.add(symbol);
            }
            CommandManager.getInstance().tableStocks(symbols);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private void deleteWatchScreen() {
        int option = JOptionPane.showInternalConfirmDialog(DesktopManager.getDesktop(), Locale.getString("SURE_DELETE_WATCH_SCREEN"), Locale.getString("DELETE_WATCH_SCREEN"), 0);
        if (option == 0) {
            PreferencesManager.deleteWatchScreen(this.watchScreen.getName());
            MainMenu.getInstance().updateWatchScreenMenu();
            this.isDeleted = true;
            this.propertySupport.firePropertyChange("window close", 0, 1);
        }
    }

    private void renameWatchScreen() {
        Thread thread2 = new Thread(){

            public void run() {
                String oldWatchScreenName = WatchScreenModule.this.watchScreen.getName();
                TextDialog dialog = new TextDialog(DesktopManager.getDesktop(), Locale.getString("ENTER_NEW_WATCH_SCREEN_NAME"), Locale.getString("RENAME_WATCH_SCREEN"), oldWatchScreenName);
                String newWatchScreenName = dialog.showDialog();
                if (newWatchScreenName != null && newWatchScreenName.length() > 0 && !newWatchScreenName.equals(oldWatchScreenName)) {
                    WatchScreenModule.this.watchScreen.setName(newWatchScreenName);
                    PreferencesManager.saveWatchScreen(WatchScreenModule.this.watchScreen);
                    PreferencesManager.deleteWatchScreen(oldWatchScreenName);
                    MainMenu.getInstance().updateWatchScreenMenu();
                    WatchScreenModule.this.propertySupport.firePropertyChange("titlebar changed", 0, 1);
                }
            }
        };
        thread2.start();
    }

    private void addSymbols() {
        Thread thread2 = new Thread(){

            public void run() {
                SortedSet symbols = SymbolListDialog.getSymbols(DesktopManager.getDesktop(), Locale.getString("ADD_SYMBOLS"));
                if (symbols != null) {
                    Iterator iterator = symbols.iterator();
                    while (iterator.hasNext()) {
                        WatchScreenModule.this.watchScreen.addSymbol((Symbol)iterator.next());
                    }
                    WatchScreenModule.this.model.setQuotes(WatchScreenModule.this.getQuotes());
                }
            }
        };
        thread2.start();
    }

    private List getQuotes() {
        ArrayList<Quote> quotes = new ArrayList<Quote>();
        TradingDate lastDate = this.quoteBundle.getLastDate();
        Iterator iterator = this.watchScreen.getSymbols().iterator();
        while (iterator.hasNext()) {
            Quote quote;
            Symbol symbol = (Symbol)iterator.next();
            try {
                quote = new Quote(symbol, lastDate, (int)this.quoteBundle.getQuote(symbol, 4, lastDate), this.quoteBundle.getQuote(symbol, 2, lastDate), this.quoteBundle.getQuote(symbol, 3, lastDate), this.quoteBundle.getQuote(symbol, 1, lastDate), this.quoteBundle.getQuote(symbol, 0, lastDate));
            }
            catch (MissingQuoteException e) {
                quote = new Quote(symbol, lastDate, 0, 0.0, 0.0, 0.0, 0.0);
            }
            quotes.add(quote);
        }
        return quotes;
    }

    static {
        $assertionsDisabled = !WatchScreenModule.class.desiredAssertionStatus();
    }
}

