/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.AccountNameFormat;
import org.mov.ui.ChangeFormat;
import org.mov.ui.Column;
import org.mov.ui.EquationColumn;
import org.mov.ui.EquationColumnDialog;
import org.mov.ui.EquationResult;
import org.mov.ui.MenuHelper;
import org.mov.ui.PointChangeFormat;
import org.mov.ui.QuoteFormat;
import org.mov.ui.QuoteModel;
import org.mov.ui.SortedTable;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class AbstractTable
extends SortedTable {
    private static final Color backgroundColor = Color.white;
    private static final Color alternativeBackgroundColor = new Color(237, 237, 237);
    private String upImage = "org/mov/images/Up.png";
    private String downImage = "org/mov/images/Down.png";
    private String unchangedImage = "org/mov/images/Unchanged.png";
    private NumberFormat format;
    private ImageIcon upImageIcon;
    private ImageIcon downImageIcon;
    private ImageIcon unchangedImageIcon;
    private List showEquationColumnMenuItems;

    public AbstractTable() {
        this.setShowGrid(true);
        this.setDefaultRenderer(AccountNameFormat.class, new StockQuoteRenderer());
        this.setDefaultRenderer(ChangeFormat.class, new StockQuoteRenderer());
        this.setDefaultRenderer(Double.class, new StockQuoteRenderer());
        this.setDefaultRenderer(Float.class, new StockQuoteRenderer());
        this.setDefaultRenderer(Integer.class, new StockQuoteRenderer());
        this.setDefaultRenderer(Money.class, new StockQuoteRenderer());
        this.setDefaultRenderer(QuoteFormat.class, new StockQuoteRenderer());
        this.setDefaultRenderer(String.class, new StockQuoteRenderer());
        this.setDefaultRenderer(TradingDate.class, new StockQuoteRenderer());
        this.setDefaultRenderer(EquationResult.class, new StockQuoteRenderer());
        this.setDefaultRenderer(PointChangeFormat.class, new StockQuoteRenderer());
        this.setDefaultRenderer(Symbol.class, new StockQuoteRenderer());
        this.format = NumberFormat.getInstance();
        this.format.setMinimumIntegerDigits(1);
        this.format.setMinimumFractionDigits(2);
        this.format.setMaximumFractionDigits(2);
        URL upImageResource = ClassLoader.getSystemResource(this.upImage);
        this.upImageIcon = upImageResource != null ? new ImageIcon(upImageResource) : null;
        URL downImageResource = ClassLoader.getSystemResource(this.downImage);
        this.downImageIcon = downImageResource != null ? new ImageIcon(downImageResource) : null;
        URL unchangedImageResource = ClassLoader.getSystemResource(this.unchangedImage);
        this.unchangedImageIcon = unchangedImageResource != null ? new ImageIcon(unchangedImageResource) : null;
    }

    protected void showColumns(AbstractTableModel model) {
        for (int i = 0; i < model.getColumnCount(); ++i) {
            Column column = model.getColumn(i);
            this.showColumn(column.getNumber(), column.getVisible() == 1);
        }
    }

    protected JMenu createShowColumnMenu(AbstractTableModel model) {
        boolean foundEquationColumn = false;
        JMenu showColumnsMenu = new JMenu(Locale.getString("SHOW_COLUMNS"));
        this.showEquationColumnMenuItems = new ArrayList();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            final Column column = model.getColumn(i);
            if (column.getVisible() == 2) continue;
            boolean isEquationColumn = column instanceof EquationColumn;
            if (!foundEquationColumn && isEquationColumn) {
                foundEquationColumn = true;
                showColumnsMenu.addSeparator();
            }
            JCheckBoxMenuItem showMenuItem = MenuHelper.addCheckBoxMenuItem(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
                    AbstractTable.this.showColumn(column.getNumber(), menuItem.getState());
                }
            }, showColumnsMenu, column.getFullName());
            showMenuItem.setState(column.getVisible() == 1);
            if (!isEquationColumn) continue;
            this.showEquationColumnMenuItems.add(showMenuItem);
        }
        return showColumnsMenu;
    }

    protected void applyEquations(final QuoteBundle quoteBundle, final QuoteModel model) {
        Thread thread2 = new Thread(){

            public void run() {
                EquationColumnDialog dialog = new EquationColumnDialog(model.getEquationColumns().length);
                if (dialog.showDialog(model.getEquationColumns())) {
                    EquationColumn[] equationColumns = dialog.getEquationColumns();
                    model.setEquationColumns(quoteBundle, equationColumns);
                    SwingUtilities.invokeLater(new Runnable(this, equationColumns){
                        private final /* synthetic */ EquationColumn[] val$equationColumns;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$equationColumns = val$equationColumns;
                        }

                        public void run() {
                            for (int i = 0; i < this.val$equationColumns.length; ++i) {
                                boolean containsEquation = this.val$equationColumns[i].getEquation().length() > 0;
                                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)AbstractTable.access$700(2.access$600(this.this$1)).get(i);
                                2.access$600(this.this$1).showColumn(this.val$equationColumns[i].getNumber(), containsEquation);
                                menuItem.setState(containsEquation);
                            }
                        }
                    });
                }
            }

            static /* synthetic */ AbstractTable access$600(2 x0) {
                return x0.AbstractTable.this;
            }
        };
        thread2.start();
    }

    static /* synthetic */ List access$700(AbstractTable x0) {
        return x0.showEquationColumnMenuItems;
    }

    class StockQuoteRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel textLabel = new JLabel();
        private JLabel iconLabel = new JLabel();
        private Component glue = Box.createHorizontalGlue();

        public StockQuoteRenderer() {
            this.setLayout(new BoxLayout(this, 0));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            AbstractTable t = (AbstractTable)table;
            this.textLabel.setFont(table.getFont());
            this.textLabel.setForeground(table.getForeground());
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.textLabel.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(row % 2 != 0 ? backgroundColor : alternativeBackgroundColor);
            }
            if (value instanceof ChangeFormat) {
                this.renderChangeComponent(table, value, isSelected, hasFocus, row, column);
            } else if (value instanceof TradingDate) {
                TradingDate date = (TradingDate)value;
                String text = date.toString("d?/m?/yyyy");
                this.textLabel.setText(text);
                this.add(this.textLabel);
            } else {
                this.textLabel.setText(value.toString());
                this.add(this.textLabel);
            }
            return this;
        }

        private void renderChangeComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ChangeFormat change = (ChangeFormat)value;
            double changePercent = change.getChange();
            String text = new String();
            if (changePercent > 0.0) {
                text = "+";
            }
            text = text.concat(AbstractTable.this.format.format(changePercent));
            text = text.concat("%");
            this.textLabel.setText(text);
            if (changePercent > 0.0 && AbstractTable.this.upImageIcon != null) {
                this.iconLabel.setIcon(AbstractTable.this.upImageIcon);
            } else if (changePercent < 0.0 && AbstractTable.this.downImageIcon != null) {
                this.iconLabel.setIcon(AbstractTable.this.downImageIcon);
            } else if (changePercent == 0.0 && AbstractTable.this.unchangedImageIcon != null) {
                this.iconLabel.setIcon(AbstractTable.this.unchangedImageIcon);
            }
            this.add(this.glue);
            this.add(this.textLabel);
            this.add(this.iconLabel);
        }
    }
}

