/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultDesktopManager;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import org.mov.main.Module;
import org.mov.main.ModuleFrame;
import org.mov.ui.ModuleEvent;
import org.mov.ui.ModuleListener;
import org.mov.ui.ProgressDialogManager;
import org.mov.util.Locale;

public class DesktopManager
extends DefaultDesktopManager
implements Serializable {
    private static int DEFAULT_FRAME_WIDTH = 450;
    private static int DEFAULT_FRAME_HEIGHT = 375;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int CASCADE = 2;
    public static final int ARRANGE = 3;
    private static JDesktopPane desktop_instance = null;
    private static EventListenerList moduleListeners = new EventListenerList();

    public static void setDesktop(JDesktopPane desktop) {
        desktop_instance = desktop;
    }

    public static JDesktopPane getDesktop() {
        return desktop_instance;
    }

    public DesktopManager(JDesktopPane desktop) {
        DesktopManager.setDesktop(desktop);
    }

    public void addModuleListener(ModuleListener moduleListener) {
        moduleListeners.add(ModuleListener.class, moduleListener);
    }

    public void removeModuleListener(ModuleListener moduleListener) {
        moduleListeners.remove(ModuleListener.class, moduleListener);
    }

    private void fireModuleAdded(Module module) {
        ModuleEvent event = null;
        Object[] listeners = moduleListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$mov$ui$ModuleListener == null ? DesktopManager.class$("org.mov.ui.ModuleListener") : class$org$mov$ui$ModuleListener)) continue;
            if (event == null) {
                event = new ModuleEvent(module);
            }
            ((ModuleListener)listeners[i + 1]).moduleAdded(event);
        }
    }

    public void fireModuleRemoved(Module module) {
        ModuleEvent event = null;
        Object[] listeners = moduleListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$mov$ui$ModuleListener == null ? DesktopManager.class$("org.mov.ui.ModuleListener") : class$org$mov$ui$ModuleListener)) continue;
            if (event == null) {
                event = new ModuleEvent(module);
            }
            ((ModuleListener)listeners[i + 1]).moduleRemoved(event);
        }
    }

    public void fireModuleRenamed(Module module) {
        ModuleEvent event = null;
        Object[] listeners = moduleListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$mov$ui$ModuleListener == null ? DesktopManager.class$("org.mov.ui.ModuleListener") : class$org$mov$ui$ModuleListener)) continue;
            if (event == null) {
                event = new ModuleEvent(module);
            }
            ((ModuleListener)listeners[i + 1]).moduleRenamed(event);
        }
    }

    public static void showWarningMessage(final String message) {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                String multiLineMessage = DesktopManager.breakUpMessage(message);
                JOptionPane.showInternalMessageDialog(desktop_instance, multiLineMessage, Locale.getString("VENICE_PROBLEM_TITLE"), 2);
            }
        });
        thread2.start();
    }

    public static void showErrorMessage(final String message) {
        if (ProgressDialogManager.isProgressDialogUp()) {
            Thread.currentThread().interrupt();
        }
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                String multiLineMessage = DesktopManager.breakUpMessage(message);
                JOptionPane.showInternalMessageDialog(desktop_instance, multiLineMessage, Locale.getString("VENICE_PROBLEM_TITLE"), 0);
            }
        });
        thread2.start();
    }

    private static String breakUpMessage(String message) {
        StringTokenizer tokeniser = new StringTokenizer(message, " \n", true);
        String multiLineMessage = "";
        int MAX_LINE_LENGTH = 40;
        int lineLength = 0;
        while (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken();
            if (token.equals("\n")) {
                lineLength = 0;
            }
            if (lineLength > 40) {
                multiLineMessage = multiLineMessage.concat("\n");
                lineLength = 0;
            }
            if (lineLength > 0 || !token.equals(" ")) {
                multiLineMessage = multiLineMessage.concat(token);
            }
            if (token.equals("\n")) continue;
            lineLength += token.length();
        }
        return multiLineMessage;
    }

    public static void tileFrames(int style) {
        int i;
        Dimension deskDim = desktop_instance.getSize();
        int deskWidth = deskDim.width;
        int deskHeight = deskDim.height;
        JInternalFrame[] frames = desktop_instance.getAllFrames();
        int frameCount = frames.length;
        int frameWidth = 0;
        int frameHeight = 0;
        int xpos = 0;
        int ypos = 0;
        double scale = 0.6;
        int spacer = 30;
        int frameCounter = 0;
        Vector<JInternalFrame> frameVec = new Vector<JInternalFrame>(1, 1);
        boolean areIcons = false;
        boolean tempy = false;
        boolean tempx = false;
        for (i = 0; i < frameCount; ++i) {
            if (frames[i].isVisible() && !frames[i].isIcon() && frames[i].isResizable()) {
                frameVec.addElement(frames[i]);
                ++frameCounter;
                continue;
            }
            if (!frames[i].isIcon()) continue;
            areIcons = true;
        }
        if (areIcons) {
            deskHeight -= 50;
        }
        switch (style) {
            case 0: {
                for (i = 0; i < frameCounter; ++i) {
                    JInternalFrame temp = (JInternalFrame)frameVec.elementAt(i);
                    frameWidth = deskWidth;
                    frameHeight = deskHeight / frameCounter;
                    temp.reshape(xpos, ypos, frameWidth, frameHeight);
                    ypos += frameHeight;
                    temp.moveToFront();
                }
                break;
            }
            case 1: {
                for (i = 0; i < frameCounter; ++i) {
                    JInternalFrame temp = (JInternalFrame)frameVec.elementAt(i);
                    frameWidth = deskWidth / frameCounter;
                    frameHeight = deskHeight;
                    if (temp.isResizable()) {
                        temp.reshape(xpos, ypos, frameWidth, frameHeight);
                    } else {
                        temp.setLocation(xpos, ypos);
                    }
                    xpos += frameWidth;
                    temp.moveToFront();
                }
                break;
            }
            case 2: {
                for (i = 0; i < frameCounter; ++i) {
                    JInternalFrame temp = (JInternalFrame)frameVec.elementAt(i);
                    frameWidth = (int)((double)deskWidth * scale);
                    frameHeight = (int)((double)deskHeight * scale);
                    if (temp.isResizable()) {
                        temp.reshape(xpos, ypos, frameWidth, frameHeight);
                    } else {
                        temp.setLocation(xpos, ypos);
                    }
                    temp.moveToFront();
                    if ((xpos += spacer) + frameWidth <= deskWidth && (ypos += spacer) + frameHeight <= deskHeight - 50) continue;
                    xpos = 0;
                    ypos = 0;
                }
                break;
            }
            case 3: {
                int col;
                int row = new Long(Math.round(Math.sqrt(new Integer(frameCounter).doubleValue()))).intValue();
                if (row == 0 || (col = frameCounter / row) == 0) break;
                int rem = frameCounter % row;
                int rowCount = 1;
                frameWidth = deskWidth / col;
                frameHeight = deskHeight / row;
                for (int i2 = 0; i2 < frameCounter; ++i2) {
                    JInternalFrame temp = (JInternalFrame)frameVec.elementAt(i2);
                    if (rowCount <= row - rem) {
                        if (temp.isResizable()) {
                            temp.reshape(xpos, ypos, frameWidth, frameHeight);
                        } else {
                            temp.setLocation(xpos, ypos);
                        }
                        if (xpos + 10 < deskWidth - frameWidth) {
                            xpos += frameWidth;
                            continue;
                        }
                        ypos += frameHeight;
                        xpos = 0;
                        ++rowCount;
                        continue;
                    }
                    frameWidth = deskWidth / (col + 1);
                    if (temp.isResizable()) {
                        temp.reshape(xpos, ypos, frameWidth, frameHeight);
                    } else {
                        temp.setLocation(xpos, ypos);
                    }
                    if (xpos + 10 < deskWidth - frameWidth) {
                        xpos += frameWidth;
                        continue;
                    }
                    ypos += frameHeight;
                    xpos = 0;
                }
                break;
            }
        }
    }

    public static void minimizeWindows() {
        JInternalFrame[] openWindows = desktop_instance.getAllFrames();
        for (int i = 0; i < openWindows.length; ++i) {
            if (!openWindows[i].isIconifiable()) continue;
            try {
                openWindows[i].setIcon(true);
                continue;
            }
            catch (PropertyVetoException pve) {
                pve.printStackTrace();
            }
        }
    }

    public static void restoreAll() {
        JInternalFrame[] openWindows = desktop_instance.getAllFrames();
        for (int i = 0; i < openWindows.length; ++i) {
            if (!openWindows[i].isIcon()) continue;
            try {
                openWindows[i].setIcon(false);
                continue;
            }
            catch (PropertyVetoException pve) {
                pve.printStackTrace();
            }
        }
    }

    public static void closeAllWindows() {
        JInternalFrame[] openWindows = desktop_instance.getAllFrames();
        for (int i = 0; i < openWindows.length; ++i) {
            openWindows[i].dispose();
        }
    }

    public ModuleFrame newFrame(Module module) {
        return this.newFrame(module, false, false, true);
    }

    public ModuleFrame newFrame(Module module, boolean centre, boolean honourSize, boolean resizable) {
        ModuleFrame frame = new ModuleFrame(this, module, centre, honourSize, resizable);
        desktop_instance.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException v) {
            // empty catch block
        }
        frame.moveToFront();
        this.fireModuleAdded(module);
        return frame;
    }

    public void save() {
        JInternalFrame[] frames = desktop_instance.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame frame = frames[i];
            if (!(frame instanceof ModuleFrame)) continue;
            ModuleFrame moduleFrame = (ModuleFrame)frame;
            moduleFrame.getModule().save();
        }
    }
}

