/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.mov.main.ModuleFrame;
import org.mov.ui.DesktopManager;
import org.mov.util.Locale;

public class EditorDialog {
    private JInternalFrame internalFrame;
    private static final int NAME_WIDTH = 20;
    private static final int NUMBER_ROWS = 14;
    private static final int NUMBER_COLUMNS = 30;
    private static final int OK_BUTTON = 0;
    private static final int OK_CANCEL_BUTTON = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    private EditorDialog(String title, String shortTitle, String input, int buttonArray, boolean isEditable) {
        if (!$assertionsDisabled && buttonArray != 0 && buttonArray != 1) {
            throw new AssertionError();
        }
        this.buildDialog(title, shortTitle, input, buttonArray, isEditable);
    }

    private void buildDialog(String title, String shortTitle, String input, int buttonArray, boolean isEditable) {
        this.internalFrame = new JInternalFrame(title, true, false, false, false);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        JTextArea innerEditor = new JTextArea(14, 30);
        innerEditor.setText(input);
        innerEditor.setEditable(isEditable);
        TitledBorder titledBorder = new TitledBorder(shortTitle);
        innerPanel.setLayout(new BorderLayout());
        innerPanel.setBorder(titledBorder);
        innerPanel.add(new JScrollPane(innerEditor));
        panel.add((Component)innerPanel, "Center");
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton(Locale.getString("OK"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.close();
            }
        });
        buttonPanel.add(okButton);
        if (buttonArray == 1) {
            JButton cancelButton = new JButton(Locale.getString("CANCEL"));
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditorDialog.this.close();
                }
            });
            buttonPanel.add(cancelButton);
        }
        panel.add((Component)buttonPanel, "South");
        this.internalFrame.getContentPane().add(panel);
        Dimension preferred = this.internalFrame.getPreferredSize();
        this.internalFrame.setMinimumSize(preferred);
        ModuleFrame.setSizeAndLocation(this.internalFrame, DesktopManager.getDesktop(), true, true);
        DesktopManager.getDesktop().add(this.internalFrame);
        this.internalFrame.show();
        try {
            this.internalFrame.setSelected(true);
        }
        catch (PropertyVetoException v) {
            // empty catch block
        }
        this.internalFrame.moveToFront();
    }

    private void close() {
        try {
            this.internalFrame.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public static void showViewDialog(String title, String shortTitle, String input) {
        EditorDialog dialog = new EditorDialog(title, shortTitle, input, 0, false);
    }

    static {
        $assertionsDisabled = !EditorDialog.class.desiredAssertionStatus();
    }
}

