/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.Variables;
import org.mov.quote.Quote;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.quote.WeekendDateException;
import org.mov.ui.Column;
import org.mov.ui.EquationResult;
import org.mov.util.TradingDate;

public class EquationColumn
extends Column
implements Cloneable {
    private String equation;
    private Expression expression;
    private Map results;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EquationColumn(int number, String fullName, String shortName, int visible, String equation, Expression expression) {
        super(number, fullName, shortName, EquationResult.class, visible);
        this.equation = equation;
        this.expression = expression;
        this.results = new HashMap();
    }

    public EquationColumn(int number, String fullName, String shortName, int visible, String equation, Expression expression, Map results) {
        super(number, fullName, shortName, EquationResult.class, visible);
        this.equation = equation;
        this.expression = expression;
        this.results = results;
    }

    public String getEquation() {
        return this.equation;
    }

    public void setEquation(String equation) {
        this.equation = equation;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void recalculate(QuoteBundle quoteBundle, List quotes) throws EvaluationException {
        this.results = new HashMap();
        this.calculate(quoteBundle, quotes);
    }

    public void calculate(QuoteBundle quoteBundle, List quotes) throws EvaluationException {
        if (!$assertionsDisabled && this.results == null) {
            throw new AssertionError();
        }
        if (this.expression != null) {
            Iterator iterator = quotes.iterator();
            while (iterator.hasNext()) {
                Quote quote = (Quote)iterator.next();
                try {
                    int dateOffset = quoteBundle.dateToOffset(quote.getDate());
                    double result = this.expression.evaluate(new Variables(), quoteBundle, quote.getSymbol(), dateOffset);
                    this.results.put(quote.getSymbol().toString() + quote.getDate().toString(), new EquationResult(this.expression.getType(), result));
                }
                catch (WeekendDateException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    public EquationResult getResult(Symbol symbol, TradingDate date) {
        EquationResult equationResult = null;
        if (this.results != null) {
            equationResult = (EquationResult)this.results.get(symbol.toString() + date.toString());
        }
        if (equationResult == null) {
            equationResult = EquationResult.EMPTY;
        }
        return equationResult;
    }

    public Object clone() {
        return new EquationColumn(this.getNumber(), this.getFullName(), this.getShortName(), this.getVisible(), this.getEquation(), this.getExpression());
    }

    static {
        $assertionsDisabled = !EquationColumn.class.desiredAssertionStatus();
    }
}

