/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.mov.parser.ExpressionException;
import org.mov.parser.Parser;
import org.mov.ui.DesktopManager;
import org.mov.ui.EquationColumn;
import org.mov.ui.EquationComboBox;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class EquationColumnDialog
extends JInternalFrame
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private JPanel mainPanel;
    private JPanel transactionPanel;
    private JComboBox equationColumnComboBox;
    private JTextField columnNameTextField;
    private EquationComboBox equationComboBox;
    private boolean isDone = false;
    private EquationColumn[] equationColumns;
    private int currentEquationColumn = 0;
    private boolean OKButtonPressed;

    public EquationColumnDialog(int equationColumnCount) {
        super(Locale.getString("APPLY_EQUATIONS"));
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.mainPanel.setLayout(gridbag);
        this.mainPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        JLabel typeLabel = new JLabel(Locale.getString("EQUATION_COLUMN"));
        c.gridwidth = 1;
        gridbag.setConstraints(typeLabel, c);
        this.mainPanel.add(typeLabel);
        this.equationColumnComboBox = new JComboBox();
        String[] numbers = new String[]{Locale.getString("ONE"), Locale.getString("TWO"), Locale.getString("THREE"), Locale.getString("FOUR"), Locale.getString("FIVE")};
        for (int i = 0; i < equationColumnCount; ++i) {
            this.equationColumnComboBox.addItem(numbers[i]);
        }
        this.equationColumnComboBox.addActionListener(this);
        c.gridwidth = 0;
        gridbag.setConstraints(this.equationColumnComboBox, c);
        this.mainPanel.add(this.equationColumnComboBox);
        c.fill = 2;
        this.columnNameTextField = GridBagHelper.addTextRow(this.mainPanel, Locale.getString("COLUMN_NAME"), "", gridbag, c, 18);
        this.equationComboBox = GridBagHelper.addEquationRow(this.mainPanel, Locale.getString("EQUATION"), "", gridbag, c);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(Locale.getString("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(Locale.getString("CANCEL"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.mainPanel, "North");
        this.getContentPane().add((Component)buttonPanel, "South");
        Dimension size = this.getPreferredSize();
        int x = (DesktopManager.getDesktop().getWidth() - size.width) / 2;
        int y = (DesktopManager.getDesktop().getHeight() - size.height) / 2;
        this.setBounds(x, y, size.width, size.height);
    }

    public boolean showDialog(EquationColumn[] equationColumns) {
        this.equationColumns = new EquationColumn[equationColumns.length];
        for (int i = 0; i < equationColumns.length; ++i) {
            this.equationColumns[i] = (EquationColumn)equationColumns[i].clone();
        }
        this.displayEquationColumn(0);
        DesktopManager.getDesktop().add(this);
        this.show();
        try {
            while (!this.isDone) {
                Thread.sleep(10L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.OKButtonPressed;
    }

    public EquationColumn[] getEquationColumns() {
        return this.equationColumns;
    }

    private void saveEquationColumn(int column) {
        this.equationColumns[column].setShortName(this.columnNameTextField.getText());
        this.equationColumns[column].setEquation(this.equationComboBox.getEquationText());
    }

    private void displayEquationColumn(int column) {
        this.currentEquationColumn = column;
        this.columnNameTextField.setText(this.equationColumns[column].getShortName());
        this.equationComboBox.setEquationText(this.equationColumns[column].getEquation());
    }

    private boolean parseEquations() {
        boolean success = true;
        int i = 0;
        try {
            for (i = 0; i < this.equationColumns.length; ++i) {
                String equationString = this.equationColumns[i].getEquation();
                if (equationString != null && equationString.length() > 0) {
                    this.equationColumns[i].setExpression(Parser.parse(equationString));
                    continue;
                }
                this.equationColumns[i].setExpression(null);
            }
        }
        catch (ExpressionException e) {
            JOptionPane.showInternalMessageDialog(this, e.getReason(), Locale.getString("ERROR_PARSING_EQUATION"), 0);
            success = false;
        }
        return success;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.saveEquationColumn(this.currentEquationColumn);
            if (this.parseEquations()) {
                this.OKButtonPressed = true;
                this.dispose();
                this.isDone = true;
            }
        } else if (e.getSource() == this.cancelButton) {
            this.saveEquationColumn(this.currentEquationColumn);
            this.OKButtonPressed = false;
            this.dispose();
            this.isDone = true;
        } else if (e.getSource() == this.equationColumnComboBox) {
            this.saveEquationColumn(this.currentEquationColumn);
            this.displayEquationColumn(this.equationColumnComboBox.getSelectedIndex());
        }
    }
}

