/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.mov.main.CommandManager;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.StoredEquation;
import org.mov.ui.DesktopManager;
import org.mov.ui.ExpressionEditorDialog;
import org.mov.util.Locale;

public class EquationComboBox
extends JComboBox
implements PopupMenuListener {
    static List storedEquations;
    private boolean isDialogUp = false;
    private JTextField textField;

    public EquationComboBox() {
        this("");
    }

    public EquationComboBox(String equationText) {
        this.setEditable(true);
        if (storedEquations == null) {
            EquationComboBox.updateEquations();
        }
        this.setEquationText(equationText);
        this.addPopupMenuListener(this);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JTextField)) continue;
            this.textField = (JTextField)component;
        }
        this.textField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                EquationComboBox.this.handleMouseClicked(event);
            }
        });
        this.updateItems();
    }

    public String getEquationText() {
        String text = this.getText();
        StoredEquation storedEquation = this.findStoredEquationByName(text);
        if (storedEquation != null) {
            return storedEquation.equation;
        }
        return text;
    }

    public boolean isStoredEquation() {
        return this.findStoredEquationByName(this.getText()) != null;
    }

    public void setEquationText(String equationText) {
        StoredEquation storedEquation = this.findStoredEquationByEquation(equationText);
        if (storedEquation != null) {
            this.setSelectedItem(storedEquation.name);
        } else {
            this.setSelectedItem(equationText);
        }
    }

    public static void updateEquations() {
        storedEquations = PreferencesManager.loadStoredEquations();
    }

    private StoredEquation findStoredEquationByName(String name) {
        Iterator iterator = storedEquations.iterator();
        while (iterator.hasNext()) {
            StoredEquation storedEquation = (StoredEquation)iterator.next();
            if (!storedEquation.name.equals(name)) continue;
            return storedEquation;
        }
        return null;
    }

    private StoredEquation findStoredEquationByEquation(String equation) {
        Iterator iterator = storedEquations.iterator();
        while (iterator.hasNext()) {
            StoredEquation storedEquation = (StoredEquation)iterator.next();
            if (!storedEquation.equation.equals(equation)) continue;
            return storedEquation;
        }
        return null;
    }

    private void updateItems() {
        ArrayList<String> menuItems = new ArrayList<String>();
        String current = this.getText();
        menuItems.add(current);
        ArrayList<String> stored = new ArrayList<String>();
        Iterator iterator = storedEquations.iterator();
        while (iterator.hasNext()) {
            StoredEquation storedEquation = (StoredEquation)iterator.next();
            if (storedEquation.name.equals(current)) continue;
            stored.add(storedEquation.name);
        }
        Collections.sort(stored);
        menuItems.addAll(stored);
        this.removeAllItems();
        iterator = menuItems.iterator();
        while (iterator.hasNext()) {
            this.addItem((String)iterator.next());
        }
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.updateItems();
    }

    private void showAddDialog() {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                if (!EquationComboBox.this.isDialogUp) {
                    EquationComboBox.this.isDialogUp = true;
                    StoredEquation storedEquation = ExpressionEditorDialog.showAddDialog(storedEquations, Locale.getString("ADD_EQUATION"), EquationComboBox.this.getText());
                    if (storedEquation != null) {
                        EquationComboBox.this.setEquationText(storedEquation.name);
                        storedEquations.add(storedEquation);
                        PreferencesManager.saveStoredEquations(storedEquations);
                    }
                    EquationComboBox.this.isDialogUp = false;
                }
            }
        });
        thread2.start();
    }

    private void showDeleteDialog() {
        if (!this.isDialogUp) {
            int option;
            this.isDialogUp = true;
            StoredEquation storedEquation = this.findStoredEquationByName(this.getText());
            if (storedEquation != null && (option = JOptionPane.showInternalConfirmDialog(DesktopManager.getDesktop(), Locale.getString("SURE_DELETE_EQUATION", this.getText()), Locale.getString("DELETE_EQUATION"), 0)) == 0) {
                storedEquations.remove(storedEquation);
                PreferencesManager.saveStoredEquations(storedEquations);
                this.setEquationText("");
            }
            this.isDialogUp = false;
        }
    }

    private void showEditDialog() {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                if (!EquationComboBox.this.isDialogUp) {
                    EquationComboBox.this.isDialogUp = true;
                    if (EquationComboBox.this.isStoredEquation()) {
                        StoredEquation storedEquation = EquationComboBox.this.findStoredEquationByName(EquationComboBox.this.getText());
                        if (storedEquation != null) {
                            storedEquation = ExpressionEditorDialog.showEditDialog(storedEquations, Locale.getString("EDIT_EQUATION"), storedEquation);
                            EquationComboBox.this.setEquationText(storedEquation.equation);
                            PreferencesManager.saveStoredEquations(storedEquations);
                        }
                    } else {
                        String equationText = EquationComboBox.this.getEquationText();
                        String newEquationText = ExpressionEditorDialog.showEditDialog(Locale.getString("EDIT_EQUATION"), equationText);
                        EquationComboBox.this.setEquationText(newEquationText);
                    }
                    EquationComboBox.this.isDialogUp = false;
                }
            }
        });
        thread2.start();
    }

    private String getText() {
        return this.textField.getText();
    }

    private void handleMouseClicked(MouseEvent event) {
        if (event.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem editMenuItem = new JMenuItem(Locale.getString("EDIT"));
            editMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EquationComboBox.this.showEditDialog();
                }
            });
            menu.add(editMenuItem);
            boolean isStoredEquation = this.isStoredEquation();
            JMenuItem addMenuItem = new JMenuItem(Locale.getString("ADD"));
            addMenuItem.setEnabled(!isStoredEquation);
            addMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EquationComboBox.this.showAddDialog();
                }
            });
            menu.add(addMenuItem);
            JMenuItem deleteMenuItem = new JMenuItem(Locale.getString("DELETE"));
            deleteMenuItem.setEnabled(isStoredEquation);
            deleteMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EquationComboBox.this.showDeleteDialog();
                }
            });
            menu.add(deleteMenuItem);
            menu.addSeparator();
            JMenuItem manageMenuItem = new JMenuItem(Locale.getString("MANAGE"));
            manageMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CommandManager commandManager = CommandManager.getInstance();
                    commandManager.openPreferences(0);
                }
            });
            menu.add(manageMenuItem);
            Point point = event.getPoint();
            menu.show(this, point.x, point.y);
        }
    }
}

