/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mov.main.ModuleFrame;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.StoredEquation;
import org.mov.ui.DesktopManager;
import org.mov.ui.EquationComboBox;
import org.mov.util.Locale;

public class ExpressionEditorDialog {
    private boolean isUp = true;
    private boolean wasCancelled = false;
    private JInternalFrame internalFrame;
    private String name;
    private String equation;
    private static final int NAME_WIDTH = 20;
    private static final int EQUATION_ROWS = 14;
    private static final int EQUATION_COLUMNS = 30;
    private static final int OK_BUTTON = 0;
    private static final int OK_CANCEL_BUTTON = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ExpressionEditorDialog(String title, boolean displayName, String name, String equation, int buttonArray, boolean isEditable) {
        this.name = name;
        this.equation = equation;
        if (!$assertionsDisabled && buttonArray != 0 && buttonArray != 1) {
            throw new AssertionError();
        }
        this.buildDialog(title, displayName, buttonArray, isEditable);
    }

    private void buildDialog(String title, final boolean displayName, int buttonArray, boolean isEditable) {
        this.internalFrame = new JInternalFrame(title, true, false, false, false);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        final JTextField nameField = new JTextField(this.name, 20);
        if (displayName) {
            JPanel innerNamePanel = new JPanel();
            innerNamePanel.add(new JLabel(Locale.getString("NAME")));
            innerNamePanel.add(nameField);
            JPanel namePanel = new JPanel();
            namePanel.setLayout(new BorderLayout());
            namePanel.add((Component)innerNamePanel, "West");
            panel.add((Component)namePanel, "North");
        }
        JPanel equationPanel = new JPanel();
        final JTextArea equationEditor = new JTextArea(14, 30);
        equationEditor.setText(this.equation);
        equationEditor.setEditable(isEditable);
        TitledBorder titledBorder = new TitledBorder(Locale.getString("EQUATION"));
        equationPanel.setLayout(new BorderLayout());
        equationPanel.setBorder(titledBorder);
        equationPanel.add(new JScrollPane(equationEditor));
        panel.add((Component)equationPanel, "Center");
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton(Locale.getString("OK"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (displayName) {
                    ExpressionEditorDialog.this.setName(nameField.getText());
                }
                ExpressionEditorDialog.this.setEquation(equationEditor.getText());
                ExpressionEditorDialog.this.wasCancelled = false;
                ExpressionEditorDialog.this.close();
            }
        });
        buttonPanel.add(okButton);
        if (buttonArray == 1) {
            JButton cancelButton = new JButton(Locale.getString("CANCEL"));
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExpressionEditorDialog.this.wasCancelled = true;
                    ExpressionEditorDialog.this.close();
                }
            });
            buttonPanel.add(cancelButton);
        }
        panel.add((Component)buttonPanel, "South");
        this.internalFrame.getContentPane().add(panel);
        Dimension preferred = this.internalFrame.getPreferredSize();
        this.internalFrame.setMinimumSize(preferred);
        ModuleFrame.setSizeAndLocation(this.internalFrame, DesktopManager.getDesktop(), true, true);
        DesktopManager.getDesktop().add(this.internalFrame);
        this.internalFrame.show();
        try {
            this.internalFrame.setSelected(true);
        }
        catch (PropertyVetoException v) {
            // empty catch block
        }
        this.internalFrame.moveToFront();
    }

    private void close() {
        this.isUp = false;
        try {
            this.internalFrame.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private boolean isUp() {
        return this.isUp;
    }

    private String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    private String getEquation() {
        return this.equation;
    }

    private void setEquation(String equation) {
        this.equation = equation;
    }

    private boolean waitUntilClosed() {
        try {
            while (this.isUp()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.wasCancelled;
    }

    public static StoredEquation showAddDialog(List storedEquations, String title, String equation) {
        boolean isValid = false;
        String name = "";
        StoredEquation storedEquation = null;
        while (!isValid) {
            ExpressionEditorDialog dialog = new ExpressionEditorDialog(title, true, name, equation, 1, true);
            boolean wasCancelled = dialog.waitUntilClosed();
            name = dialog.getName();
            equation = dialog.getEquation();
            if (!wasCancelled) {
                isValid = ExpressionEditorDialog.validateStoredEquation(storedEquations, null, name);
                if (!isValid) continue;
                storedEquation = new StoredEquation(name, equation);
                continue;
            }
            isValid = true;
        }
        return storedEquation;
    }

    public static StoredEquation showAddDialog(List storedEquations, String title) {
        return ExpressionEditorDialog.showAddDialog(storedEquations, title, "");
    }

    public static StoredEquation showAddDialog(String title, String equation) {
        List storedEquations = PreferencesManager.loadStoredEquations();
        StoredEquation storedEquation = ExpressionEditorDialog.showAddDialog(storedEquations, title, equation);
        if (storedEquation != null) {
            storedEquations.add(storedEquation);
            PreferencesManager.saveStoredEquations(storedEquations);
            EquationComboBox.updateEquations();
        }
        return storedEquation;
    }

    public static String showEditDialog(String title, String equation) {
        ExpressionEditorDialog dialog = new ExpressionEditorDialog(title, false, "", equation, 1, true);
        dialog.waitUntilClosed();
        return dialog.getEquation();
    }

    public static StoredEquation showEditDialog(List storedEquations, String title, StoredEquation storedEquation) {
        boolean isValid = false;
        String oldName = new String(storedEquation.name);
        String name = storedEquation.name;
        String equation = storedEquation.equation;
        while (!isValid) {
            ExpressionEditorDialog dialog = new ExpressionEditorDialog(title, true, name, equation, 1, true);
            boolean wasCancelled = dialog.waitUntilClosed();
            name = dialog.getName();
            equation = dialog.getEquation();
            if (!wasCancelled) {
                isValid = ExpressionEditorDialog.validateStoredEquation(storedEquations, oldName, name);
                if (!isValid) continue;
                storedEquation.name = name;
                storedEquation.equation = equation;
                continue;
            }
            isValid = true;
        }
        return storedEquation;
    }

    public static void showViewDialog(String title, String equation) {
        ExpressionEditorDialog dialog = new ExpressionEditorDialog(title, false, "", equation, 0, false);
        dialog.waitUntilClosed();
    }

    private static boolean validateStoredEquation(List storedEquations, String oldName, String newName) {
        boolean isValid = true;
        if (newName.length() == 0) {
            JOptionPane.showInternalMessageDialog(DesktopManager.getDesktop(), Locale.getString("MISSING_EQUATION_NAME"), Locale.getString("ERROR_STORING_EQUATION"), 0);
            isValid = false;
        } else if (oldName == null || !newName.equals(oldName)) {
            boolean isDuplicateName = false;
            Iterator iterator = storedEquations.iterator();
            while (iterator.hasNext()) {
                StoredEquation traverse = (StoredEquation)iterator.next();
                if (!traverse.name.equals(newName)) continue;
                isDuplicateName = true;
            }
            if (isDuplicateName) {
                JOptionPane.showInternalMessageDialog(DesktopManager.getDesktop(), Locale.getString("DUPLICATE_EQUATION_NAME", newName), Locale.getString("ERROR_STORING_EQUATION"), 0);
                isValid = false;
            }
        }
        return isValid;
    }

    static {
        $assertionsDisabled = !ExpressionEditorDialog.class.desiredAssertionStatus();
    }
}

