/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.mov.macro.StoredMacro;
import org.mov.ui.DesktopManager;
import org.mov.util.Locale;

public class MacroEditor
extends JInternalFrame
implements ActionListener {
    private boolean is_ok;
    private JPanel jPanel = null;
    private JPanel jPanel2 = null;
    private JPanel jPanel3 = null;
    private JTextField name_txt = null;
    private JTextArea macro_txt = null;
    private JButton ok_btn = null;
    private JButton cancel_btn = null;
    private JScrollPane jScrollPane = null;
    private JTextField file_txt = null;
    private JPanel jPanel5 = null;
    private JPanel jPanel1 = null;
    StoredMacro macro;

    public MacroEditor(StoredMacro m) {
        this.macro = m;
        this.initialize();
    }

    private void initialize() {
        this.setSize(350, 249);
        this.setMaximizable(true);
        this.setContentPane(this.getJPanel());
        this.is_ok = false;
        this.setResizable(true);
        this.setClosable(true);
        this.setTitle(Locale.getString("EDITMACRO") + " " + this.macro.getName());
        this.name_txt.setText(this.macro.getName());
        this.file_txt.setText(this.macro.getFilename());
        this.macro_txt.setText(this.macro.getCode());
        this.setVisible(true);
        DesktopManager.getDesktop().add(this);
        if (this.macro.getCode().length() > 0) {
            this.jScrollPane.setPreferredSize(this.macro_txt.getPreferredScrollableViewportSize());
        }
        this.pack();
        this.setLocation(DesktopManager.getDesktop().getWidth() / 2 - this.getWidth() / 2, DesktopManager.getDesktop().getHeight() / 2 - this.getHeight() / 2);
        this.moveToFront();
    }

    public boolean isOk_clicked() {
        return this.is_ok;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJPanel1(), "North");
            this.jPanel.add((Component)this.getJPanel2(), "Center");
            this.jPanel.add((Component)this.getJPanel3(), "South");
        }
        return this.jPanel;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new CardLayout());
            this.jPanel2.add((Component)this.getJScrollPane(), this.getJScrollPane().getName());
        }
        return this.jPanel2;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.add((Component)this.getJButton(), null);
            this.jPanel3.add((Component)this.getJButton1(), null);
        }
        return this.jPanel3;
    }

    private JTextField getJTextField() {
        if (this.name_txt == null) {
            this.name_txt = new JTextField();
            this.name_txt.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    if (MacroEditor.this.macro.getFilename().length() == 0 && MacroEditor.this.name_txt.getText().length() > 0) {
                        MacroEditor.this.file_txt.setText(((JTextField)e.getSource()).getText() + ".py");
                    } else if (MacroEditor.this.macro.getFilename().length() == 0) {
                        MacroEditor.this.file_txt.setText("");
                    }
                    MacroEditor.this.setTitle(Locale.getString("EDITMACRO") + " " + MacroEditor.this.name_txt.getText());
                }
            });
        }
        return this.name_txt;
    }

    private JTextArea getJTextArea() {
        if (this.macro_txt == null) {
            this.macro_txt = new JTextArea();
        }
        return this.macro_txt;
    }

    private JButton getJButton() {
        if (this.ok_btn == null) {
            this.ok_btn = new JButton();
            this.ok_btn.setText(Locale.getString("OK"));
            this.ok_btn.addActionListener(this);
        }
        return this.ok_btn;
    }

    private JButton getJButton1() {
        if (this.cancel_btn == null) {
            this.cancel_btn = new JButton();
            this.cancel_btn.setText(Locale.getString("CANCEL"));
            this.cancel_btn.addActionListener(this);
        }
        return this.cancel_btn;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.ok_btn)) {
            this.macro.setName(this.name_txt.getText());
            this.macro.setFilename(this.file_txt.getText());
            this.macro.setCode(this.macro_txt.getText());
            this.macro.save();
            this.is_ok = true;
        }
        try {
            this.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setName("jScrollPane");
            this.jScrollPane.setViewportView(this.getJTextArea());
            this.jScrollPane.setPreferredSize(new Dimension(200, 80));
        }
        return this.jScrollPane;
    }

    private JTextField getJTextField2() {
        if (this.file_txt == null) {
            this.file_txt = new JTextField();
        }
        return this.file_txt;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            JLabel jLabel1 = new JLabel();
            JLabel jLabel = new JLabel();
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            jLabel.setText(Locale.getString("MACRONAME"));
            jLabel1.setText(Locale.getString("FILE"));
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(9, 3, 9, 2);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(5, 3, 5, 2);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(9, 3, 9, 2);
            gridBagConstraints3.anchor = 10;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(5, 3, 5, 2);
            this.jPanel1.add((Component)jLabel, gridBagConstraints1);
            this.jPanel1.add((Component)this.getJTextField(), gridBagConstraints2);
            this.jPanel1.add((Component)jLabel1, gridBagConstraints3);
            this.jPanel1.add((Component)this.getJTextField2(), gridBagConstraints4);
        }
        return this.jPanel1;
    }
}

