/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.mov.macro.MacroManager;
import org.mov.macro.StoredMacro;
import org.mov.main.CommandManager;
import org.mov.main.Module;
import org.mov.portfolio.Portfolio;
import org.mov.prefs.PreferencesManager;
import org.mov.ui.DesktopManager;
import org.mov.ui.MenuHelper;
import org.mov.ui.ModuleEvent;
import org.mov.ui.ModuleListener;
import org.mov.util.Locale;

public class MainMenu
implements ActionListener,
ModuleListener {
    private JMenuBar menuBar;
    private JMenuItem filePortfolioNewMenuItem;
    private JMenuItem fileImportPreferencesMenuItem;
    private JMenuItem fileImportQuotesMenuItem;
    private JMenuItem fileExportPreferencesMenuItem;
    private JMenuItem fileExportQuotesMenuItem;
    private JMenuItem filePreferencesMenuItem;
    private JMenuItem fileExitMenuItem;
    private JMenuItem graphCommodityCodeMenuItem;
    private JMenuItem graphCommodityNameMenuItem;
    private JMenuItem graphMarketAdvanceDeclineMenuItem;
    private JMenuItem quoteWatchScreenNewMenuItem;
    private JMenuItem quoteCompanyListAllMenuItem;
    private JMenuItem quoteCompanyListRuleMenuItem;
    private JMenuItem quoteCompanyListDateMenuItem;
    private JMenuItem quoteIndicesListAllMenuItem;
    private JMenuItem quoteIndicesListRuleMenuItem;
    private JMenuItem quoteIndicesListDateMenuItem;
    private JMenuItem quoteCommoditiesListAllMenuItem;
    private JMenuItem quoteCommoditiesListRuleMenuItem;
    private JMenuItem quoteCommoditiesListDateMenuItem;
    private JMenuItem quoteStocksListSymbolsMenuItem;
    private JMenuItem analysisPaperTradeMenuItem;
    private JMenuItem analysisGPMenuItem;
    private JMenuItem analysisGAMenuItem;
    private JMenuItem windowTileHorizontalMenuItem;
    private JMenuItem windowTileVerticalMenuItem;
    private JMenuItem windowCascadeMenuItem;
    private JMenuItem windowGridMenuItem;
    private JMenuItem macroManageMenuItem;
    private JMenuItem helpContentsMenuItem;
    private JMenuItem helpAboutMenuItem;
    private JMenuItem helpViewLicenseMenuItem;
    private JMenu helpMenu;
    private JMenu windowMenu;
    private JMenu filePortfolioMenu;
    private JMenu fileImportMenu;
    private JMenu fileExportMenu;
    private JMenu graphPortfolioMenu;
    private JMenu tablePortfolioMenu;
    private JMenu quoteWatchScreenMenu;
    private JMenu macroMenu;
    private DesktopManager desktopManager;
    private JDesktopPane desktop;
    private JFrame frame;
    private HashMap portfolioHash = new HashMap();
    private HashMap portfolioGraphHash = new HashMap();
    private HashMap portfolioTableHash = new HashMap();
    private HashMap watchScreenHash = new HashMap();
    private Hashtable moduleToMenuItemHash = new Hashtable();
    private Hashtable menuItemToModuleHash = new Hashtable();
    private Hashtable menuItemToMacroHash = new Hashtable();
    private static MainMenu instance = null;
    static /* synthetic */ Class class$org$mov$ui$MainMenu;

    public static MainMenu getInstance(JFrame frame, DesktopManager desktopManager) {
        if (instance == null) {
            instance = new MainMenu(frame, desktopManager);
        }
        return instance;
    }

    public static MainMenu getInstance() {
        return instance;
    }

    private MainMenu(JFrame frame, DesktopManager desktopManager) {
        this.frame = frame;
        this.desktopManager = desktopManager;
        this.desktop = DesktopManager.getDesktop();
        desktopManager.addModuleListener(this);
        this.menuBar = new JMenuBar();
        JMenu fileMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("FILE"), 'F');
        this.filePortfolioMenu = MenuHelper.addMenu(fileMenu, Locale.getString("PORTFOLIO"), 'P');
        fileMenu.addSeparator();
        this.fileImportMenu = MenuHelper.addMenu(fileMenu, Locale.getString("IMPORT"), 'I');
        this.fileImportPreferencesMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.fileImportMenu, Locale.getString("PREFERENCES"));
        this.fileImportQuotesMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.fileImportMenu, Locale.getString("QUOTES"));
        this.fileExportMenu = MenuHelper.addMenu(fileMenu, Locale.getString("EXPORT"), 'E');
        this.fileExportPreferencesMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.fileExportMenu, Locale.getString("PREFERENCES"));
        this.fileExportQuotesMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.fileExportMenu, Locale.getString("QUOTES"));
        this.filePreferencesMenuItem = MenuHelper.addMenuItem((ActionListener)this, fileMenu, Locale.getString("PREFERENCES"), 'R');
        fileMenu.addSeparator();
        this.fileExitMenuItem = MenuHelper.addMenuItem((ActionListener)this, fileMenu, Locale.getString("EXIT"), 'Q');
        JMenu quoteMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("TABLE"), 'T');
        this.quoteWatchScreenMenu = MenuHelper.addMenu(quoteMenu, Locale.getString("WATCH_SCREEN"), 'W');
        quoteMenu.addSeparator();
        JMenu quoteMenuCompany = MenuHelper.addMenu(quoteMenu, Locale.getString("ALL_ORDINARIES"), 'C');
        this.quoteCompanyListAllMenuItem = MenuHelper.addMenuItem((ActionListener)this, quoteMenuCompany, Locale.getString("LIST_ALL"));
        this.quoteCompanyListRuleMenuItem = MenuHelper.addMenuItem((ActionListener)this, quoteMenuCompany, Locale.getString("LIST_BY_RULE"));
        this.quoteCompanyListDateMenuItem = MenuHelper.addMenuItem((ActionListener)this, quoteMenuCompany, Locale.getString("LIST_BY_DATE"));
        JMenu quoteMenuIndices = MenuHelper.addMenu(quoteMenu, Locale.getString("MARKET_INDICES"), 'I');
        this.quoteIndicesListAllMenuItem = MenuHelper.addMenuItem((ActionListener)this, quoteMenuIndices, Locale.getString("LIST_ALL"));
        this.quoteIndicesListRuleMenuItem = MenuHelper.addMenuItem((ActionListener)this, quoteMenuIndices, Locale.getString("LIST_BY_RULE"));
        this.quoteIndicesListDateMenuItem = MenuHelper.addMenuItem((ActionListener)this, quoteMenuIndices, Locale.getString("LIST_BY_DATE"));
        JMenu quoteMenuCommodities = MenuHelper.addMenu(quoteMenu, Locale.getString("ALL_STOCKS"), 'A');
        this.quoteCommoditiesListAllMenuItem = MenuHelper.addMenuItem((ActionListener)this, quoteMenuCommodities, Locale.getString("LIST_ALL"), 'L');
        this.quoteCommoditiesListRuleMenuItem = MenuHelper.addMenuItem((ActionListener)this, quoteMenuCommodities, Locale.getString("LIST_BY_RULE"), 'B');
        this.quoteCommoditiesListDateMenuItem = MenuHelper.addMenuItem((ActionListener)this, quoteMenuCommodities, Locale.getString("LIST_BY_DATE"), 'D');
        JMenu quoteMenuStocks = MenuHelper.addMenu(quoteMenu, Locale.getString("STOCKS"), 'S');
        this.quoteStocksListSymbolsMenuItem = MenuHelper.addMenuItem((ActionListener)this, quoteMenuStocks, Locale.getString("LIST_BY_SYMBOLS"), 'B');
        quoteMenu.addSeparator();
        this.tablePortfolioMenu = MenuHelper.addMenu(quoteMenu, Locale.getString("PORTFOLIO"));
        JMenu graphMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("GRAPH"), 'G');
        JMenu graphCommodityMenu = MenuHelper.addMenu(graphMenu, Locale.getString("STOCK"));
        this.graphCommodityCodeMenuItem = MenuHelper.addMenuItem((ActionListener)this, graphCommodityMenu, Locale.getString("GRAPH_BY_SYMBOLS"), 'G');
        JMenu graphMarketIndicator = MenuHelper.addMenu(graphMenu, Locale.getString("MARKET_INDICATOR"));
        this.graphMarketAdvanceDeclineMenuItem = MenuHelper.addMenuItem((ActionListener)this, graphMarketIndicator, Locale.getString("ADVANCE_DECLINE"));
        this.graphPortfolioMenu = MenuHelper.addMenu(graphMenu, Locale.getString("PORTFOLIO"));
        JMenu analysisMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("ANALYSIS"), 'A');
        this.analysisPaperTradeMenuItem = MenuHelper.addMenuItem((ActionListener)this, analysisMenu, Locale.getString("PAPER_TRADE"));
        this.analysisGPMenuItem = MenuHelper.addMenuItem((ActionListener)this, analysisMenu, Locale.getString("GP"));
        this.analysisGAMenuItem = MenuHelper.addMenuItem((ActionListener)this, analysisMenu, Locale.getString("GA"));
        this.windowMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("WINDOW"), 'W');
        this.windowTileHorizontalMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.windowMenu, Locale.getString("TILE_HORIZONTALLY"));
        this.windowTileHorizontalMenuItem.setEnabled(false);
        this.windowTileVerticalMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.windowMenu, Locale.getString("TILE_VERTICALLY"));
        this.windowTileVerticalMenuItem.setEnabled(false);
        this.windowCascadeMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.windowMenu, Locale.getString("CASCADE"));
        this.windowCascadeMenuItem.setEnabled(false);
        this.windowGridMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.windowMenu, Locale.getString("ARRANGE_ALL"));
        this.windowGridMenuItem.setEnabled(false);
        this.macroMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("MACRO"), 'M');
        this.buildMacroMenu();
        this.helpMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("HELP"), 'H');
        this.helpAboutMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.helpMenu, Locale.getString("ABOUT"));
        this.helpContentsMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.helpMenu, Locale.getString("CONTENTS"));
        this.helpViewLicenseMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.helpMenu, Locale.getString("VIEW_LICENSE"));
        this.updatePortfolioMenu();
        this.updateWatchScreenMenu();
        frame.setJMenuBar(this.menuBar);
    }

    public void actionPerformed(final ActionEvent e) {
        Thread menuAction = new Thread(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void run() {
                JMenuItem menu = (JMenuItem)e.getSource();
                Object mo = MainMenu.this.menuItemToMacroHash.get(menu);
                if (mo != null) {
                    try {
                        StoredMacro stored_macro = (StoredMacro)mo;
                        MacroManager.execute(stored_macro);
                    }
                    catch (ClassCastException e2) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        return;
                    }
                    catch (NoClassDefFoundError e3) {
                        JOptionPane.showInternalMessageDialog(MainMenu.this.desktop, Locale.getString("NO_JYTHON_ERROR", e3.getMessage()), Locale.getString("MACRO_EXECUTION_ERROR"), 0);
                    }
                } else {
                    mo = MainMenu.this.menuItemToModuleHash.get(menu);
                    if (mo != null) {
                        Module module;
                        try {
                            module = (Module)mo;
                        }
                        catch (ClassCastException e4) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            return;
                        }
                        Container component = module.getComponent();
                        while (!(component instanceof JInternalFrame)) {
                            component = component.getParent();
                        }
                        JInternalFrame frame = (JInternalFrame)component;
                        try {
                            frame.setIcon(false);
                            MainMenu.this.desktop.setSelectedFrame(frame);
                            frame.setSelected(true);
                            frame.toFront();
                        }
                        catch (PropertyVetoException exception) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                    } else if (menu == MainMenu.this.macroManageMenuItem) {
                        CommandManager.getInstance().openPreferences(4);
                    } else if (menu == MainMenu.this.fileImportPreferencesMenuItem) {
                        CommandManager.getInstance().importPreferences();
                    } else if (menu == MainMenu.this.fileExportPreferencesMenuItem) {
                        CommandManager.getInstance().exportPreferences();
                    } else if (menu == MainMenu.this.fileExportQuotesMenuItem) {
                        CommandManager.getInstance().exportQuotes();
                    } else if (menu == MainMenu.this.fileImportQuotesMenuItem) {
                        CommandManager.getInstance().importQuotes();
                    } else if (menu == MainMenu.this.filePortfolioNewMenuItem) {
                        CommandManager.getInstance().newPortfolio();
                    } else if (MainMenu.this.portfolioHash.get(menu) != null) {
                        String portfolioName = (String)MainMenu.this.portfolioHash.get(menu);
                        CommandManager.getInstance().openPortfolio(portfolioName);
                    } else {
                        if (menu == MainMenu.this.fileExitMenuItem) {
                            MainMenu.this.frame.dispose();
                            return;
                        }
                        if (menu == MainMenu.this.filePreferencesMenuItem) {
                            CommandManager.getInstance().openPreferences();
                        } else if (menu == MainMenu.this.quoteWatchScreenNewMenuItem) {
                            CommandManager.getInstance().newWatchScreen();
                        } else if (MainMenu.this.watchScreenHash.get(menu) != null) {
                            String watchScreenName = (String)MainMenu.this.watchScreenHash.get(menu);
                            CommandManager.getInstance().openWatchScreen(watchScreenName);
                        } else if (menu == MainMenu.this.quoteCommoditiesListAllMenuItem) {
                            CommandManager.getInstance().tableStocks(2);
                        } else if (menu == MainMenu.this.quoteCommoditiesListRuleMenuItem) {
                            CommandManager.getInstance().tableStocksByRule(2);
                        } else if (menu == MainMenu.this.quoteCommoditiesListDateMenuItem) {
                            CommandManager.getInstance().tableStocksByDate(2);
                        } else if (menu == MainMenu.this.quoteCompanyListAllMenuItem) {
                            CommandManager.getInstance().tableStocks(1);
                        } else if (menu == MainMenu.this.quoteCompanyListRuleMenuItem) {
                            CommandManager.getInstance().tableStocksByRule(1);
                        } else if (menu == MainMenu.this.quoteCompanyListDateMenuItem) {
                            CommandManager.getInstance().tableStocksByDate(1);
                        } else if (menu == MainMenu.this.quoteIndicesListAllMenuItem) {
                            CommandManager.getInstance().tableStocks(3);
                        } else if (menu == MainMenu.this.quoteIndicesListRuleMenuItem) {
                            CommandManager.getInstance().tableStocksByRule(3);
                        } else if (menu == MainMenu.this.quoteIndicesListDateMenuItem) {
                            CommandManager.getInstance().tableStocksByDate(3);
                        } else if (menu == MainMenu.this.quoteStocksListSymbolsMenuItem) {
                            CommandManager.getInstance().tableStocks(null);
                        } else if (MainMenu.this.portfolioTableHash.get(menu) != null) {
                            String portfolioName = (String)MainMenu.this.portfolioTableHash.get(menu);
                            Portfolio portfolio = PreferencesManager.loadPortfolio(portfolioName);
                            CommandManager.getInstance().tablePortfolio(portfolio);
                        } else if (menu == MainMenu.this.graphCommodityCodeMenuItem) {
                            CommandManager.getInstance().graphStockBySymbol(null);
                        } else if (menu == MainMenu.this.graphMarketAdvanceDeclineMenuItem) {
                            CommandManager.getInstance().graphAdvanceDecline();
                        } else if (MainMenu.this.portfolioGraphHash.get(menu) != null) {
                            String portfolioName = (String)MainMenu.this.portfolioGraphHash.get(menu);
                            Portfolio portfolio = PreferencesManager.loadPortfolio(portfolioName);
                            CommandManager.getInstance().graphPortfolio(portfolio);
                        } else if (menu == MainMenu.this.analysisPaperTradeMenuItem) {
                            CommandManager.getInstance().paperTrade();
                        } else if (menu == MainMenu.this.analysisGPMenuItem) {
                            CommandManager.getInstance().gp();
                        } else if (menu == MainMenu.this.analysisGAMenuItem) {
                            CommandManager.getInstance().ga();
                        } else if (menu == MainMenu.this.windowTileHorizontalMenuItem) {
                            CommandManager.getInstance().tileFramesHorizontal();
                        } else if (menu == MainMenu.this.windowTileVerticalMenuItem) {
                            CommandManager.getInstance().tileFramesVertical();
                        } else if (menu == MainMenu.this.windowCascadeMenuItem) {
                            CommandManager.getInstance().tileFramesCascade();
                        } else if (menu == MainMenu.this.windowGridMenuItem) {
                            CommandManager.getInstance().tileFramesArrange();
                        } else if (menu == MainMenu.this.helpContentsMenuItem) {
                            CommandManager.getInstance().openHelp();
                        } else if (menu == MainMenu.this.helpAboutMenuItem) {
                            CommandManager.getInstance().openAboutDialog();
                        } else if (menu == MainMenu.this.helpViewLicenseMenuItem) {
                            CommandManager.getInstance().openLicenseDialog();
                        } else if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$mov$ui$MainMenu == null ? (class$org$mov$ui$MainMenu = MainMenu.class$("org.mov.ui.MainMenu")) : class$org$mov$ui$MainMenu).desiredAssertionStatus();
            }
        };
        menuAction.start();
    }

    public void moduleAdded(ModuleEvent moduleEvent) {
        Module module = (Module)moduleEvent.getSource();
        String title = module.getTitle();
        if (this.moduleToMenuItemHash.size() == 0) {
            this.windowTileHorizontalMenuItem.setEnabled(true);
            this.windowTileVerticalMenuItem.setEnabled(true);
            this.windowCascadeMenuItem.setEnabled(true);
            this.windowGridMenuItem.setEnabled(true);
            this.windowMenu.addSeparator();
        }
        JMenuItem menuItem = MenuHelper.addMenuItem((ActionListener)this, this.windowMenu, title);
        this.moduleToMenuItemHash.put(module, menuItem);
        this.menuItemToModuleHash.put(menuItem, module);
    }

    public void moduleRemoved(ModuleEvent moduleEvent) {
        Module module = (Module)moduleEvent.getSource();
        this.windowMenu.remove((JMenuItem)this.moduleToMenuItemHash.get(module));
        this.menuItemToModuleHash.remove(this.moduleToMenuItemHash.get(module));
        this.moduleToMenuItemHash.remove(module);
        if (this.moduleToMenuItemHash.size() == 0) {
            this.windowTileHorizontalMenuItem.setEnabled(false);
            this.windowTileVerticalMenuItem.setEnabled(false);
            this.windowCascadeMenuItem.setEnabled(false);
            this.windowGridMenuItem.setEnabled(false);
            this.windowMenu.remove(this.windowMenu.getItemCount() - 1);
        }
    }

    public void moduleRenamed(ModuleEvent moduleEvent) {
        this.moduleRemoved(moduleEvent);
        this.moduleAdded(moduleEvent);
    }

    public void updatePortfolioMenu() {
        this.filePortfolioMenu.removeAll();
        this.graphPortfolioMenu.removeAll();
        this.tablePortfolioMenu.removeAll();
        this.filePortfolioNewMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.filePortfolioMenu, Locale.getString("NEW_PORTFOLIO"));
        String[] portfolioNames = PreferencesManager.getPortfolioNames();
        if (portfolioNames.length > 0) {
            this.filePortfolioMenu.addSeparator();
        } else {
            JMenuItem noPortfoliosMenuItem = new JMenuItem(Locale.getString("NO_PORTFOLIOS"));
            noPortfoliosMenuItem.setEnabled(false);
            this.graphPortfolioMenu.add(noPortfoliosMenuItem);
            noPortfoliosMenuItem = new JMenuItem(Locale.getString("NO_PORTFOLIOS"));
            noPortfoliosMenuItem.setEnabled(false);
            this.tablePortfolioMenu.add(noPortfoliosMenuItem);
        }
        this.portfolioHash = this.buildMenu(this.filePortfolioMenu, portfolioNames);
        this.portfolioGraphHash = this.buildMenu(this.graphPortfolioMenu, portfolioNames);
        this.portfolioTableHash = this.buildMenu(this.tablePortfolioMenu, portfolioNames);
    }

    public void updateWatchScreenMenu() {
        this.quoteWatchScreenMenu.removeAll();
        this.quoteWatchScreenNewMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.quoteWatchScreenMenu, Locale.getString("NEW_WATCH_SCREEN"));
        String[] watchScreenNames = PreferencesManager.getWatchScreenNames();
        if (watchScreenNames.length > 0) {
            this.quoteWatchScreenMenu.addSeparator();
        }
        this.watchScreenHash = this.buildMenu(this.quoteWatchScreenMenu, watchScreenNames);
    }

    private HashMap buildMenu(JMenu menu, String[] items) {
        HashMap<JMenuItem, String> menuMap = new HashMap<JMenuItem, String>();
        if (items.length > 0) {
            for (int i = 0; i < items.length; ++i) {
                JMenuItem menuItem = MenuHelper.addMenuItem((ActionListener)this, menu, items[i]);
                menuMap.put(menuItem, items[i]);
            }
        }
        return menuMap;
    }

    public void buildMacroMenu() {
        List stored_macros = PreferencesManager.loadStoredMacros();
        this.macroMenu.removeAll();
        this.menuItemToMacroHash.clear();
        this.macroManageMenuItem = MenuHelper.addMenuItem((ActionListener)this, this.macroMenu, Locale.getString("MANAGE"), 'M');
        this.macroMenu.addSeparator();
        for (int i = 0; i < stored_macros.size(); ++i) {
            StoredMacro m = (StoredMacro)stored_macros.get(i);
            if (!m.isIn_menu()) continue;
            JMenuItem menuItem = MenuHelper.addMenuItem((ActionListener)this, this.macroMenu, m.getName());
            this.menuItemToMacroHash.put(menuItem, m);
        }
    }

    public void disableMenus() {
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            this.menuBar.getMenu(i).setEnabled(false);
        }
    }

    public void enableMenus() {
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            this.menuBar.getMenu(i).setEnabled(true);
        }
    }
}

