/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.text.NumberFormat;

public class PointChangeFormat
implements Comparable {
    double change;

    public PointChangeFormat(double change) {
        this.change = change;
    }

    public PointChangeFormat(double initialValue, double finalValue) {
        this.change = (finalValue - initialValue) * 100.0;
    }

    public double getPointChange() {
        return this.change;
    }

    public String toString() {
        NumberFormat format = NumberFormat.getInstance();
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(1);
        return format.format(this.getPointChange());
    }

    public int compareTo(Object object) {
        PointChangeFormat change = (PointChangeFormat)object;
        if (this.getPointChange() < change.getPointChange()) {
            return -1;
        }
        if (this.getPointChange() > change.getPointChange()) {
            return 1;
        }
        return 0;
    }
}

