/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.mov.ui.ProgressBarUI;
import org.mov.ui.ProgressDialog;
import org.mov.util.Locale;

public class PrimaryProgressDialog
implements ProgressDialog {
    private int progress = 0;
    private int percent = -1;
    private String title;
    private boolean master;
    private JProgressBar progressBar;
    private JLabel noteLabel;
    private JLabel progressLabel;
    private JButton cancelButton;
    private JDialog dialog;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PrimaryProgressDialog(JDesktopPane parent) {
        this.newDialog(parent);
        this.setIndeterminate(true);
    }

    private void newDialog(JDesktopPane parent) {
        final Thread thread2 = Thread.currentThread();
        this.cancelButton = new JButton(Locale.getString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrimaryProgressDialog.this.hide();
                thread2.interrupt();
            }
        });
        this.progressBar = new JProgressBar();
        if (!this.isMacOSX()) {
            this.progressBar.setUI(new ProgressBarUI());
        }
        this.noteLabel = new JLabel(Locale.getString("LOADING"));
        this.progressLabel = new JLabel(Locale.getString("PLEASE_WAIT"));
        JPanel panel = new JPanel();
        BorderLayout layout = new BorderLayout();
        layout.setHgap(50);
        layout.setVgap(5);
        panel.setLayout(layout);
        panel.add((Component)this.noteLabel, "North");
        panel.add((Component)this.progressBar, "Center");
        panel.add((Component)this.progressLabel, "South");
        Object[] options = new Object[]{this.cancelButton};
        JOptionPane optionPane = new JOptionPane(panel, 1, 2, null, options, null);
        this.dialog = optionPane.createDialog(parent, Locale.getString("PROGRESS"));
        this.dialog.setModal(false);
        optionPane.getRootPane().setDefaultButton(this.cancelButton);
    }

    public void hide() {
        this.dialog.setVisible(false);
    }

    public void show(String title) {
        this.setTitle(title);
        this.dialog.setVisible(true);
        this.setProgress(this.getProgress());
    }

    public String getNote() {
        return this.noteLabel.getText();
    }

    public void setNote(String note) {
        if (!this.noteLabel.getText().equals(note)) {
            this.noteLabel.setText(note);
        }
    }

    private void setTitle(String title) {
        this.title = title;
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.isIndeterminate()) {
            this.dialog.setTitle(this.title);
        } else {
            this.dialog.setTitle(this.getPercent() + "% " + this.title);
        }
    }

    public int getMinimum() {
        return this.progressBar.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.setIndeterminate(false);
        this.progressBar.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.progressBar.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.setIndeterminate(false);
        this.progressBar.setMaximum(maximum);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        if (!($assertionsDisabled || progress >= this.getMinimum() && progress <= this.getMaximum())) {
            throw new AssertionError();
        }
        if (this.isIndeterminate()) {
            this.progressLabel.setText(Locale.getString("PLEASE_WAIT"));
        } else {
            int newPercent = this.getPercent();
            if (newPercent != this.percent) {
                this.percent = newPercent;
                this.progressLabel.setText(Locale.getString("PROGRESS_PERCENT", Integer.toString(this.getProgress()), Integer.toString(this.getMaximum()), Integer.toString(newPercent)));
                this.progressBar.setValue(this.getProgress());
                this.progressBar.repaint();
                this.updateTitle();
            }
        }
    }

    public void increment() {
        this.setProgress(this.getProgress() + 1);
    }

    public void decrement() {
        this.setProgress(this.getProgress() - 1);
    }

    public boolean isIndeterminate() {
        return this.progressBar.isIndeterminate();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
        this.progressBar.repaint();
    }

    private int getPercent() {
        if (this.getMaximum() == 0) {
            return 0;
        }
        return this.getProgress() * 100 / this.getMaximum();
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public boolean isMaster() {
        return this.master;
    }

    private boolean isMacOSX() {
        String OS = System.getProperty("os.name");
        return OS.equals("Mac OS X");
    }

    static {
        $assertionsDisabled = !PrimaryProgressDialog.class.desiredAssertionStatus();
    }
}

