/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;

public class ProgressBarUI
extends javax.swing.plaf.ProgressBarUI
implements ImageObserver,
ActionListener {
    private static final Color foregroundColour = new Color(111, 131, 137);
    private static final Color backgroundColour = new Color(238, 241, 238);
    private static final int STRIPE_SIZE = 11;
    private BufferedImage image = null;
    public int startOffset = 0;
    private Timer timer = null;
    private javax.swing.plaf.ProgressBarUI defaultUI;
    JComponent c;

    public static ComponentUI createUI(JComponent c) {
        return new ProgressBarUI();
    }

    public void paint(Graphics g, JComponent c) {
        Insets insets = c.getInsets();
        this.c = c;
        int x = insets.left;
        int y = insets.top;
        int width = c.getWidth() - insets.left - insets.right;
        int height = c.getHeight() - insets.top - insets.bottom;
        JProgressBar bar = (JProgressBar)c;
        int minimum = bar.getMinimum();
        int maximum = bar.getMaximum();
        int value = bar.getValue();
        if (bar.isIndeterminate()) {
            this.paintIndeterminateTimeProgress(g, x, y, width, height);
            if (this.timer == null) {
                this.timer = new Timer(20, this);
            }
            this.timer.start();
        } else {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.paintProgress(g, x, y, width, height, minimum, maximum, value);
        }
        if (((JProgressBar)c).isBorderPainted()) {
            g.setColor(Color.black);
            g.drawRect(x, y, width - 1, height - 1);
        }
    }

    private void paintProgress(Graphics g, int x, int y, int width, int height, int minimum, int maximum, int value) {
        float percent = (float)(value - minimum) / (float)(maximum - minimum);
        int highlightWidth = (int)((float)width * percent);
        g.setColor(foregroundColour);
        g.fillRect(0, 0, highlightWidth, height);
        if (highlightWidth < width) {
            g.setColor(backgroundColour);
            g.fillRect(highlightWidth + 1, y, width - highlightWidth, height);
        }
    }

    private void paintIndeterminateTimeProgress(Graphics g, int x, int y, int width, int height) {
        if (this.image == null) {
            int bufferWidth = width + 44;
            this.image = new BufferedImage(bufferWidth, height, 5);
            Graphics bufferGraphics = this.image.getGraphics();
            bufferGraphics.setColor(backgroundColour);
            bufferGraphics.fillRect(0, 0, bufferWidth, height);
            int xoffset = 0;
            bufferGraphics.setColor(foregroundColour);
            for (int yoffset = 0; yoffset <= height; ++yoffset) {
                this.drawStrippedLine(bufferGraphics, 11, xoffset, yoffset, bufferWidth);
                if (++xoffset < 22) continue;
                xoffset = 0;
            }
        }
        g.drawImage(this.image, -this.startOffset, y, this);
        ++this.startOffset;
        if (this.startOffset >= 22) {
            this.startOffset -= 22;
        }
    }

    private void drawStrippedLine(Graphics g, int stripeSize, int x, int y, int width) {
        for (int xoffset = x; xoffset < width; xoffset += stripeSize * 2) {
            g.drawLine(xoffset, y, xoffset + stripeSize, y);
        }
    }

    public boolean imageUpdate(Image image, int infofloags, int x, int y, int width, int height) {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.c != null) {
            this.c.repaint();
        }
    }

    public Dimension getMinimumSize(JComponent component) {
        return new Dimension(50, 15);
    }

    public Dimension getPreferredSize(JComponent component) {
        return new Dimension(50, 15);
    }
}

