/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.mov.parser.EvaluationException;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.Quote;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.ChangeFormat;
import org.mov.ui.Column;
import org.mov.ui.DesktopManager;
import org.mov.ui.EquationColumn;
import org.mov.ui.PointChangeFormat;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.ui.QuoteFormat;
import org.mov.util.Locale;

public class QuoteModel
extends AbstractTableModel {
    private QuoteBundle quoteBundle;
    private EquationColumn[] equationColumns;
    private List quotes;
    public static final int EQUATION_COLUMN_COUNT = 5;
    public static final int SYMBOL_COLUMN = 0;
    public static final int DATE_COLUMN = 1;
    public static final int VOLUME_COLUMN = 2;
    public static final int DAY_LOW_COLUMN = 3;
    public static final int DAY_HIGH_COLUMN = 4;
    public static final int DAY_OPEN_COLUMN = 5;
    public static final int DAY_CLOSE_COLUMN = 6;
    public static final int POINT_CHANGE_COLUMN = 7;
    public static final int PERCENT_CHANGE_COLUMN = 8;
    public static final int ACTIVITY_COLUMN = 9;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QuoteModel(QuoteBundle quoteBundle, List quotes, int displayDate, int displaySymbol) {
        this.quoteBundle = quoteBundle;
        this.quotes = quotes;
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(0, Locale.getString("SYMBOL"), Locale.getString("SYMBOL_COLUMN_HEADER"), Symbol.class, displaySymbol));
        columns.add(new Column(1, Locale.getString("DATE"), Locale.getString("DATE_COLUMN_HEADER"), Symbol.class, displayDate));
        columns.add(new Column(2, Locale.getString("VOLUME"), Locale.getString("VOLUME_COLUMN_HEADER"), Integer.class, 1));
        columns.add(new Column(3, Locale.getString("DAY_LOW"), Locale.getString("DAY_LOW_COLUMN_HEADER"), QuoteFormat.class, 1));
        columns.add(new Column(4, Locale.getString("DAY_HIGH"), Locale.getString("DAY_HIGH_COLUMN_HEADER"), QuoteFormat.class, 1));
        columns.add(new Column(5, Locale.getString("DAY_OPEN"), Locale.getString("DAY_OPEN_COLUMN_HEADER"), QuoteFormat.class, 1));
        columns.add(new Column(6, Locale.getString("DAY_CLOSE"), Locale.getString("DAY_CLOSE_COLUMN_HEADER"), QuoteFormat.class, 1));
        columns.add(new Column(7, Locale.getString("POINT_CHANGE"), Locale.getString("POINT_CHANGE_COLUMN_HEADER"), PointChangeFormat.class, 0));
        columns.add(new Column(8, Locale.getString("PERCENT_CHANGE"), Locale.getString("PERCENT_CHANGE_COLUMN_HEADER"), ChangeFormat.class, 1));
        columns.add(new Column(9, Locale.getString("ACTIVITY"), Locale.getString("ACTIVITY_COLUMN_HEADER"), Integer.class, 2));
        this.setColumns(columns);
        this.equationColumns = this.createEquationColumns(10);
    }

    public List getQuotes() {
        return this.quotes;
    }

    public void setQuotes(List quotes) {
        this.quotes = quotes;
        for (int i = 0; i < this.equationColumns.length; ++i) {
            try {
                this.equationColumns[i].recalculate(this.quoteBundle, quotes);
                continue;
            }
            catch (EvaluationException e) {
                this.displayErrorMessage(e.getReason());
            }
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.quotes.size();
    }

    public Object getValueAt(int row, int column) {
        if (row >= this.getRowCount()) {
            return "";
        }
        Quote quote = (Quote)this.quotes.get(row);
        switch (column) {
            case 0: {
                return quote.getSymbol();
            }
            case 1: {
                return quote.getDate();
            }
            case 2: {
                return new Integer(quote.getDayVolume());
            }
            case 3: {
                return new QuoteFormat(quote.getDayLow());
            }
            case 4: {
                return new QuoteFormat(quote.getDayHigh());
            }
            case 5: {
                return new QuoteFormat(quote.getDayOpen());
            }
            case 6: {
                return new QuoteFormat(quote.getDayClose());
            }
            case 7: {
                double finalQuote = quote.getDayClose();
                double initialQuote = quote.getDayOpen();
                try {
                    initialQuote = this.quoteBundle.getQuote(quote.getSymbol(), 0, quote.getDate().previous(1));
                }
                catch (MissingQuoteException e) {
                    // empty catch block
                }
                return new PointChangeFormat(initialQuote, finalQuote);
            }
            case 8: {
                double finalQuote = quote.getDayClose();
                double initialQuote = quote.getDayOpen();
                try {
                    initialQuote = this.quoteBundle.getQuote(quote.getSymbol(), 0, quote.getDate().previous(1));
                }
                catch (MissingQuoteException e) {
                    // empty catch block
                }
                return new ChangeFormat(initialQuote, finalQuote);
            }
            case 9: {
                return new Double(quote.getDayHigh() * (double)quote.getDayVolume());
            }
        }
        EquationColumn equationColumn = (EquationColumn)this.getColumn(column);
        return equationColumn.getResult(quote.getSymbol(), quote.getDate());
    }

    public EquationColumn[] getEquationColumns() {
        return this.equationColumns;
    }

    public void setEquationColumns(QuoteBundle quoteBundle, EquationColumn[] equationColumns) {
        Thread thread2 = Thread.currentThread();
        ProgressDialog progress = ProgressDialogManager.getProgressDialog();
        progress.setIndeterminate(true);
        progress.show(Locale.getString("APPLYING_EQUATIONS"));
        this.equationColumns = equationColumns;
        for (int i = 0; i < this.equationColumns.length; ++i) {
            try {
                this.equationColumns[i].calculate(quoteBundle, this.quotes);
            }
            catch (EvaluationException e) {
                this.displayErrorMessage(e.getReason());
            }
            if (thread2.isInterrupted()) break;
        }
        ProgressDialogManager.closeProgressDialog(progress);
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        return super.getColumnCount() + this.equationColumns.length;
    }

    public Column getColumn(int columnNumber) {
        if (columnNumber < super.getColumnCount()) {
            return super.getColumn(columnNumber);
        }
        if (!$assertionsDisabled && (columnNumber -= super.getColumnCount()) > this.equationColumns.length) {
            throw new AssertionError();
        }
        return this.equationColumns[columnNumber];
    }

    private void displayErrorMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showInternalMessageDialog(DesktopManager.getDesktop(), message + ".", Locale.getString("ERROR_EVALUATING_EQUATIONS"), 0);
            }
        });
    }

    private EquationColumn[] createEquationColumns(int columnNumber) {
        EquationColumn[] equationColumns = new EquationColumn[5];
        for (int i = 0; i < equationColumns.length; ++i) {
            equationColumns[i] = new EquationColumn(columnNumber++, Locale.getString("EQUATION_NUMBER", i + 1), Locale.getString("EQUATION_COLUMN_HEADER", i + 1), 0, "", null);
        }
        return equationColumns;
    }

    static {
        $assertionsDisabled = !QuoteModel.class.desiredAssertionStatus();
    }
}

