/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.mov.ui.TwoWayComparable;

public class SortedTable
extends JTable {
    public static final int DONT_SORT = 0;
    public static final int SORT_UP = 1;
    public static final int SORT_DOWN = 2;
    private int sortColumn = 0;
    private int sortDirection = 2;
    private SortModel model = null;
    private String upImage = "toolbarButtonGraphics/navigation/Up16.gif";
    private String downImage = "toolbarButtonGraphics/navigation/Down16.gif";
    static /* synthetic */ Class class$org$mov$ui$SortedTable;

    public SortedTable() {
        this.setCustomHeaderRenderer();
        String toolTipText = "Click on table header to sort by that column, click again to change sort direction";
        this.getTableHeader().setToolTipText(toolTipText);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) == 16) {
                    int column = SortedTable.this.columnAtPoint(e.getPoint());
                    column = SortedTable.this.convertColumnIndexToModel(column);
                    column = SortedTable.this.model.convertFromDisplayedColumn(column);
                    SortedTable.this.toggleColumnSortStatus(column);
                    SortedTable.this.resort();
                    SortedTable.this.revalidate();
                    SortedTable.this.repaint();
                }
            }
        });
    }

    public void setModel(TableModel model) {
        this.setModel(model, this.sortColumn, this.sortDirection);
    }

    public void setModel(TableModel model, int sortColumn, int sortDirection) {
        this.model = new SortModel(model, sortColumn, sortDirection);
        super.setModel(this.model);
    }

    public void showColumn(int columnNumber, boolean show) {
        this.model.showColumn(columnNumber, show);
    }

    public void resort() {
        if (this.model != null) {
            int[] selectedRows = this.getSelectedRows();
            int selectedRowCount = this.getSelectedRowCount();
            this.model.sort(this.sortColumn, this.sortDirection);
            this.clearSelection();
            for (int i = 0; i < selectedRowCount; ++i) {
                this.addRowSelectionInterval(selectedRows[i], selectedRows[i]);
            }
        }
    }

    private void setCustomHeaderRenderer() {
        TableCellRenderer r = this.getTableHeader().getDefaultRenderer();
        JComponent header = (JComponent)r.getTableCellRendererComponent(this, "", false, false, 0, 0);
        HeaderCellRenderer renderer = new HeaderCellRenderer(header.getBorder(), header.getBackground(), header.getForeground());
        this.getTableHeader().setDefaultRenderer(renderer);
    }

    public int getColumnSortStatus(int column) {
        if (column == this.sortColumn) {
            return this.sortDirection;
        }
        return 0;
    }

    public void setColumnSortStatus(int column, int direction) {
        if (direction != 0) {
            this.sortColumn = column;
            this.sortDirection = direction;
        }
    }

    public void toggleColumnSortStatus(int column) {
        if (this.getColumnSortStatus(column) == 0) {
            this.setColumnSortStatus(column, 2);
        } else if (this.getColumnSortStatus(column) == 2) {
            this.setColumnSortStatus(column, 1);
        } else {
            this.setColumnSortStatus(column, 2);
        }
    }

    public int getSelectedRow() {
        int row = super.getSelectedRow();
        if (row == -1) {
            return -1;
        }
        return this.model.getUnsortedRow(row);
    }

    public int[] getSelectedRows() {
        int[] unsortedSelectedRows = super.getSelectedRows();
        int[] selectedRows = new int[this.getSelectedRowCount()];
        if (this.getSelectedRowCount() > 0) {
            for (int i = 0; i < this.getSelectedRowCount(); ++i) {
                selectedRows[i] = this.model.getUnsortedRow(unsortedSelectedRows[i]);
            }
        }
        return selectedRows;
    }

    public void setSortedRowSelectionInterval(int index0, int index1) {
        super.setRowSelectionInterval(index0, index1);
    }

    public int getSortedSelectedRow() {
        return super.getSelectedRow();
    }

    public void setRowSelectionInterval(int index0, int index1) {
        int sortedIndex;
        if (index0 == index1 && (sortedIndex = this.model.getSortedRow(index0)) != -1) {
            super.setRowSelectionInterval(sortedIndex, sortedIndex);
        }
    }

    public void setVisible(int row, int column) {
        int sortedRow = this.model.getSortedRow(row);
        if (sortedRow != -1) {
            Rectangle rectangle = super.getCellRect(sortedRow, column, true);
            this.scrollRectToVisible(rectangle);
        }
    }

    public void addRowSelectionInterval(int index0, int index1) {
        int sortedIndex;
        if (index0 == index1 && (sortedIndex = this.model.getSortedRow(index0)) != -1) {
            super.addRowSelectionInterval(sortedIndex, sortedIndex);
        }
    }

    public int getUnsortedRow(int sortedRow) {
        if (sortedRow == -1) {
            return sortedRow;
        }
        return this.model.getUnsortedRow(sortedRow);
    }

    public int getSortedRow(int unsortedRow) {
        if (unsortedRow == -1) {
            return unsortedRow;
        }
        return this.model.getSortedRow(unsortedRow);
    }

    public class SortModel
    extends AbstractTableModel
    implements TableModelListener {
        private TableModel userModel;
        private SortComparator sortComparator;
        private LinkedList sortIndex;
        private int currentSortDirection;
        private int currentSortColumn;
        private TreeSet hiddenColumns;

        public SortModel(TableModel userModel, int sortColumn, int sortDirection) {
            this.userModel = userModel;
            userModel.addTableModelListener(this);
            this.hiddenColumns = new TreeSet();
            this.sortComparator = new SortComparator(sortDirection);
            this.sortIndex = null;
            this.sort(sortColumn, sortDirection);
        }

        public void tableChanged(TableModelEvent e) {
        }

        public boolean isColumnVisible(int columnNumber) {
            Iterator iterator = this.hiddenColumns.iterator();
            while (iterator.hasNext()) {
                int hiddenColumnNumber = (Integer)iterator.next();
                if (hiddenColumnNumber != columnNumber) continue;
                return false;
            }
            return true;
        }

        public void showColumn(int columnNumber, boolean show) {
            if (!show && this.isColumnVisible(columnNumber)) {
                this.hiddenColumns.add(new Integer(columnNumber));
                this.fireTableStructureChanged();
            } else if (show && !this.isColumnVisible(columnNumber)) {
                this.hiddenColumns.remove(new Integer(columnNumber));
                this.fireTableStructureChanged();
            }
        }

        private int convertToDisplayedColumn(int column) {
            Iterator iterator = this.hiddenColumns.iterator();
            while (iterator.hasNext()) {
                int hiddenColumnNumber = (Integer)iterator.next();
                if (hiddenColumnNumber > column) continue;
                ++column;
            }
            return column;
        }

        public int convertFromDisplayedColumn(int column) {
            int numberHiddenColumns = 0;
            Iterator iterator = this.hiddenColumns.iterator();
            while (iterator.hasNext()) {
                int hiddenColumnNumber = (Integer)iterator.next();
                if (hiddenColumnNumber > column) continue;
                ++numberHiddenColumns;
                ++column;
            }
            return column;
        }

        public void sort(int sortColumn, int sortDirection) {
            this.currentSortColumn = sortColumn;
            this.currentSortDirection = sortDirection;
            this.sortIndex = new LinkedList();
            for (int i = 0; i < this.getRowCount(); ++i) {
                TableElement tableElement = new TableElement(this.userModel.getValueAt(i, sortColumn), i);
                this.sortIndex.add(tableElement);
            }
            this.sortComparator.setDirection(sortDirection);
            Collections.sort(this.sortIndex, this.sortComparator);
        }

        public int getRowCount() {
            return this.userModel.getRowCount();
        }

        public int getColumnCount() {
            return this.userModel.getColumnCount() - this.hiddenColumns.size();
        }

        public Class getColumnClass(int column) {
            return this.userModel.getColumnClass(this.convertToDisplayedColumn(column));
        }

        public String getColumnName(int column) {
            return this.userModel.getColumnName(this.convertToDisplayedColumn(column));
        }

        public Object getValueAt(int row, int column) {
            column = this.convertToDisplayedColumn(column);
            if (this.sortIndex.size() != this.getRowCount()) {
                this.sort(this.currentSortColumn, this.currentSortDirection);
            }
            if (this.sortIndex != null) {
                TableElement index = (TableElement)this.sortIndex.get(row);
                return this.userModel.getValueAt(index.getIndex(), column);
            }
            return "";
        }

        public int getUnsortedRow(int sortedRow) {
            if (sortedRow == -1) {
                return -1;
            }
            TableElement index = (TableElement)this.sortIndex.get(sortedRow);
            return index.getIndex();
        }

        public int getSortedRow(int unsortedRow) {
            if (unsortedRow == -1) {
                return -1;
            }
            for (int i = 0; i < this.getRowCount(); ++i) {
                TableElement index = (TableElement)this.sortIndex.get(i);
                if (index.getIndex() != unsortedRow) continue;
                return i;
            }
            return -1;
        }

        public TableModel getUserModel() {
            return this.userModel;
        }

        private class SortComparator
        implements Comparator {
            private int sortDirection;
            static final /* synthetic */ boolean $assertionsDisabled;

            public SortComparator(int sortDirection) {
                this.setDirection(sortDirection);
            }

            public void setDirection(int sortDirection) {
                this.sortDirection = sortDirection;
            }

            public int compare(Object firstObject, Object secondObject) {
                TableElement firstElement = (TableElement)firstObject;
                TableElement secondElement = (TableElement)secondObject;
                Object firstKey = firstElement.getKey();
                Object secondKey = secondElement.getKey();
                try {
                    if (firstKey instanceof TwoWayComparable) {
                        TwoWayComparable firstComparable = (TwoWayComparable)firstKey;
                        TwoWayComparable secondComparable = (TwoWayComparable)secondKey;
                        return firstComparable.compareTo(secondComparable, this.sortDirection == 1);
                    }
                    Comparable firstComparable = (Comparable)firstKey;
                    Comparable secondComparable = (Comparable)secondKey;
                    return this.applySortDirection(firstComparable.compareTo(secondComparable));
                }
                catch (ClassCastException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return 0;
                }
            }

            private int applySortDirection(int comparision) {
                if (this.sortDirection == 1) {
                    comparision = -comparision;
                }
                return comparision;
            }

            static {
                $assertionsDisabled = !(class$org$mov$ui$SortedTable == null ? (class$org$mov$ui$SortedTable = SortedTable.class$("org.mov.ui.SortedTable")) : class$org$mov$ui$SortedTable).desiredAssertionStatus();
            }
        }

        class TableElement {
            private Object key;
            private int index;

            TableElement(Object key, int index) {
                this.key = key;
                this.index = index;
            }

            Object getKey() {
                return this.key;
            }

            int getIndex() {
                return this.index;
            }
        }
    }

    private class HeaderCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public HeaderCellRenderer(Border border, Color background, Color foreground) {
            this.setBorder(border);
            this.setHorizontalTextPosition(2);
            this.setHorizontalAlignment(0);
            this.setBackground(background);
            this.setForeground(foreground);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SortedTable sortedTable = (SortedTable)table;
            SortModel sortModel = (SortModel)sortedTable.getModel();
            column = SortedTable.this.convertColumnIndexToModel(column);
            column = sortModel.convertFromDisplayedColumn(column);
            this.setText((String)value);
            if (sortedTable.getColumnSortStatus(column) == 0) {
                this.setIcon(null);
            } else if (sortedTable.getColumnSortStatus(column) == 1) {
                URL upImageURL = ClassLoader.getSystemResource(SortedTable.this.upImage);
                if (upImageURL != null) {
                    ImageIcon upImageIcon = new ImageIcon(upImageURL);
                    this.setIcon(upImageIcon);
                }
            } else {
                URL downImageURL = ClassLoader.getSystemResource(SortedTable.this.downImage);
                if (downImageURL != null) {
                    ImageIcon downImageIcon = new ImageIcon(downImageURL);
                    this.setIcon(downImageIcon);
                }
            }
            return this;
        }
    }
}

