/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.util.ArrayList;
import java.util.SortedSet;
import javax.swing.JComboBox;
import org.mov.quote.QuoteRange;
import org.mov.quote.Symbol;
import org.mov.quote.SymbolFormatException;
import org.mov.util.Locale;

public class SymbolListComboBox
extends JComboBox {
    private static final String ALL_ORDINARIES = Locale.getString("ALL_ORDINARIES");
    private static final String ALL_SYMBOLS = Locale.getString("ALL_SYMBOLS");
    private static final String MARKET_INDICES = Locale.getString("MARKET_INDICES");

    public SymbolListComboBox() {
        this(new String(""));
    }

    public SymbolListComboBox(String equationText) {
        this.setEditable(true);
        this.updateItems();
        this.setSelectedItem(equationText);
    }

    public QuoteRange getQuoteRange() throws SymbolFormatException {
        String text = this.getText();
        if (text.equals(ALL_ORDINARIES)) {
            return new QuoteRange(1);
        }
        if (text.equals(ALL_SYMBOLS)) {
            return new QuoteRange(2);
        }
        if (text.equals(MARKET_INDICES)) {
            return new QuoteRange(3);
        }
        if (text == null) {
            return new QuoteRange(1);
        }
        SortedSet symbolSet = Symbol.toSortedSet(text, true);
        if (symbolSet.isEmpty()) {
            throw new SymbolFormatException(Locale.getString("MISSING_SYMBOLS"));
        }
        return new QuoteRange(new ArrayList(symbolSet));
    }

    public String getText() {
        return (String)this.getSelectedItem();
    }

    public void setText(String text) {
        this.setSelectedItem(text);
    }

    private void updateItems() {
        this.removeAllItems();
        this.addItem(ALL_ORDINARIES);
        this.addItem(ALL_SYMBOLS);
        this.addItem(MARKET_INDICES);
    }
}

