/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.util.SortedSet;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import org.mov.quote.Symbol;
import org.mov.quote.SymbolFormatException;
import org.mov.ui.TextDialog;
import org.mov.util.Locale;

public class SymbolListDialog {
    private SymbolListDialog() {
    }

    public static Symbol getSymbol(JDesktopPane parent, String title) {
        Symbol symbol;
        boolean invalidResponse;
        do {
            symbol = null;
            String symbolString = "";
            invalidResponse = false;
            TextDialog dialog = new TextDialog(parent, Locale.getString("SYMBOL"), title);
            symbolString = dialog.showDialog();
            if (symbolString == null) continue;
            try {
                symbol = Symbol.toSymbol(symbolString);
            }
            catch (SymbolFormatException e) {
                invalidResponse = true;
                JOptionPane.showInternalMessageDialog(parent, e.getMessage(), Locale.getString("ERROR_PARSING_SYMBOL"), 0);
            }
        } while (invalidResponse);
        return symbol;
    }

    public static SortedSet getSymbols(JDesktopPane parent, String title) {
        SortedSet symbolSet;
        boolean invalidResponse;
        do {
            symbolSet = null;
            String symbols = "";
            invalidResponse = false;
            TextDialog dlg = new TextDialog(parent, Locale.getString("SYMBOLS"), title);
            symbols = dlg.showDialog();
            if (symbols == null) continue;
            try {
                symbolSet = Symbol.toSortedSet(symbols, true);
            }
            catch (SymbolFormatException e) {
                invalidResponse = true;
                JOptionPane.showInternalMessageDialog(parent, e.getMessage(), Locale.getString("ERROR_PARSING_SYMBOLS"), 0);
            }
        } while (invalidResponse);
        if (symbolSet != null && symbolSet.size() == 0) {
            return null;
        }
        return symbolSet;
    }
}

