/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.mov.main.ModuleFrame;
import org.mov.ui.DesktopManager;
import org.mov.util.Locale;

public class TextViewDialog {
    private boolean isUp = true;
    private int buttonPressed = 0;
    private JInternalFrame internalFrame;
    private static final int ROWS = 20;
    private static final int COLUMNS = 45;
    public static final int FIXED_WIDTH = 0;
    public static final int PROPORTIONAL = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    private TextViewDialog(String text, String title, int rows, int columns, int fontType, String[] buttons) {
        this.layout(text, title, rows, columns, fontType, buttons);
    }

    private void layout(String text, String title, int rows, int columns, int fontType, String[] buttons) {
        this.internalFrame = new JInternalFrame(title, true, true, true, true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel textPanel = new JPanel();
        JTextArea textArea = new JTextArea(rows, columns);
        textArea.setText(text);
        textArea.setEditable(false);
        if (fontType == 0) {
            textArea.setFont(new Font("Monospaced", 0, 12));
        }
        textPanel.setLayout(new BorderLayout());
        textPanel.add(new JScrollPane(textArea));
        panel.add((Component)textPanel, "Center");
        JPanel buttonPanel = new JPanel();
        int i = 0;
        while (i < buttons.length) {
            JButton button = new JButton(buttons[i]);
            final int buttonNumber = i++;
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TextViewDialog.this.buttonPressed = buttonNumber;
                    TextViewDialog.this.close();
                }
            });
            buttonPanel.add(button);
        }
        panel.add((Component)buttonPanel, "South");
        this.internalFrame.getContentPane().add(panel);
        Dimension preferred = this.internalFrame.getPreferredSize();
        this.internalFrame.setMinimumSize(preferred);
        ModuleFrame.setSizeAndLocation(this.internalFrame, DesktopManager.getDesktop(), true, true);
        DesktopManager.getDesktop().add(this.internalFrame);
        this.internalFrame.show();
        try {
            this.internalFrame.setSelected(true);
        }
        catch (PropertyVetoException v) {
            // empty catch block
        }
        this.internalFrame.moveToFront();
    }

    private void close() {
        this.isUp = false;
        try {
            this.internalFrame.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private boolean isUp() {
        return this.isUp;
    }

    private int waitUntilClosed() {
        try {
            while (this.isUp()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.buttonPressed;
    }

    public static void showTextDialog(String text, String title) {
        String[] buttons = new String[]{Locale.getString("OK")};
        TextViewDialog.showTextDialog(text, title, 20, 45, 1, buttons);
    }

    public static int showTextDialog(String text, String title, int rows, int columns, int fontType, String[] buttons) {
        if (!$assertionsDisabled && fontType != 0 && fontType != 1) {
            throw new AssertionError();
        }
        TextViewDialog dialog = new TextViewDialog(text, title, rows, columns, fontType, buttons);
        return dialog.waitUntilClosed();
    }

    static {
        $assertionsDisabled = !TextViewDialog.class.desiredAssertionStatus();
    }
}

