/*
 * Decompiled with CFR 0.152.
 */
package org.mov.ui;

import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import org.mov.quote.QuoteCache;
import org.mov.quote.QuoteSourceManager;
import org.mov.quote.WeekendDateException;
import org.mov.ui.TextDialog;
import org.mov.util.Locale;
import org.mov.util.TradingDate;
import org.mov.util.TradingDateFormatException;

public class TradingDateDialog {
    private TradingDateDialog() {
    }

    public static TradingDate getDate(JDesktopPane parent, String title, String prompt) {
        boolean invalidResponse;
        TradingDate date = null;
        TradingDate lastDate = QuoteSourceManager.getSource().getLastDate();
        if (lastDate == null) {
            return null;
        }
        String dateText = lastDate.toString("dd/mm/yyyy");
        do {
            invalidResponse = false;
            TextDialog dialog = new TextDialog(parent, prompt, title, dateText);
            if ((dateText = dialog.showDialog()) == null || (date = TradingDateDialog.parseDate(parent, dateText)) != null) continue;
            invalidResponse = true;
        } while (invalidResponse);
        return date;
    }

    private static TradingDate parseDate(JDesktopPane parent, String dateText) {
        TradingDate date = null;
        try {
            date = new TradingDate(dateText, 1);
        }
        catch (TradingDateFormatException e) {
            JOptionPane.showInternalMessageDialog(parent, Locale.getString("ERROR_PARSING_DATE", dateText), Locale.getString("INVALID_DATE"), 0);
            return null;
        }
        try {
            int dateOffset = QuoteCache.getInstance().dateToOffset(date);
        }
        catch (WeekendDateException e) {
            JOptionPane.showInternalMessageDialog(parent, Locale.getString("DATE_ON_WEEKEND", dateText), Locale.getString("INVALID_DATE"), 0);
            return null;
        }
        if (!QuoteSourceManager.getSource().containsDate(date)) {
            JOptionPane.showInternalMessageDialog(parent, Locale.getString("NO_QUOTES_DATE", dateText), Locale.getString("INVALID_DATE"), 0);
            return null;
        }
        return date;
    }
}

