/*
 * Decompiled with CFR 0.152.
 */
package org.mov.util;

import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import org.mov.parser.Expression;
import org.mov.parser.ExpressionException;
import org.mov.parser.Parser;
import org.mov.ui.EquationDialog;

public class ExpressionQuery {
    private ExpressionQuery() {
    }

    public static String getExpression(JDesktopPane parent, String title, String prompt) {
        return ExpressionQuery.getExpression(parent, title, prompt, "");
    }

    public static String getExpression(JDesktopPane parent, String title, String prompt, String defaultExpression) {
        boolean invalidResponse;
        Expression expression = null;
        String expressionString = defaultExpression;
        do {
            invalidResponse = false;
            EquationDialog dlg = new EquationDialog(parent, prompt, title, expressionString);
            if ((expressionString = dlg.showDialog()) == null || expressionString.length() <= 0) continue;
            try {
                expression = Parser.parse(expressionString);
            }
            catch (ExpressionException e) {
                invalidResponse = true;
                JOptionPane.showInternalMessageDialog(parent, e.getReason() + ": " + expressionString, "Error parsing expression", 0);
            }
        } while (invalidResponse);
        return expressionString;
    }
}

