/*
 * Decompiled with CFR 0.152.
 */
package org.mov.util;

import java.text.NumberFormat;
import java.text.ParseException;
import org.mov.util.MoneyFormatException;

public class Money
implements Cloneable,
Comparable {
    private static NumberFormat format = NumberFormat.getCurrencyInstance();
    public static Money ZERO = new Money();
    private long amount;

    private Money() {
        this.amount = 0L;
    }

    private Money(long amount) {
        this.amount = amount;
    }

    public Money(double amount) {
        this.amount = Math.round(amount * 100.0);
    }

    public Money(String string) throws MoneyFormatException {
        try {
            Number number = format.parse(string);
            this.amount = Math.round(number.doubleValue() * 100.0);
        }
        catch (ParseException e2) {
            try {
                double doubleValue = Double.parseDouble(string);
                this.amount = Math.round(doubleValue * 100.0);
            }
            catch (NumberFormatException e) {
                throw new MoneyFormatException(string);
            }
        }
    }

    public Money add(Money money) {
        return new Money(this.amount + money.longValue());
    }

    public Money add(double money) {
        return new Money(this.amount + Math.round(money * 100.0));
    }

    public Money subtract(Money money) {
        return new Money(this.amount - money.longValue());
    }

    public Money divide(int number) {
        return new Money(this.amount / (long)number);
    }

    public Money multiply(int number) {
        return new Money(this.amount * (long)number);
    }

    public Object clone() {
        return new Money(this.amount);
    }

    public boolean isLessThan(Money money) {
        return this.amount < money.longValue();
    }

    public boolean isLessThanEqual(Money money) {
        return this.amount <= money.longValue();
    }

    public boolean isGreaterThan(Money money) {
        return this.amount > money.longValue();
    }

    public boolean isGreaterThanEqual(Money money) {
        return this.amount >= money.longValue();
    }

    public int compareTo(Object object) {
        Money money = (Money)object;
        if (this.amount < money.longValue()) {
            return -1;
        }
        if (this.amount > money.longValue()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        Money money = (Money)object;
        return this.amount == money.longValue();
    }

    public int hashCode() {
        return (int)this.amount;
    }

    public static String toString(double amount) {
        return format.format(amount);
    }

    public String toString() {
        return format.format(this.doubleValue());
    }

    public double doubleValue() {
        double cents = this.amount;
        return cents / 100.0;
    }

    public long longValue() {
        return this.amount;
    }
}

