/*
 * Decompiled with CFR 0.152.
 */
package org.mov.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mov.util.Converter;
import org.mov.util.Locale;
import org.mov.util.TradingDateFormatException;

public class TradingDate
implements Cloneable,
Comparable {
    public static final int US = 0;
    public static final int BRITISH = 1;
    private int year;
    private int month;
    private int day;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TradingDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public TradingDate(Calendar date) {
        this.year = date.get(1);
        this.month = date.get(2) + 1;
        this.day = date.get(5);
    }

    public TradingDate(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        this.year = gc.get(1);
        this.month = gc.get(2) + 1;
        this.day = gc.get(5);
    }

    public TradingDate(String date, int type) throws TradingDateFormatException {
        block18: {
            try {
                boolean isSeparator;
                int separator = 32;
                if (date.indexOf(47) >= 0) {
                    separator = 47;
                    isSeparator = true;
                } else if (date.indexOf(45) >= 0) {
                    separator = 45;
                    isSeparator = true;
                } else {
                    isSeparator = false;
                }
                if (isSeparator) {
                    boolean isMonthNumeric;
                    int i = 0;
                    int separatorIndex = date.indexOf(separator, i);
                    if (separatorIndex == -1) {
                        throw new TradingDateFormatException(date);
                    }
                    this.day = Integer.parseInt(date.substring(i, separatorIndex));
                    i = separatorIndex + 1;
                    if ((separatorIndex = date.indexOf(separator, i)) == -1) {
                        throw new TradingDateFormatException(date);
                    }
                    if (Character.isDigit(date.charAt(i))) {
                        this.month = Integer.parseInt(date.substring(i, separatorIndex));
                        isMonthNumeric = true;
                    } else {
                        this.month = TradingDate.textToMonth(date.substring(i, separatorIndex));
                        if (this.month == -1) {
                            throw new TradingDateFormatException(date);
                        }
                        isMonthNumeric = false;
                    }
                    i = separatorIndex + 1;
                    this.year = Integer.parseInt(date.substring(i, date.length()));
                    if (this.year < 100) {
                        this.year = TradingDate.twoToFourDigitYear(this.year);
                    }
                    if (type == 0 && isMonthNumeric) {
                        int temp = this.day;
                        this.day = this.month;
                        this.month = temp;
                    }
                    break block18;
                }
                if (date.length() == 6) {
                    this.year = Integer.parseInt(date.substring(0, 2));
                    this.month = Integer.parseInt(date.substring(2, 4));
                    this.day = Integer.parseInt(date.substring(4, 6));
                    this.year = TradingDate.twoToFourDigitYear(this.year);
                    break block18;
                }
                if (date.length() == 8) {
                    this.year = Integer.parseInt(date.substring(0, 4));
                    this.month = Integer.parseInt(date.substring(4, 6));
                    this.day = Integer.parseInt(date.substring(6, 8));
                    break block18;
                }
                throw new TradingDateFormatException(date);
            }
            catch (NumberFormatException e) {
                throw new TradingDateFormatException(date);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new TradingDateFormatException(date);
            }
        }
        if (this.month == 0 || this.month > 12 || this.day == 0 || this.day > 31) {
            throw new TradingDateFormatException(date);
        }
    }

    public TradingDate() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date());
        this.year = gc.get(1);
        this.month = gc.get(2) + 1;
        this.day = gc.get(5);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getDayOfWeek() {
        Calendar date = this.toCalendar();
        return date.get(7);
    }

    public int getDayOfYear() {
        Calendar date = this.toCalendar();
        return date.get(6);
    }

    public boolean before(Object date) {
        return this.compareTo(date) < 0;
    }

    public boolean after(Object date) {
        return this.compareTo(date) > 0;
    }

    public boolean equals(Object date) {
        return this.compareTo(date) == 0;
    }

    public Object clone() {
        return new TradingDate(this.getYear(), this.getMonth(), this.getDay());
    }

    public int hashCode() {
        return this.getDay() + this.getMonth() * 256 + this.getYear() * 65536;
    }

    public TradingDate previous(int days) {
        Calendar date = this.toCalendar();
        for (int i = 0; i < days; ++i) {
            do {
                date.add(7, -1);
            } while (date.get(7) == 7 || date.get(7) == 1);
        }
        return new TradingDate(date);
    }

    public TradingDate next(int days) {
        Calendar date = this.toCalendar();
        for (int i = 0; i < days; ++i) {
            do {
                date.add(7, 1);
            } while (date.get(7) == 7 || date.get(7) == 1);
        }
        return new TradingDate(date);
    }

    public int compareTo(Object date) {
        return this.compareTo((TradingDate)date);
    }

    public int compareTo(TradingDate date) {
        if (this.getYear() < date.getYear()) {
            return -1;
        }
        if (this.getYear() > date.getYear()) {
            return 1;
        }
        if (this.getMonth() < date.getMonth()) {
            return -1;
        }
        if (this.getMonth() > date.getMonth()) {
            return 1;
        }
        if (this.getDay() < date.getDay()) {
            return -1;
        }
        if (this.getDay() > date.getDay()) {
            return 1;
        }
        return 0;
    }

    public String toString(String format) {
        format = this.replace(format, "d\\?", Integer.toString(this.getDay()));
        format = this.replace(format, "dd", Converter.toFixedString(this.getDay(), 2));
        format = this.replace(format, "m\\?", Integer.toString(this.getMonth()));
        format = this.replace(format, "mm", Converter.toFixedString(this.getMonth(), 2));
        format = this.replace(format, "MMM", TradingDate.monthToText(this.getMonth()));
        format = this.replace(format, "yyyy", Converter.toFixedString(this.getYear(), 4));
        format = this.getYear() > 99 ? this.replace(format, "yy", Integer.toString(this.getYear()).substring(2)) : this.replace(format, "yy", Integer.toString(this.getYear()));
        return format;
    }

    private String replace(String source, String patternText, String text) {
        Pattern pattern = Pattern.compile(patternText);
        Matcher matcher = pattern.matcher(source);
        return matcher.replaceAll(text);
    }

    public String toString() {
        return this.getYear() + "-" + this.getMonth() + "-" + this.getDay();
    }

    public String toShortString() {
        return this.getDay() + "/" + this.getMonth();
    }

    public String toLongString() {
        return this.getDay() + " " + TradingDate.monthToText(this.getMonth()) + ", " + this.getYear();
    }

    public static String monthToText(int month) {
        String[] months = new String[]{Locale.getString("JAN"), Locale.getString("FEB"), Locale.getString("MAR"), Locale.getString("APR"), Locale.getString("MAY"), Locale.getString("JUN"), Locale.getString("JUL"), Locale.getString("AUG"), Locale.getString("SEP"), Locale.getString("OCT"), Locale.getString("NOV"), Locale.getString("DEC")};
        if (--month < months.length && month >= 0) {
            return months[month];
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return Locale.getString("DEC");
    }

    private static int textToMonth(String monthString) {
        String[][] months = new String[][]{{"jan", "january", "janvier", "enero", "januar", "gennaio", "januari"}, {"feb", "february", "f\u00c8vrier", "febrero", "februar", "febbraio", "februari"}, {"mar", "march", "mars", "marzo", "marts", "m\u2030rz", "marzo"}, {"apr", "april", "avril", "abril", "aprile"}, {"may", "mai", "mayo", "maj", "maggio"}, {"jun", "june", "juin", "junio", "juni", "giugno"}, {"jul", "july", "juillet", "julio", "juli", "luglio"}, {"aug", "august", "ao\u02dat", "agosto", "augsti"}, {"sep", "september", "septembre", "septiembre", "settembre"}, {"oct", "october", "octobre", "octubre", "oktober", "ottobre"}, {"nov", "november", "novembre", "noviembre"}, {"dec", "december", "d\u00c8cembre", "diciembre", "dezember", "dicembre", "desember"}};
        monthString = monthString.toLowerCase();
        for (int month = 0; month < months.length; ++month) {
            String[] monthNames = months[month];
            for (int i = 0; i < monthNames.length; ++i) {
                if (!monthNames[i].equals(monthString)) continue;
                return month + 1;
            }
        }
        return -1;
    }

    public Date toDate() {
        return this.toCalendar().getTime();
    }

    public Calendar toCalendar() {
        return new GregorianCalendar(this.getYear(), this.getMonth() - 1, this.getDay());
    }

    public static int twoToFourDigitYear(int year) {
        if (!($assertionsDisabled || year >= 0 && year < 100)) {
            throw new AssertionError();
        }
        year = year > 30 ? (year += 1900) : (year += 2000);
        return year;
    }

    public static List dateRangeToList(TradingDate startDate, TradingDate endDate) {
        if (!($assertionsDisabled || startDate != null && endDate != null && startDate.compareTo(endDate) <= 0)) {
            throw new AssertionError();
        }
        ArrayList<TradingDate> dates = new ArrayList<TradingDate>();
        TradingDate date = startDate;
        while (!date.after(endDate)) {
            dates.add(date);
            date = date.next(1);
        }
        return dates;
    }

    static {
        $assertionsDisabled = !TradingDate.class.desiredAssertionStatus();
    }
}

