/***************************************************************************
                          cconfigbase.cpp  -  description
                             -------------------
    begin                : Sun Jun 15 2003
    copyright            : (C) 2003 by Daniel Muller
    email                : dan at verliba dot cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cconfigbase.h"

namespace nConfig
{
hHashStr<> cConfigBaseBase::msHasher;

cConfigBaseBase::cConfigBaseBase() : cObj("cConfigBase")
{
	mBasePtr= NULL;
}

cConfigBaseBase::~cConfigBaseBase()
{
}

/** add existing item pointed by the argument at the end of mvItems , and bind a nick to it*/
cConfigItemBase * cConfigBaseBase::Add(const string &nick, cConfigItemBase *ci)
{

	size_t Hash = msHasher(nick);
	if(!mhItems.AddWithHash(ci, Hash))
	{
		if(Log(1)) {
			cConfigItemBase *other = mhItems.GetByHash(Hash);
			LogStream() << "Error adding " << nick <<
				" because of " << (other?other->mName.data():"NULL") << "\r\n";
		}
	}
	mvItems.push_back(Hash);
	ci->mName = nick;
	return ci;
}

/** access operators */
cConfigItemBase * cConfigBaseBase::operator[](int i)
{
	return mhItems.GetByHash(mvItems[i]);
}

cConfigItemBase * cConfigBaseBase::operator[](const string &n)
{
	size_t Hash = msHasher(n);
	return mhItems.GetByHash(Hash);
}

void cConfigBaseBase::SetBaseTo(void * new_base)
{
	if(mBasePtr)
	{
		for(tIVIt it = mvItems.begin(); it != mvItems.end(); it++ )
			mhItems.GetByHash(*it)->mAddr =
				(void*)(long(mhItems.GetByHash(*it)->mAddr) +
				(long(new_base)-long(mBasePtr)));
	}
	mBasePtr = new_base;
}

#ifndef NOEXPLICIT_TEMPLATES
cConfigItemBase * cConfigBase::AddItem(const char *name, bool &var)
{	const string Name(name);
	return this->Add(Name, var); }
cConfigItemBase * cConfigBase::AddItem(const char *name, int &var)
{	const string Name(name);
	return this->Add(Name, var); }
cConfigItemBase * cConfigBase::AddItem(const char *name, unsigned &var)
{	const string Name(name);
	return this->Add(Name, var); }
cConfigItemBase * cConfigBase::AddItem(const char *name, long &var)
{	const string Name(name);
	return this->Add(Name, var); }
cConfigItemBase * cConfigBase::AddItem(const char *name, unsigned long &var)
{	const string Name(name);
	return this->Add(Name, var); }
cConfigItemBase * cConfigBase::AddItem(const char *name, __int64 &var)
{	const string Name(name);
	return this->Add(Name, var); }
cConfigItemBase * cConfigBase::AddItem(const char *name, string &var)
{	const string Name(name);
	return this->Add(Name, var); }
cConfigItemBase * cConfigBase::AddItem(const char *name, char* &var)
{	const string Name(name);
	return this->Add(Name, var); }
#endif


};

