/***************************************************************************
 *   Copyright (C) 2003 by Dan Muller                                      *
 *   dan at verliba dot cz                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "cconfigitembase.h"
#include <stdlib.h>
#include <iostream>
#include <stdio.h>

#if (!defined _WIN32) && (!defined __int64)
#define __int64  long long
#endif

using namespace std;

namespace nConfig
{

/*
*/
  // special instatntioations of the converion from string
void cConfigItemBaseT<bool>		::ConvertFrom(const std::string &str){*this = (0!=atoi(str.data()));}
void cConfigItemBaseT<int>		::ConvertFrom(const std::string &str){*this = atoi(str.data());}
void cConfigItemBaseT<unsigned int>	::ConvertFrom(const std::string &str){*this = atol(str.data());}
void cConfigItemBaseT<long>		::ConvertFrom(const std::string &str){*this = atol(str.data());}
#ifdef _WIN32
void cConfigItemBaseT<__int64>		::ConvertFrom(const std::string &str){__int64 ll; sscanf(str.data(), "%I64d", &ll); *this = ll;}
#else
void cConfigItemBaseT<__int64>		::ConvertFrom(const std::string &str){*this = strtoll(str.data(),NULL,10);}
#endif
void cConfigItemBaseT<unsigned long>	::ConvertFrom(const std::string &str){*this = strtoul(str.data(),NULL,10);}
void cConfigItemBaseT<double>		::ConvertFrom(const std::string &str){*this = atof(str.data());}
void cConfigItemBaseT<char>		::ConvertFrom(const std::string &str){*this = *str.data();}
void cConfigItemBaseT<unsigned char>	::ConvertFrom(const std::string &str){*this = *str.data();}
void cConfigItemBaseT<const char *>	::ConvertFrom(const std::string &str){*this = str.data();}
void cConfigItemBaseT<std::string>	::ConvertFrom(const std::string &str){*this = str;}
void cConfigItemBaseT<char *>		::ConvertFrom(const std::string &str)
{
	char *data = this->AsPChar() ;
	if( data ) delete data;
	data = new char[str.size()+1];
	memcpy(data,str.data(),str.size()+1);
	*this = data;
}

void cConfigItemBaseT<bool>		::ConvertTo(std::string &str){str = (this->AsBool())?"1":"0";}
void cConfigItemBaseT<int>		::ConvertTo(std::string &str){sprintf(mBuf,"%d",this->AsInt()); str = mBuf;}
void cConfigItemBaseT<unsigned>		::ConvertTo(std::string &str){sprintf(mBuf,"%u",this->AsUnsigned()); str = mBuf;}
void cConfigItemBaseT<long>		::ConvertTo(std::string &str){sprintf(mBuf,"%ld",this->AsLong()); str = mBuf;}
void cConfigItemBaseT<__int64>		::ConvertTo(std::string &str){
sprintf(mBuf,"%lld",this->AsLongLong());
str = mBuf;} //@todo sprintf long long bug... strtoll
void cConfigItemBaseT<unsigned long>	::ConvertTo(std::string &str){sprintf(mBuf,"%ul",this->AsUnsignedLong()); str = mBuf;}
void cConfigItemBaseT<double>		::ConvertTo(std::string &str){sprintf(mBuf,"%f",this->AsDouble()); str = mBuf;}
void cConfigItemBaseT<char>		::ConvertTo(std::string &str){sprintf(mBuf,"%c",this->AsChar()); str = mBuf;}
void cConfigItemBaseT<unsigned char>	::ConvertTo(std::string &str){sprintf(mBuf,"%c",this->AsUnsignedChar()); str = mBuf;}
//void cConfigItemBaseT<const char *>	::ConvertTo(std::string &str){str = (this->operator const char*());}
#ifdef NOEXPLICIT_TEMPLATES
void cConfigItemBaseT<string>	::ConvertTo(std::string &str){str = this->operator std::string();}
void cConfigItemBaseT<char *>		::ConvertTo(std::string &str){str = this->operator char*();}
std::istream &cConfigItemBaseT<std::string>::ReadFromStream(std::istream& is)
{
	string str;
	Data() = "";
	is >> Data() >> str;
	for(  ; str.size() && (str[0] != '#') ;is >> str )
	{
		Data() += ' ';
		Data() += str;
		str = "";
	}
	return is ;
}
#else
void cConfigItemBaseT<string>	::ConvertTo(std::string &str){str = this->AsString();}
void cConfigItemBaseT<char *>		::ConvertTo(std::string &str){str = this->AsPChar();}

std::istream &cConfigItemBaseT<std::string>::ReadFromStream(std::istream& is)
{
	string str;
	AsString() = "";
	is >> AsString() >> str;
	for(  ; str.size() && (str[0] != '#') ;is >> str )
	{
		AsString() += ' ';
		AsString() += str;
		str = "";
	}
	return is ;
}
#endif

#ifdef NOEXPLICIT_TEMPLATES
std::istream &cConfigItemBaseT<int>::ReadFromStream(std::istream& is){ return is >> (this->Data()); }
std::istream &cConfigItemBaseT<long>::ReadFromStream(std::istream& is){ return is >> (this->Data()); }
std::istream &cConfigItemBaseT<unsigned>::ReadFromStream(std::istream& is){ return is >> (this->Data()); }
std::istream &cConfigItemBaseT<unsigned long>::ReadFromStream(std::istream& is){ return is >> (this->Data()); }
std::istream &cConfigItemBaseT<__int64>::ReadFromStream(std::istream& is){ string tmp; is >> tmp; this->ConvertFrom(tmp); return is; }
std::istream &cConfigItemBaseT<char>::ReadFromStream(std::istream& is){ return is >> (this->Data()); }
std::istream &cConfigItemBaseT<bool>::ReadFromStream(std::istream& is){ return is >> (this->Data()); }
std::istream &cConfigItemBaseT<double>::ReadFromStream(std::istream& is){ return is >> (this->Data()); }
#else
std::istream &cConfigItemBaseT<int>::ReadFromStream(std::istream& is){ return is >> (this->AsInt()); }
std::istream &cConfigItemBaseT<long>::ReadFromStream(std::istream& is){ return is >> (this->AsLong()); }
std::istream &cConfigItemBaseT<unsigned>::ReadFromStream(std::istream& is){ return is >> (this->AsUnsigned()); }
std::istream &cConfigItemBaseT<unsigned long>::ReadFromStream(std::istream& is){ return is >> (this->AsUnsignedLong()); }
std::istream &cConfigItemBaseT<__int64>::ReadFromStream(std::istream& is){ string tmp; is >> tmp; this->ConvertFrom(tmp); return is; }
std::istream &cConfigItemBaseT<char>::ReadFromStream(std::istream& is){ return is >> (this->AsChar()); }
std::istream &cConfigItemBaseT<bool>::ReadFromStream(std::istream& is){ return is >> (this->AsBool()); }
std::istream &cConfigItemBaseT<double>::ReadFromStream(std::istream& is){ return is >> (this->AsDouble()); }
std::istream &cConfigItemBaseT<char *>::ReadFromStream(std::istream& is){ return is >> (this->AsPChar()); }
//std::istream &cConfigItemBaseT<unsigned long>::ReadFromStream(std::istream& is){ return is >> (this->AsLong()); }

std::ostream &cConfigItemBaseT<int>::WriteToStream(std::ostream& os){ return os << (this->AsInt()); }
std::ostream &cConfigItemBaseT<long>::WriteToStream(std::ostream& os){ return os << (this->AsLong()); }
std::ostream &cConfigItemBaseT<unsigned>::WriteToStream(std::ostream& os){ return os << (this->AsUnsigned()); }
std::ostream &cConfigItemBaseT<unsigned long>::WriteToStream(std::ostream& os){ return os << (this->AsUnsignedLong()); }
std::ostream &cConfigItemBaseT<__int64>::WriteToStream(std::ostream& os){ string tmp; this->ConvertTo(tmp); os << tmp; return os; }
std::ostream &cConfigItemBaseT<char>::WriteToStream(std::ostream& os){ return os << (this->AsChar()); }
std::ostream &cConfigItemBaseT<bool>::WriteToStream(std::ostream& os){ return os << (this->AsBool()); }
std::ostream &cConfigItemBaseT<double>::WriteToStream(std::ostream& os){ return os << (this->AsDouble()); }
std::ostream &cConfigItemBaseT<string>::WriteToStream(std::ostream& os){ return os << (this->AsString()); }
std::ostream &cConfigItemBaseT<char*>::WriteToStream(std::ostream& os){ return os << (this->AsPChar()); }

#endif

#ifndef NOEXPLICIT_TEMPLATES

cConfigItemBaseT<bool> &cConfigItemBaseT<bool>::operator=(const bool &i) {AsBool() = i; return *this;};
cConfigItemBaseT<char> &cConfigItemBaseT<char>::operator=(const char &i) {AsChar() = i; return *this;};
cConfigItemBaseT<unsigned char> &cConfigItemBaseT<unsigned char>::operator=(const unsigned char &i) {AsUnsignedChar() = i; return *this;};
cConfigItemBaseT<int> &cConfigItemBaseT<int>::operator=(const int &i){AsInt() = i; return *this;};
cConfigItemBaseT<unsigned> &cConfigItemBaseT<unsigned>::operator=(const unsigned &i){AsUnsigned() = i; return *this;};
cConfigItemBaseT<long> &cConfigItemBaseT<long>::operator=(const long &i){AsLong() = i; return *this;};
cConfigItemBaseT<unsigned long> &cConfigItemBaseT<unsigned long>::operator=(const unsigned long &i){AsUnsignedLong() = i; return *this;};
cConfigItemBaseT<__int64> &cConfigItemBaseT<__int64>::operator=(__int64 const &i){AsLongLong() = i; return *this;};
cConfigItemBaseT<double> &cConfigItemBaseT<double>::operator=(double const  &i){AsDouble() = i; return *this;}
cConfigItemBaseT<char*> &cConfigItemBaseT<char *>::operator=(char * const &  i){ AsPChar() = i; return *this;}
cConfigItemBaseT<char const*> &cConfigItemBaseT<char const*>::operator=(char const* const &  i){ AsConstPChar() = i; return *this;}
cConfigItemBaseT<string> &cConfigItemBaseT<string>::operator=(const string &i){AsString() = i; return *this;};
#endif


};
