/***************************************************************************
                          cconndc.cpp  -  description
                             -------------------
    begin                : Fri May 9 2003
    copyright            : (C) 2003 by Daniel Muller
    email                : dan at verliba dot cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cconndc.h"
#if HAVE_LIBGEOIP
#include "cgeoip.h"
#endif

namespace nDirectConnect
{


cConnDC::cConnDC(int sd, cAsyncSocketServer *server)
	: cAsyncConn(sd,server)
{
//	mpMsg = NULL;
	mpUser = NULL;
	SetClassName("ConnDC");
	mLogStatus = 0;
	memset(&mTO,0, sizeof(mTO));
	//REM mBan.mBanType = 0;
	mFeatures = 0;
	mSendNickList = false;
	mConnType = eCT_UNDEF;
	mCloseReason = 0;
//	SetTimeOut(eTO_LOGIN,180); // timeout to login on 20s
	mGeoZone = 0; // default - all other then specified countries
	mRegInfo = NULL;
}

cConnDC::~cConnDC()
{
	if (mRegInfo)
	{
		delete mRegInfo;
		mRegInfo = NULL;
	}
}

/** returns true if ok, unless false */
bool cConnDC::SetUser(cUser *usr)
{
	if(!usr)
	{
		if(ErrLog(0)) LogStream() << "Trying to add a NULL user" << endl;
		return false;
	}
	if(mpUser)
	{
		if(ErrLog(1)) LogStream() << "Trying to add user when it's actually done" << endl;
		delete usr;
		return false;
	}
	mpUser = usr;
	mpUser->mxConn = this;
	mpUser->mxServer = (cServerDC *) mxServer;
	if(Log(3)) LogStream() << "User " << usr->mNick << " connected ... " << endl;	
	return true;
}

/** Send raw data whenever it's next possible,
		n is the size of data, if not specified, or zero, the null terminated string is mesured */
int cConnDC::Send(string & data, bool IsComplete)
{
	if(!mWritable) return 0;
	if(data.size() >= MAX_SEND_SIZE-1)
	{
		if(Log(2))
			LogStream() << "Truncating too long message from: "
				<< data.size() << " to " << MAX_SEND_SIZE -1 << " Message starts with: " << data.substr(0,10) << endl;
		data.resize( MAX_SEND_SIZE -1,' ');
	}
	if(Log(5)) LogStream() << "OUT: " << data.substr(0,100) << endl;
	if(msLogLevel >= 3)
		Server()->mNetOutLog << data.size() << " "
			<< data.size() << " "
			<< 1 << " " << data.substr(0,10) << endl;

	if(IsComplete) data.append("|");
	int ret = Write(data);
	mTimeLastAttempt.Get();
	if (mxServer) {
		// cout << "Send " << data.size() << "bytes" << endl;
		// Server()->mUploadZone[mGeoZone].Dump();
		Server()->mUploadZone[mGeoZone].Insert(Server()->mTime,data.size());
		// Server()->mUploadZone[mGeoZone].Dump();
	}
	if(IsComplete) data.erase(data.size()-1,1);
	return ret;
}

/** log the event */
int cConnDC::StrLog(ostream & ostr, int level)
{
	if(cObj::StrLog(ostr,level))
	{
		LogStream()   << "(" << mAddrIP ;//<< ":" << mAddrPort;
		if(mAddrHost.length())
			LogStream() << " " << mAddrHost;
		LogStream()   << ") ";
		if(mpUser)
			LogStream() << "[ " << mpUser->mNick << " ] ";
		return 1;
	}
	return 0;
}

/** set log status flag to a given one in the user*/
void cConnDC::SetLSFlag(unsigned int st)
{
	mLogStatus |= st;
}

/** get log status flag to a given one in the user */
unsigned int cConnDC::GetLSFlag(unsigned int st)
{
	return mLogStatus & st;
}

/** create somehow a string to get line for given connection, ad return th pointer */
string * cConnDC::FactoryString()
{
//	mpMsg = new cMessageDC();
//	return &(mpMsg->GetStr());
	mMsg.ReInit();
	return &(mMsg.GetStr());
}

/** this is called every period of time */
int cConnDC::OnTimer(cTime &now)
{
	ostringstream os;
	string omsg;
	// check the timeouts
	int i;
	for(i=0; i < eTO_MAXTO; i++)
	{
		if(!CheckTimeOut(tTimeOut(i), now))
		{
			os << Server()->mL.operation_timeout << " (" << Server()->mL.timeout_text[tTimeOut(i)] << ")";
			if(Log(2)) LogStream() << "Operation timeout (" << tTimeOut(i) << ")" << endl;
			Server()->ConnCloseMsg(this,os.str(),6000, eCR_TIMEOUT);
			break;
		}
	}
	if (mTimeLastIOAction.Sec() < (mTimeLastAttempt.Sec() - 270)) {
		os << Server()->mL.timeout_any;
		if(Log(2)) LogStream() << "Any action timeout.." << endl;
		Server()->ConnCloseMsg(this,os.str(),6000, eCR_TO_ANYACTION);
	}

	// check frozen users, send to every user, every minute an empty message
	if(
		Server()->MinDelay(mT.ping,60) &&
		mpUser &&
		mpUser->mInList &&
		mpUser->mT.login < ( cTime() - 600 )
		)
	{
		omsg="";
		Send(omsg,true);
	}

	// upload line optimisation  - upload userlist slowlier
	if(mpUser && mpUser->mQueueUL.size())
	{
		unsigned long pos = 0,ppos=0;
		string buf,nick;
		cUser *other;
		for(i=0; i < Server()->mC.ul_portion; i++)
		{
			pos=mpUser->mQueueUL.find_first_of('|',ppos);
			if(pos == mpUser->mQueueUL.npos) break;

			nick = mpUser->mQueueUL.substr(ppos, pos-ppos);
			other = Server()->mUserList.GetUserByNick( nick );
			ppos=pos+1;

			// check if user found
			if(!other)
			{
				if(nick != Server()->mC.hub_security && nick != Server()->mC.opchat_name)
				{
					buf.append("$Quit ");
					buf.append(nick);
				}
			}
			else
			{
				buf.append(Server()->mP.GetMyInfo(other, mpUser->mClass));
			}
		}
		Send(buf,true);

		if(pos != mpUser->mQueueUL.npos) pos++;
		// I can spare some RAM here by copying it to intermediate buffer and back
		mpUser->mQueueUL.erase(0,pos);
		mpUser->mQueueUL.reserve(0);
	}
	
	return 0;
}

/** storno the timeout */
int cConnDC::ClearTimeOut(tTimeOut to)
{
	if(to >= eTO_MAXTO) return 0;
	mTO[to].Disable();
	return 1; //ok
}

int cConnDC::SetTimeOut(tTimeOut to, double Sec, cTime &now)
{
	if(to >= eTO_MAXTO) return 0;
	mTO[to].mMaxDelay = Sec;
	mTO[to].Reset(now);
	return 1;
}

/** return true if time is not out yet */
int cConnDC::CheckTimeOut(tTimeOut to, cTime &now)
{
	if(to >= eTO_MAXTO) return 0;
	return 0 == mTO[to].Check(now);
	return 1;
}


/** this is called when write buffer gets empty */
void cConnDC::OnFlushDone()
{
	mBufSend.erase(0,mBufSend.size());
	// if user is at least 10 minutes in user list, set timeout on next flush on 5 minutes
	// this works only if something happens on the hub,
	// so there is in timer, to send every minute en empty message
////	if(
////		mpUser &&
////		mpUser->mInList &&
////		mpUser->mT.login < ( time(NULL) - 600 )
////		)
////		SetTimeOut(eTO_FLUSH,300);
//	if(IsSetTimeOut(eTO_FLUSH))
//		ClearTimeOut(eTO_FLUSH);
}

/** function called before closing nicely */
int cConnDC::OnCloseNice()
{
	if(mxServer && Server()->mC.redir_host_max >= 0)
	{
		string omsg="$ForceMove ";
		int i= (int) (1.0* Server()->mC.redir_host_max*rand()/(RAND_MAX+1.0));
		omsg+=Server()->mC.redir_host[i];
		Send(omsg,true);
	}
	return 0;
}

void cConnDC::CloseNow(int Reason)
{
   this->mCloseReason = Reason;
   this->cAsyncConn::CloseNow();
}

void cConnDC::CloseNice(int msec, int Reason)
{
   this->mCloseReason = Reason;
   this->cAsyncConn::CloseNice(msec);
}

/***************************************
   DC Connection Factory
****************************************/

cDCConnFactory::cDCConnFactory(cServerDC *server) :mServer(server)
{}


cAsyncConn *cDCConnFactory::CreateConn(tSocket sd)
{
	cConnDC *conn;
	if (!mServer) return NULL;

	conn = new cConnDC(sd, mServer);
	conn->mxFactory = this;
#if HAVE_LIBGEOIP
	string search_str(":");
	if (
		mServer->mC.cc_zone[0].size() &&
		mServer->sGeoIP.GetCC(conn->AddrIP(),conn->mCC)
	){
		search_str += conn->mCC;
		search_str += ":";
		for (int i = 0; i < 3; i ++)
		{
			if(
		 		(conn->mCC == mServer->mC.cc_zone[i]) ||
				(mServer->mC.cc_zone[i].find(search_str) != mServer->mC.cc_zone[i].npos)
			){
				conn->mGeoZone = i+1;
				break;
			}
		}
	}
#endif
	long IPConn, IPMin, IPMax;
	IPConn = cBanList::Ip2Num(conn->AddrIP());
	if (mServer->mC.ip_zone4_min.size())
	{
		IPMin = cBanList::Ip2Num(mServer->mC.ip_zone4_min);
		IPMax = cBanList::Ip2Num(mServer->mC.ip_zone4_max);
		if( (IPMin <= IPConn) && (IPMax >= IPConn)) conn->mGeoZone = 4;
	}
	if (mServer->mC.ip_zone5_min.size())
	{
		IPMin = cBanList::Ip2Num(mServer->mC.ip_zone5_min);
		IPMax = cBanList::Ip2Num(mServer->mC.ip_zone5_max);
		if( (IPMin <= IPConn) && (IPMax >= IPConn)) conn->mGeoZone = 5;
	}
	if (mServer->mC.ip_zone6_min.size())
	{
		IPMin = cBanList::Ip2Num(mServer->mC.ip_zone6_min);
		IPMax = cBanList::Ip2Num(mServer->mC.ip_zone6_max);
		if( (IPMin <= IPConn) && (IPMax >= IPConn)) conn->mGeoZone = 6;
	}
	return (cAsyncConn*) conn;
}

void cDCConnFactory::DeleteConn(cAsyncConn * &Conn)
{
	cConnDC *conn = (cConnDC*)Conn;
	if (conn && conn->mpUser)
	{
		if (conn->GetLSFlag(eLS_ALOWED))
		{
			mServer->mUserCountTot --;
			mServer->mUserCount[conn->mGeoZone] --;
			mServer->mTotalShare -= conn->mpUser->mShare;
		}
		if ( conn->mpUser->mInList ) mServer->RemoveNick(conn->mpUser);
		if (conn->mpUser->mClass) mServer->mR.Logout(conn->mpUser->mNick);
		delete conn->mpUser;
		conn->mpUser  = NULL;
		#ifndef WITHOUT_PLUGINS
		mServer->mCallBacks.mOnCloseConn.CallAll(conn);
		#endif
	}
	cConnFactory::DeleteConn(Conn);
}

};

