/***************************************************************************
                          cdcconf.cpp  -  description
                             -------------------
    begin                : Wed Jul 2 2003
    copyright            : (C) 2003 by Daniel Muller
    email                : dan at verliba dot cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cserverdc.h"
#include "cdcconf.h"
#include <string>
using namespace std;

namespace nDirectConnect
{
namespace nTables
{

cDCConf::cDCConf( cServerDC &serv ): mS(serv)
{
	max_length[eDC_KEY]=128;
	max_length[eDC_VALIDATENICK]=64;
	max_length[eDC_MYPASS]=64;
	max_length[eDC_VERSION]=32;
	max_length[eDC_GETNICKLIST]=16;
	max_length[eDC_MYNIFO]=128;
	max_length[eDC_GETINFO]=10+max_nick;
	max_length[eDC_CONNECTTOME]=32*2*max_nick;
	max_length[eDC_MCONNECTTOME]=64;
	max_length[eDC_RCONNECTTOME]=64;
	max_length[eDC_TO]=2048;
	max_length[eDC_CHAT]=1024;
	max_length[eDC_QUIT]=64;
	max_length[eDC_OPFORCEMOVE]=512;
	max_length[eDC_KICK]=64;
	max_length[eDC_SEARCH_PAS]=256;
	max_length[eDC_SEARCH]=256;
	max_length[eDC_SR]=256;
	max_length[eDC_MSEARCH]=256;
	max_length[eDC_UNKNOWN]=8;
}

cDCConf::~cDCConf()
{
}

cDCLang::cDCLang( cServerDC &serv ): mS(serv){}
cDCLang::~cDCLang(){}

void cDCConf::AddVars()
{
	Add("max_extra_regs",max_extra_regs,50);
	Add("max_extra_ops",max_extra_ops,50);
	Add("max_extra_admins",max_extra_admins,500);
	Add("max_users",max_users_total,6000);
	Add("max_users0",max_users[0],600);
	Add("max_users1",max_users[1],5400);
	Add("max_users2",max_users[2],1000);
	Add("max_users3",max_users[3],1000);
	Add("max_users4",max_users[4],1000);
	Add("max_users5",max_users[5],1000);
	Add("max_users6",max_users[6],1000);
	Add("min_share",min_share,(unsigned long)1*1024);
	Add("min_share_reg",min_share_reg,(unsigned long)0*1024);
	Add("min_share_ops",min_share_ops,(unsigned long)0);
	Add("min_share_factor_passive", min_share_factor_passive, 1.0);
	Add("min_share_use_hub",min_share_use_hub,(unsigned long)0);
	Add("max_share",max_share,(unsigned long)1024*1024);
	Add("max_share_reg",max_share_reg,(unsigned long)10*1024*1024);
	Add("tban_kick",tban_kick,300);
	Add("tban_max",tban_max,3600*24*365);
	Add("hub_name",hub_name,string("VerliHub"));
	Add("hub_desc",hub_desc,string("VerliHub"));
	Add("hub_host",hub_host,string("verlihub.no-ip.com"));
	Add("hublist_host",hublist_host,string("dreamland.gotdns.org HubReg.1stleg.com"));
	Add("hublist_port",hublist_port,2501);
	Add("hublist_send_minshare",hublist_send_minshare,true);
	Add("max_nick",max_nick,32u);
	Add("min_nick",min_nick,3u);
	Add("nick_chars",nick_chars, string("!%&()*+,-./0123456789:;=?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{}������������������������#"));
	Add("max_chat_msg",max_chat_msg,256u);
	Add("max_chat_lines",max_chat_lines,5);
	Add("nick_prefix",nick_prefix,string(""));
	Add("nick_prefix_cc", nick_prefix_cc, false);
	#if !defined _WIN32
	Add("listen_port",mS.mPort,4111);
	#else
	Add("listen_port",mS.mPort,411);
	#endif
	Add("extra_listen_ports", extra_listen_ports,string(""));
	Add("listen_ip",mS.mAddr,string("0.0.0.0"));
	Add("timer_conn_period", mS.timer_conn_period, 4);
	Add("timer_serv_period", mS.timer_serv_period, 1);
	Add("min_frequency", min_frequency, 0.1 );
	Add("max_upload_kbps",max_upload_kbps, 2000000.0);
	Add("timer_hublist_period", mS.mHublistTimer.mMinDelay.tv_sec,(__typeof__( mS.mHublistTimer.mMinDelay.tv_sec)) 0); //@todo change to 15*60
	Add("timer_reloadcfg_period", mS.mReloadcfgTimer.mMinDelay.tv_sec, (__typeof__( mS.mHublistTimer.mMinDelay.tv_sec))300); // 5 minutes
	Add("nicklist_on_login",nicklist_on_login, 1);
	Add("delayed_search",delayed_search, 1);
	Add("delayed_myinfo",delayed_myinfo, 1);

	Add("reg_class_difference", classdif_reg, 2); //obsolet
	Add("classdif_reg", classdif_reg, 2);//alias
	Add("classdif_kick", classdif_kick, 0);//alias
	//Add("classdif_search",classdif_search,10);
	Add("classdif_download",classdif_download,10);
	Add("classdif_pm",classdif_pm,10);
	Add("min_class_register" , min_class_register , 4);

	Add("step_delay", mS.mStepDelay, 50);
	Add("bc_reply",mS.LastBCNick,mEmpty);
	Add("hub_security", hub_security, string("VerliHub"));
	Add("hub_security_desc", hub_security_desc, string("Hub-Security for broadcasting messages"));
	Add("opchat_name", opchat_name, string("OpChat"));
	Add("opchat_desc", opchat_desc, string("Operator chat - only for OPs"));
	Add("dest_report_chat", dest_report_chat, false);
	Add("dest_regme_chat", dest_regme_chat, false);
	Add("log_level",mS.msLogLevel, 2);
	Add("check_ctm",check_ctm,0);
	Add("check_rctm",check_rctm,1);
	Add("max_message_size",mS.mMaxLineLength, (unsigned long)10240);
	Add("dns_lookup",mS.mUseDNS, 0);
	Add("hide_all_kicks",hide_all_kicks,0);
	Add("optimize_userlist",optimize_userlist,0);
	Add("hub_owner",hub_owner,string("unspecified_owner"));
	Add("int_search",int_search,6);
	Add("int_login",int_login, 120);
	Add("int_flood_pm_period", int_flood_pm_period, 30);
	Add("int_flood_pm_limit", int_flood_pm_limit, 30);
	Add("ul_portion",ul_portion,50);
	Add("min_search_chars", min_search_chars, 3);
	Add("allways_ask_password", allways_ask_password, false);

	ostringstream varname;
	string empty;
	int i;

	char *conn_types[]= {"default", "28kbps", "33_6kbps", "56kbps", "modem", "isdn", "cable", "dsl", "satellite", "microwave", "wireless", "lant1", "lant3" };
	for(i=0; i <= 12; i++)
	{
		varname.str(empty);
		varname << "tag_max_slots_" << conn_types[i];
		Add(varname.str(),tag_max_slots[i],100);
		varname.str(empty);
		varname << "tag_min_slots_" << conn_types[i];
		Add(varname.str(),tag_min_slots[i],0);
		varname.str(empty);
		varname << "tag_min_ls_ratio_" << conn_types[i];
		Add(varname.str(),tag_min_ls_ratio[i],-1.0);
		varname.str(empty);
		varname << "tag_min_limit_" << conn_types[i];
		Add(varname.str(),tag_min_limit[i],-1.0);
	}

	Add("tag_max_hs_ratio",tag_max_hs_ratio,100.);
	Add("tag_max_hubs",tag_max_hubs,100);

	char *cl_types[]={"", "plusplus","dcgui","odc","dc","dcpro", "strongdc", "idc", "zdc"};
	for(int i=cDCTag::eCT_PLUSPLUS; i < cDCTag::eCT_UNKNOWN; i++)
	{
		varname.str(empty);
		varname << "tag_min_version_" << cl_types[i];
		Add(varname.str(),tag_min_version[i],0.0);
		varname.str(empty);
		varname << "tag_max_version_" << cl_types[i];
		Add(varname.str(),tag_max_version[i],100.0);
	}

	Add("cc_zone1",cc_zone[0],string(""));
	Add("cc_zone2",cc_zone[1],string(""));
	Add("cc_zone3",cc_zone[2],string(""));
	Add("ip_zone4_min",ip_zone4_min,string(""));
	Add("ip_zone4_max",ip_zone4_max,string(""));
	Add("ip_zone5_min",ip_zone5_min,string(""));
	Add("ip_zone5_max",ip_zone5_max,string(""));
	Add("ip_zone6_min",ip_zone6_min,string(""));
	Add("ip_zone6_max",ip_zone6_max,string(""));
	Add("show_tags",show_tags,2);
	Add("tag_allow_none",tag_allow_none, 1);
	Add("tag_sum_hubs", tag_sum_hubs, 2);
	Add("tag_min_class_ignore",tag_min_class_ignore ,(int)eUC_OPERATOR);
	Add("send_user_ip",send_user_ip,false);
	Add("send_user_info", send_user_info, true);
	Add("use_reglist_cache",use_reglist_cache, true);
	Add("use_penlist_cache",use_penlist_cache, true);
	Add("msg_chat_onoff", msg_chat_onoff,string("<< To turn your chat on, use command !chaton >>"));
	Add("msg_change_pwd",msg_change_pwd, string("<< Please change your password NOW using command +passwd new_passwd!!! See +help, 5 minutes remaining >>"));
	Add("msg_banned",msg_banned,string("<<You are banned and this is a default extra message>>"));
	Add("msg_hub_full",msg_hub_full,string("<<User limit exceeded, hub is full, for some reason>>"));
	Add("msg_nick_prefix",msg_nick_prefix, string("<<You don't have desired nick prefix>>"));
	Add("msg_downgrade", msg_downgrade, string("<<You client version is  maybe too recent. In this hub they want to test it first before allowing it. Or maybe there is some bug, that's why you can't in>>"));
	Add("msg_upgrade",msg_upgrade, string("<<You have too old version of a client. Please upgrade it to a more recent one..>>"));
	Add("msg_replace_ban",msg_replace_ban, string(""));
	Add("chat_default_on",chat_default_on, true);
	Add("desc_insert_mode", desc_insert_mode, false);
	Add("msg_welcome_vip",msg_welcome[0]);
	Add("msg_welcome_op",msg_welcome[1]);
	Add("msg_welcome_cheef",msg_welcome[2]);
	Add("msg_welcome_admin",msg_welcome[3]);
	Add("msg_welcome_master",msg_welcome[8]);

	Add("save_lang", save_lang, false);
	for(i=0; i <10; i++)
	{
		varname.str(empty);
		varname << "redir_host" << i;
		Add(varname.str(),redir_host[i],string("czpro.no-ip.com"));
	}
	Add("redir_host_max", redir_host_max, 10);
}

void cDCLang::AddVars()
{
	Add("ban_by", ban_by, string(" BY: "));
	Add("ban_reason", ban_reason, string("Reason: "));
	Add("ban_permanently", ban_permanently, string("Permanently."));
	Add("ban_remaining", ban_remaining, string("Remaining: "));
	Add("ban_expired", ban_expired, string("Ended since: "));
	Add("ban_for", ban_for, string("For: "));
	Add("ban_removed", ban_removed, string("Removed: "));
	Add("ban_type", ban_type, string("Ban Type"));
	Add("pwd_cannot", pwd_cannot, string("You are not allowed to change your password now. Ask any OP."));
	Add("pwd_can", pwd_can, string("You can change password now, use command +passwd followed byt your new password"));
	Add("pwd_min", pwd_min, string("Minimum password length is 6 characters, retry.."));
	Add("pwd_success", pwd_success, string("Password updated successfully."));
	Add("pwd_set_error", pwd_set_error, string("Password not changed :(."));
	Add("pwd_setup", pwd_setup, string("You have been registered, please set up your password NOW \r\n"
		"using command +passwd <your_new_passwd>\r\n"
		"replace <your_new_passwd> by your password of choice  chars at least."));
	Add("because", because, string("Because: "));
	Add("ip", ip, string("IP"));
	Add("nick", nick, string("Nick"));
	Add("user", user, string("User"));
	Add("host", host, string("Host"));
	Add("ip_range", ip_range, string("IP Range :"));
	Add("op", op, string("OP"));
	Add("not_in_userlist", not_in_userlist, string(" not in userlist"));

	char *types[]={"Nick+IP","IP","Nick","IP Range","Host Level 1", "Host Level 2", "Host Level 3", "Share Size", "E-mail", "Nick Prefix", "Reverse-Host 1"};
	char *names[]={"nickip","ip","nick","iprange","host1", "host2", "host3", "share", "email", "prefix", "rhost1"};
	int  i;
	string varname;
	for (i = 0; i < 11 ; i++)
	{
		varname = "ban_type_";
		varname += names[i];
		Add(varname, ban_types[i], string(types[i]));
	}

	Add("operation_timeout", operation_timeout, string("Operation timeout"));
	Add("general_timeout", timeout_any, string("General timeout"));

	char *to_texts [] = { "Key", "Login", "MyINFO", "Flush", "Set Password"};
	char *to_names [] = { "key", "login", "myinfo", "flush", "setpass"};
	for (i = 0; i < 5; i ++)
	{
		varname = "timeout_";
		varname += to_names[i];
		Add(varname, timeout_text[i], string(to_texts[i]));
	}
}


/*!
    \fn nDirectConnect::nTables::cDCConf::Load()
 */
int cDCConf::Load()
{
	mS.mSetupList.LoadFileTo(this,mS.mDBConf.config_name.data());
	return 0;
}

int cDCLang::Load()
{
	mS.mSetupList.LoadFileTo(this,mS.mDBConf.lang_name.data());
	return 0;
}


/*!
    \fn nDirectConnect::nTables::cDCConf::Save()
 */
int cDCConf::Save()
{
	mS.mSetupList.SaveFileTo(this,mS.mDBConf.config_name.data());
	return 0;
}

int cDCLang::Save()
{
	mS.mSetupList.SaveFileTo(this,mS.mDBConf.lang_name.data());
	return 0;
}


/*!
    \fn nDirectConnect::nTables::cDCLang::ReplaceVarInString(const string&,const string &varname,string &dest, const string& by)
 */
void cDCLang::ReplaceVarInString(const string&src ,const string &varname, string &dest, const string& by)
{
	string searchvar("%[");
	searchvar+=varname;
	searchvar+="]";
	dest = src;
	int pos = dest.find(searchvar);
	while (pos != dest.npos)
	{
		dest.replace(pos, searchvar.size(), by);
		pos = dest.find(searchvar, pos);
	}
}


/*!
    \fn nDirectConnect::nTables::cDCLang::ReplaceVarInString(const string&,const string &varname,string &dest, int by)
 */
void cDCLang::ReplaceVarInString(const string &src,const string &varname,string &dest, int by)
{
    ostringstream os;
	os << by;
	ReplaceVarInString(src, varname, dest, os.str());
}


/*!
    \fn nDirectConnect::nTables::cDCLang::ReplaceVarInString(const string&,const string &varname,string &dest, double by)
 */
void cDCLang::ReplaceVarInString(const string&src,const string &varname,string &dest, double by)
{
    ostringstream os;
	os << by;
	ReplaceVarInString(src, varname, dest, os.str());
}


/*!
    \fn nDirectConnect::nTables::cDCLang::ReplaceVarInString(const string&,const string &varname,string &dest, long by)
 */
void cDCLang::ReplaceVarInString(const string &src,const string &varname,string &dest, long by)
{
    ostringstream os;
	os << by;
	ReplaceVarInString(src, varname, dest, os.str());
}

};
};
