/***************************************************************************
                          cdcconf.h  -  description
                             -------------------
    begin                : Wed Jul 2 2003
    copyright            : (C) 2003 by Daniel Muller
    email                : dan at verliba dot cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDCCONF_H
#define CDCCONF_H

#include "cconfigbase.h"
#include "cmessagedc.h"
#include "cdctag.h"

using namespace nConfig;
using std::string;
namespace nDirectConnect {

namespace nProtocol {
	class cDCProto;
};

using nProtocol::cDCProto;
using nProtocol::eDC_UNPARSED;

class cServerDC;
class cServerDC;
class cDCBanList;
class cDCConsole;
class cConnDC;


namespace nTables {


/**dc configuration
  *@author Daniel Muller
  * This class contains almost all verlihub's configuration parameters
  */

class cDCConf : public cConfigBase //<sBasicItemCreator>
{
public:
	cDCConf( cServerDC &);
	~cDCConf();
	virtual int Load();
	virtual int Save();
	void AddVars();

	friend class cServerDC;
	friend class nProtocol::cDCProto;
	friend class cDCBanList;
	friend class cDCConsole;
	friend class cConnDC;
public:
	int max_users_total;
	int max_users[7];
	int max_extra_regs;
	int max_extra_ops;
	int max_extra_admins;
	double max_upload_kbps;

	unsigned long min_share;
	unsigned long min_share_reg;
	unsigned long min_share_ops;
	double min_share_factor_passive;
	unsigned long max_share;
	unsigned long max_share_reg;
	unsigned long min_share_use_hub;
	int tban_kick;
	int tban_max;
	unsigned int max_length[eDC_UNPARSED];
	unsigned max_nick;
	unsigned min_nick;
	string nick_chars;
	unsigned max_chat_msg;
	int max_chat_lines;
	int nicklist_on_login;
	int delayed_search;
	int delayed_myinfo; // implies also delayed quit, otherwise there would be a wess on hub
	double min_frequency;
	string nick_prefix;
	bool nick_prefix_cc;
	string hub_security;
	string hub_security_desc;
	string opchat_name;
	string opchat_desc;
	bool dest_report_chat;
	bool dest_regme_chat;
	string extra_listen_ports;
	string hub_name;
	string hub_desc;
	string hub_host;
	string hub_owner;
	string hublist_host;
	int hublist_port;
	bool hublist_send_minshare;
	/** checking prefferences */
	int check_ctm;
	int check_rctm;
	string redir_host[128];
	//int reg_class_difference;
	int classdif_reg;
	int classdif_search;
	int classdif_download;
	int classdif_pm;
	int classdif_kick;
	int min_class_register;

	int redir_host_max;
	int hide_all_kicks;
	int optimize_userlist;
	int int_search;
	int int_login;
	int int_flood_pm_period;
	int int_flood_pm_limit;
	int ul_portion;
	int min_search_chars;
	string ip_zone4_min;
	string ip_zone4_max;
	string ip_zone5_min;
	string ip_zone5_max;
	string ip_zone6_min;
	string ip_zone6_max;

	int tag_max_hubs;
	int tag_max_slots[20];
	int tag_min_slots[20];
	double tag_min_limit[20];
	double tag_min_ls_ratio[20];
	double tag_max_hs_ratio;
	double tag_min_version[12];
	double tag_max_version[12];
	int tag_allow_none;
	int tag_min_class_ignore;
	int tag_sum_hubs;
	string cc_zone[3];
	int show_tags; // 0 - no at all; 1 - only to ops, 2- only to everyone ;)
	bool send_user_ip;
	bool send_user_info;
	bool use_reglist_cache;
	bool use_penlist_cache;
	bool chat_default_on;
	bool allways_ask_password;

	string msg_banned;
	string msg_hub_full;
	string msg_nick_prefix;
	string msg_chat_onoff;
	string msg_change_pwd;
	string msg_downgrade;
	string msg_upgrade;
	string msg_replace_ban;
	string msg_welcome[9];

	bool save_lang;
	bool desc_insert_mode;
public: // Public attributes
	cServerDC & mS;
};

class cDCLang : public cConfigBase //<sBasicItemCreator>
{
public:
	cDCLang( cServerDC &);
	~cDCLang();
	virtual int Load();
	virtual int Save();
	void AddVars();
	void ReplaceVarInString(const string&,const string&,string &dest, const string& by);
	void ReplaceVarInString(const string&,const string&,string &dest, double by);
	void ReplaceVarInString(const string&,const string&,string &dest, int by);
	void ReplaceVarInString(const string&,const string&,string &dest, long by);
	cServerDC &mS;

	string ban_reason;
	string ban_remaining;
	string ban_expired;
	string ban_for;
	string ban_permanently;
	string ban_types[15];
	string ban_type;
	string ban_removed;
	string ban_by;

	string pwd_cannot;
	string pwd_can;
	string pwd_min;
	string pwd_success;
	string pwd_set_error;
	string pwd_setup;
	string ip;
	string nick;
	string user;
	string host;
	string ip_range;
	string because;
	string op;
	string type;
	string not_in_userlist;
	string error;
	string success;


	string timeout_any;
	string operation_timeout;
	string timeout_text[5];
};
};
};
#endif
