/***************************************************************************
                          cdcconsole.cpp  -  description
                             -------------------
    begin                : Wed Jul 2 2003
    copyright            : (C) 2003 by Daniel Muller
    email                : dan at verliba dot cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cserverdc.h"
#include "cdcconsole.h"
#include "cuser.h"
#include "ckick.h"
#include "cinterpolexp.h"
#include "cban.h"
#include "cpenaltylist.h"
#include "ctime.h"
#include <sstream>
#include <iomanip>
#include "ccommand.h"

using nUtils::cTime;

namespace nDirectConnect {

using namespace nTables;

cPCRE cDCConsole::mIPRangeRex("^(\\d+\\.\\d+\\.\\d+\\.\\d+)((\\/(\\d+))|(\\.\\.|-)(\\d+\\.\\d+\\.\\d+\\.\\d+))?$",0);

cDCConsole::cDCConsole(cServerDC *s, cMySQL &mysql):
	cDCConsoleBase(s),
	mTriggers(s),
	mCmdr(this),
	mUserCmdr(this),
 	mCmdBan(int(eCM_BAN),"!(del|rm|un|info|list|ls)?ban([^_\\s]+)?(_(\\d+\\S))?( this (nick|ip))? ?", "(\\S+)( (.*)$)?", &mFunBan),
	mCmdGag(int(eCM_GAG),"!(un)?(gag|nochat|nopm|noctm|nosearch|kvip|maykick|noshare|mayreg) ", "(\\S+)( (\\d+\\w))?", &mFunGag),
	mCmdTrigger(int(eCM_TRIGGER),"!(ft|trigger)(\\S+) ", "(\\S+) (.*)", &mFunTrigger),
	mCmdSetVar(int(eCM_SET),"!(set|=) ", "(\\[)?(\\S+)\\]? (.*)", &mFunSetVar),
	mCmdCmd(int(eCM_CMD),"!cmd(\\S+)","(.*)", &mFunCmd),
	mCmdRegUsr(int(eCM_REG),"!r(eg)?(\\S+) ", "(\\S+)( (((\\S+) )?(.*)))?", &mFunRegUsr),
	mCmdInfo(int(eCM_INFO),"!(\\S+)info ?", "(\\S+)?", &mFunInfo),
	mCmdRaw(int(eCM_RAW),"!proto(\\S+)_(\\S+) ","(.*)", &mFunRaw),
	mCmdWho(int(eCM_WHO),"!w(ho)?(\\S+) ","(.*)", &mFunWho),
	mCmdKick(int(eCM_KICK),"!(kick|drop|flood) ","(\\S+)( (.*)$)?", &mFunKick, eUR_KICK ),
	mCmdPlug(int(eCM_PLUG),"!plug(in|out|list|reg|reload) ","(\\S+)( (.*)$)?", &mFunPlug),
	mCmdReport(int(eCM_REPORT),"\\+report ","(\\S+)( (.*)$)?", &mFunReport)
{
	mTriggers.OnStart();

	mCmdr.Add(&mCmdBan);
	mCmdr.Add(&mCmdGag);
	mCmdr.Add(&mCmdTrigger);
	mCmdr.Add(&mCmdSetVar);
	mCmdr.Add(&mCmdRegUsr);
	mCmdr.Add(&mCmdInfo);
	mFunInfo.mInfoServer.SetServer(mS);
	mCmdr.Add(&mCmdRaw);
	mCmdr.Add(&mCmdWho);
	mCmdr.Add(&mCmdKick);
	mCmdr.Add(&mCmdPlug);
	mCmdr.Add(&mCmdCmd);
	mCmdr.InitAll(&(mS->mCo));
	mUserCmdr.Add(&mCmdReport);
	mUserCmdr.InitAll(&(mS->mCo));

}

cDCConsole::~cDCConsole(){
}

/** act on op's command */
int cDCConsole::OpCommand(const string &str, cConnDC * conn)
{
	istringstream cmd_line(str);
	string cmd;
	ostringstream os;
	cmd_line >> cmd;

	if(!conn || !conn->mpUser) return 0;
	tUserCl cl=conn->mpUser->mClass;

	switch(cl)
	{
		case eUC_MASTER:
			if( cmd == "!quit"      ) return CmdQuit(cmd_line,conn);
			if( cmd == "!hublist"   ) { mS->RegisterInHublist(mS->mC.hublist_host, mS->mC.hublist_port, conn); return 1;}
		case eUC_ADMIN:
			if( cmd == "!getconfig" || cmd=="!gc" ) return CmdGetconfig(cmd_line,conn);
			if( cmd == "!userlimit" || cmd=="!ul" ) return CmdUserLimit(cmd_line,conn);
			if( cmd == "!reload"    || cmd=="!re" ) return CmdReload(cmd_line,conn);
		case eUC_CHEEF:
			if( cmd == "!broadcast" || cmd=="!bc" ) return CmdBroadcast(cmd_line,conn,eUC_NORMUSER,eUC_MASTER);
			if( cmd == "!ccbroadcast" || cmd=="!ccbc" ) return CmdCCBroadcast(cmd_line,conn,eUC_NORMUSER,eUC_MASTER);

			//#ifndef WITH_UNSTABLE
			//if( cmd == "!drop"      || cmd=="!dr" ) return CmdKick(cmd_line,conn, true);
			//#endif
			if( cmd == "!class"                   ) return CmdClass     (cmd_line, conn);
			if( cmd == "!protect"                 ) return CmdProtect   (cmd_line, conn);
		case eUC_OPERATOR:
			//#ifndef WITH_UNSTABLE
			//if( cmd == "!kick"       || cmd=="!ki" ) return CmdKick(cmd_line,conn, false);
			//#endif
			if( cmd == "!getip"      || cmd=="!gi" ) return CmdGetip(cmd_line,conn);
			if( cmd == "!gethost"    || cmd=="!gh" ) return CmdGethost(cmd_line,conn);
			if( cmd == "!getinfo"    || cmd=="!gn" ) return CmdGetinfo(cmd_line,conn);
			if( cmd == "!help"       || cmd=="!?"  ) return CmdHelp(cmd_line,conn);
			if( cmd == "!ops"        || cmd=="!oc" ) return CmdBroadcast(cmd_line,conn,eUC_OPERATOR,eUC_MASTER);
			if( cmd == "!regs"                     ) return CmdBroadcast(cmd_line,conn,eUC_REGUSER,eUC_MASTER);
			if( cmd == "!hideme"     || cmd=="!hm" ) return CmdHideMe    (cmd_line, conn);
			if( cmd == "!hidekick"   || cmd=="!hk" ) return CmdHideKick  (cmd_line, conn);
			if( cmd == "!unhidekick" || cmd=="!uhk") return CmdUnHideKick(cmd_line, conn);
			if( cmd == "!commands"   || cmd=="!cmds") return CmdCmds(cmd_line,conn);

			try
			{
				if(mCmdr.ParseAll(str, os, conn) >= 0)
				{
					mS->DCPublicHS(os.str().data(),conn);
					return 1;
				}
			}
			catch(const char *ex)
			{
				if(Log(0)) LogStream() << "Exception in commands: " << ex << endl;
			}
			catch (...)
			{
				if(Log(0)) LogStream() << "Exception in commands.." << endl;
			}

		break;
		default: return 0;
		break;
	}
	return 0;
}


/** act on usr's command */
int cDCConsole::UsrCommand(const string & str, cConnDC * conn)
{
	istringstream cmd_line(str);
	ostringstream os;
	string cmd;
	cmd_line >> cmd;

	switch(conn->mpUser->mClass)
	{
		case eUC_MASTER:
		case eUC_ADMIN:
		case eUC_CHEEF:
		case eUC_OPERATOR:
		case eUC_VIPUSER:
		case eUC_REGUSER:
			if( cmd == "+kick" ) return CmdKick( cmd_line, conn);
		case eUC_NORMUSER:
			if( cmd == "+passwd" ) return CmdRegMyPasswd( cmd_line, conn);
			if( cmd == "+help"     ) return CmdHelp(cmd_line , conn);
			if( cmd == "+rules"     ) return CmdRules(cmd_line , conn);
			if( cmd == "+pravidla"     ) return CmdRules(cmd_line , conn);
			if( cmd == "+faq"     ) return CmdFaq(cmd_line , conn);
			if( cmd == "+myinfo" ) return CmdMyInfo( cmd_line, conn);
			if( cmd == "+myip" ) return CmdMyIp( cmd_line, conn);
			if( cmd == "+me" ) return CmdMe( cmd_line, conn);
			if( cmd == "+regme" ) return CmdRegMe( cmd_line, conn);
			if(mUserCmdr.ParseAll(str, os, conn) >= 0)
			{
				mS->DCPublicHS(os.str().data(),conn);
				return 1;
			}
		break;
		default: break;
	}

	cTrigger * curTrigger;
	for( int i = 0; i < mTriggers.Size(); ++i )
	{
		curTrigger = mTriggers[i];
		if(
			curTrigger->mMinClass <= conn->mpUser->mClass &&
			cmd == curTrigger->mCommand
		)
		{
			if(Log(3)) LogStream() << "trigger found " << cmd << endl;
			return curTrigger->DoIt (cmd_line, conn, *mS);
		}
	}
	return 0;
}


/** get user's ip */
int cDCConsole:: CmdGetip(istringstream &cmd_line, cConnDC *conn)
{
	ostringstream os;
	string s;
	cUser * user;

	while(!cmd_line.eof())
	{
		cmd_line >> s;
		user = mS->mUserList.GetUserByNick(s);
		if(user && user-> mxConn )
			os << mS->mL.user << ": " << s << mS->mL.ip << ": " << user->mxConn->AddrIP() << endl;
		else
			os << mS->mL.user << ": " << s << mS->mL.not_in_userlist << endl;
	}
	mS->DCPublicHS(os.str().data(),conn);
	return 1;

}

/** list commands */
int cDCConsole::CmdCmds(istringstream &cmd_line , cConnDC *conn)
{
	ostringstream os;
	string omsg;
	os << "Some commands are: \r\n";
	mCmdr.List(& os);
	mS->mP.EscapeChars(os.str(), omsg);
	mS->DCPublicHS(omsg.data(),conn);
	return 1;
}

/** get user's host */
int cDCConsole::CmdGethost(istringstream &cmd_line , cConnDC *conn)
{
	ostringstream os;
	string s;
	cUser * user;
	while(!cmd_line.eof())
	{
		cmd_line >> s;
		user = mS->mUserList.GetUserByNick(s);
		if(user && user->mxConn)
		{
			if(!mS->mUseDNS)
				user->mxConn->DNSLookup();
			os << mS->mL.user << ": " << s << " " << mS->mL.host << ": " << user->mxConn->AddrHost() << endl;
		}
		else     os << mS->mL.user << ": " << s << mS->mL.not_in_userlist << endl;
	}
	mS->DCPublicHS(os.str().data(),conn);
	return 1;
}

/** get user's host and ip */
int cDCConsole::CmdGetinfo(istringstream &cmd_line , cConnDC *conn )
{
	ostringstream os;
	string s;
	cUser * user;
	while(!cmd_line.eof())
	{
		cmd_line >> s;
		user = mS->mUserList.GetUserByNick(s);
		if(user && user->mxConn)
		{
			if(!mS->mUseDNS)
				user->mxConn->DNSLookup();
			os << mS->mL.user << ": " << s
				 << " " << mS->mL.ip << ": " << user->mxConn->AddrIP()
				 << " " << mS->mL.host << ": " << user->mxConn->AddrHost() << endl;
		}
		else     os << mS->mL.user << ": " << s << mS->mL.not_in_userlist << endl;
	}
	mS->DCPublicHS(os.str().data(),conn);
	return 1;
}

/** quit program */
int cDCConsole::CmdQuit(istringstream &, cConnDC * conn)
{
	ostringstream os;
	os << "Stopping Hub.";
	mS->DCPublicHS(os.str(),conn);
	mS->stop();
	return 1;
}

/** show alll variables along with their values */
int cDCConsole::CmdGetconfig(istringstream & , cConnDC * conn)
{
	ostringstream os;
	cConfigBaseBase::tIVIt it;
	for(it = mS->mC.mvItems.begin();it != mS->mC.mvItems.end(); it++)
		os << setw(20) << mS->mC.mhItems.GetByHash(*it)->mName << " = " << *(mS->mC.mhItems.GetByHash(*it)) << "\r\n";
	mS->DCPrivateHS(os.str(),conn);
	return 1;
}

/** send help message corresponding to connection */
int cDCConsole::CmdHelp(istringstream &, cConnDC * conn)
{
	if(!conn || !conn->mpUser) return 1;
	string file;
	switch(conn->mpUser->mClass)
	{
		case eUC_MASTER : file = mS->mConfigBaseDir+ "/help_master"; mS->SendFileHS(conn, file);
		case eUC_ADMIN :file = mS->mConfigBaseDir + "/help_admin"; mS->SendFileHS(conn, file);
		case eUC_CHEEF : file = mS->mConfigBaseDir + "/help_cheef"; mS->SendFileHS(conn, file);
		case eUC_OPERATOR: file = mS->mConfigBaseDir + "/help_op"; mS->SendFileHS(conn, file);
		case eUC_VIPUSER:
		case eUC_REGUSER: file = mS->mConfigBaseDir + "/help_reg"; mS->SendFileHS(conn, file);
		case eUC_NORMUSER: file = mS->mConfigBaseDir + "/help_usr"; mS->SendFileHS(conn, file);
		default: break;
	}
	return 1;
}

/** send rules */
int cDCConsole::CmdRules(istringstream & , cConnDC * conn)
{
	string file = mS->mConfigBaseDir+ "/rules";
	mS->SendFileHS(conn, file);
	return 1;
}

/** send faq */
int cDCConsole::CmdFaq(istringstream & , cConnDC * conn)
{
	string file = mS->mConfigBaseDir + "/faq";
	mS->SendFileHS(conn, file);
	return 1;
}

/** broadcast a message to pm of all */
int cDCConsole::CmdBroadcast(istringstream & cmd_line, cConnDC * conn, int cl_min, int cl_max)
{
	string start, end, str;
	ostringstream ostr;
	// save the position
	int pos = 1+cmd_line.tellg();

	// test for existence of parameter
	cmd_line >> str;
	if(! str.size())
	{
		ostr << "See !help; use with parameter" << endl;
                mS->DCPublicHS(ostr.str(), conn);
		return 1;
	}

	mS->mP.Create_PMForBroadcast(start,end,mS->mC.hub_security, conn->mpUser->mNick ,cmd_line.str().substr(pos));
	mS->SendToAllWithNick(start,end, cl_min, cl_max);
	if ( mS->LastBCNick != "disable")
		mS->LastBCNick = conn->mpUser->mNick;
	return 1;
}

int cDCConsole::CmdCCBroadcast(istringstream & cmd_line, cConnDC * conn, int cl_min, int cl_max)
{
	string start, end, str, cc_zone;
	ostringstream ostr;
	// save the position
	int pos = 1+cmd_line.tellg();

	// test for existence of parameter
	cmd_line >> cc_zone >> str;
	if(! str.size())
	{
		ostr << "See !help; use with parameter, Usage example !ccbc :US:GB: Hi saxon m8s" << endl;
                mS->DCPublicHS(ostr.str(), conn);
		return 1;
	}

	mS->mP.Create_PMForBroadcast(start,end,mS->mC.hub_security, conn->mpUser->mNick ,cmd_line.str().substr(pos));
	mS->SendToAllWithNickCC(start,end, cl_min, cl_max, cc_zone);
	if ( mS->LastBCNick != "disable")
		mS->LastBCNick = conn->mpUser->mNick;
	return 1;
}

int cDCConsole::CmdMyInfo(istringstream & cmd_line, cConnDC * conn)
{
	ostringstream os;
	string omsg;
	os << "Your info: \r\n";
	conn->mpUser->DisplayInfo(os, eUC_OPERATOR);
	omsg = os.str();
	mS->DCPublicHS(omsg,conn);
	return 1;
}

int cDCConsole::CmdMyIp(istringstream & cmd_line, cConnDC * conn)
{
	ostringstream os;
	string omsg;
	os << "Your IP: " << conn->AddrIP();
	omsg = os.str();
	mS->DCPublicHS(omsg,conn);
	return 1;
}

int cDCConsole::CmdMe(istringstream &cmd_line, cConnDC *conn)
{
	ostringstream os;
	string query,text;

	getline(cmd_line,text);
	os << "** " <<  conn->mpUser->mNick<< text << "";
	string msg = os.str();
	mS->mUserList.SendToAll(msg, true);
	os.str(mS->mEmpty);
	return 1;
}

int cDCConsole::CmdRegMe(istringstream & cmd_line, cConnDC * conn)
{
	ostringstream os;
	string omsg;
	//-- to opchat
	os << "REGME: '" << cmd_line.str().substr(cmd_line.tellg()) <<"'.";
	mS->ReportUserToOpchat(conn, os.str(), mS->mC.dest_regme_chat);
	//-- to user
	os.str(mS->mEmpty);
	os << "Your request has been sent.";
	omsg = os.str();
	mS->DCPublicHS(omsg,conn);
	return 1;
}

int cDCConsole::CmdKick(istringstream & cmd_line, cConnDC * conn)
{
	ostringstream os;
	string omsg, OtherNick, Reason;
	if( conn && conn->mpUser && conn->mpUser->Can(eUR_KICK, mS->mTime.Sec()))
	{
		cmd_line >> OtherNick;
		Reason = cmd_line.str().substr(cmd_line.tellg());
		if (Reason[0] == ' ') Reason = Reason.substr(1);
		if (Reason.size() > 3)
		{
			//os << "You're trying to kick '" << OtherNick << "' because: '" << Reason <<"'";
			mS->DCKickNick(&os, conn->mpUser, OtherNick, Reason,
				cServerDC::eKCK_Drop|cServerDC::eKCK_Reason|cServerDC::eKCK_PM|cServerDC::eKCK_TBAN);
		}
	}
	else
	{
		os << "You cannot kick anyone!!" ;
	}
	omsg = os.str();
	mS->DCPublicHS(omsg,conn);
	return 1;
}

int cDCConsole::CmdRegMyPasswd(istringstream & cmd_line, cConnDC * conn)
{
	string str;
	int crypt = 0;
	ostringstream ostr;
	cRegUserInfo ui;

	if(!mS->mR.FindRegInfo(ui,conn->mpUser->mNick))
		return 0;

	if(!ui.mPwdChange)
	{
		ostr << mS->mL.pwd_cannot;
		mS->DCPrivateHS(ostr.str(),conn);
		mS->DCPublicHS(ostr.str(),conn);
		return 1;
	}

	cmd_line >> str >> crypt;
	if(str.size() < 6)
	{
		ostr << mS->mL.pwd_min;
		mS->DCPrivateHS(ostr.str(),conn);
		mS->DCPublicHS(ostr.str(),conn);
		return 1;
	}
	if(!mS->mR.ChangePwd(conn->mpUser->mNick, str,crypt))
	{
		ostr << mS->mL.pwd_set_error;
		mS->DCPrivateHS(ostr.str(),conn);
		mS->DCPublicHS(ostr.str(),conn);
		return 1;
	}

	ostr << mS->mL.pwd_success;
	mS->DCPrivateHS(ostr.str(),conn);
	mS->DCPublicHS(ostr.str(),conn);
	conn->ClearTimeOut(eTO_SETPASS);
	return 1;
}

/** banlist * /
int cDCConsole::CmdBanList(istringstream & cmd_line, cConnDC * conn, int bantype, bool filter)
{
	string ipnick;
	ostringstream omsg;
	cmd_line >> ipnick;
	if(filter)
	{
		if(!ipnick.size())
		{
			omsg << "use with a paramater";
			mS->DCPublicHS(omsg.str(), conn);
			return 1;
		}
	}
	omsg << "Sorry un available...";
	mS->DCPublicHS(omsg.str(), conn);
	return 1;
	// @todo GetBanList mS->mBanList.GetBanList(conn, bantype, filter? &ipnick :NULL);
	return 1;
}*/

/** make a secret user/op */
int cDCConsole::CmdHideMe(istringstream & cmd_line, cConnDC * conn)
{
	int cls = -1;
	cmd_line >> cls;
	ostringstream omsg;
	if(cls < 0)
	{
		omsg << "Use !hidmeme <class>\r\n <class> the maximum class uf users, that is not allowed to see you." << endl;
		mS->DCPublicHS(omsg.str(),conn);
		return 1;
	}
	if(cls > conn->mpUser->mClass) cls = conn->mpUser->mClass;
	conn->mpUser->mHideKicksForClass = cls;
	omsg << "OK, your kicks are hidden for all lesser than " << cls << " users.";
	mS->DCPublicHS(omsg.str(),conn);
	return 1;
}


/*!
    \fn cDCConsole::CmdUserLimit(istringstream & cmd_line, cConnDC * conn)
    \param
    usage: !userlimit <max_users> [<minutes>=60]
 */
int cDCConsole::CmdUserLimit(istringstream & cmd_line, cConnDC * conn)
{
	string str;
	ostringstream ostr;
	int minutes = 60, maximum = -1;
	cmd_line >> maximum >> minutes;

	if( maximum < 0 )
	{
		ostr << "Try !help (usage !userlimit <max_users> [<minutes>=60])";
		mS->DCPublicHS(ostr.str(), conn);
		return 1;
	}

	// 60 steps at most
	cInterpolExp *fn = new
		cInterpolExp(mS->mC.max_users_total, maximum, (60*minutes) / mS->timer_serv_period ,(6*minutes) / mS->timer_serv_period);
	mS->mTmpFunc.push_back((cTempFunctionBase *)fn);

	ostr << "Starting the max_users change start: "
		<< mS->mC.max_users << " end: " << maximum
		<< " duration: " << minutes << " minutes";
	mS->DCPublicHS(ostr.str(), conn);

	return 1;
}

/** class user (change temporarily his class)
	!class <nick> <new_class_0_to_5>
*/
int cDCConsole::CmdClass(istringstream &cmd_line, cConnDC *conn)
{
	ostringstream os;
	string s;
	cUser * user;
	int nclass = 3, oclass, mclass = conn->mpUser->mClass;

	cmd_line >> s >> nclass;

	if(!s.size() || nclass < 0 || nclass > 5 || nclass >= mclass)
	{
		os << "Try !help, usage !class <nick> [<class>=3]" << endl
			<< "class max is " << mclass << endl;
		mS->DCPublicHS(os.str().data(),conn);
		return 1;
	}


	user = mS->mUserList.GetUserByNick(s);

	if( user && user->mxConn )
	{
		oclass = user->mClass;
		if( oclass < mclass )
		{
			os << mS->mL.user << ": " << s << " temp changing class to " << nclass << endl;
			user->mClass = (tUserCl) nclass;
			if ((oclass < eUC_OPERATOR) && (nclass >= eUC_OPERATOR))
			{
				mS->mOpchatList.Add(user);
				if (!(user->mxConn && user->mxConn->mRegInfo && user->mxConn->mRegInfo->mHideKeys))
				{
					mS->mOpList.Add(user);
					mS->mUserList.SendToAll(mS->mOpList.GetNickList(), false);
				}
			}
			else if ((oclass >= eUC_OPERATOR) && (nclass < eUC_OPERATOR))
			{
				mS->mOpchatList.Remove(user);
				mS->mOpList.Remove(user);
				mS->mUserList.SendToAll(mS->mOpList.GetNickList(), false);
			}
		}
		else
		{
			os << "You don't have privileges to change class of " << s << "." << endl;
		}
	}
	else
	{
		os <<  mS->mL.user << ": " << s << mS->mL.not_in_userlist << endl;
	}
	mS->DCPublicHS(os.str().data(),conn);
	return 1;
}

/** hidekick users until reconnect
	# usage !hidekick <nick> ...
*/
int cDCConsole::CmdHideKick(istringstream &cmd_line, cConnDC *conn)
{
	ostringstream os;
	string s;
	cUser * user;

	while(!cmd_line.eof())
	{
		cmd_line >> s;
		user = mS->mUserList.GetUserByNick(s);
		if(user && user-> mxConn && user->mClass < conn->mpUser->mClass)
		{
			os << mS->mL.user << ": " << s << " kicks are now hidden." << endl;
			user->mHideKick = true;
		}
		else
		{
			os << mS->mL.user << ": " << s << mS->mL.not_in_userlist << endl;
		}
	}
	mS->DCPublicHS(os.str().data(),conn);
	return 1;
}

/** unhidekick user
	usage: !unhidekick <nick> ...
*/
int cDCConsole::CmdUnHideKick(istringstream &cmd_line, cConnDC *conn)
{
	ostringstream os;
	string s;
	cUser * user;

	while(!cmd_line.eof())
	{
		cmd_line >> s;
		user = mS->mUserList.GetUserByNick(s);
		if(user && user-> mxConn && user->mClass < conn->mpUser->mClass)
		{
			os << mS->mL.user << ": " << s << " will show kick messages to chat" << endl;
			user->mHideKick = false;
		}
		else
			os << mS->mL.user << ": " << s << " not found in nicklist (or no rights)." << endl;
	}
	mS->DCPublicHS(os.str().data(),conn);
	return 1;
}

/** protect user against kicks
	!protect <nick> [<against_class>=your_class-1]
*/
int cDCConsole::CmdProtect(istringstream &cmd_line, cConnDC *conn)
{
	ostringstream os;
	string s;
	cUser * user;
	int oclass, mclass = conn->mpUser->mClass, nclass = mclass -1;
	if(nclass > 5) nclass = 5;

	cmd_line >> s >> nclass;

	if(!s.size() || nclass < 0 || nclass > 5 || nclass >= mclass)
	{
		os << "Try !help, usage !protect <nick> [<againstclass>=your_class-1]" << endl
			<< "class max is " << mclass-1 << endl;
		mS->DCPublicHS(os.str().data(),conn);
		return 1;
	}


	user = mS->mUserList.GetUserByNick(s);

	if( user && user->mxConn )
	{
		oclass = user->mClass;
		if( oclass < mclass )
		{
			os << mS->mL.user << ": " << s << " temp changing protection to " << nclass << endl;
			user->mProtectFrom = nclass;
		}
		else
			os << "You don't have privileges to protect of " << s << "." << endl;
	}
	else
	{
		os << mS->mL.user << ": " << s << " not found in nicklist." << endl;
	}
	mS->DCPublicHS(os.str().data(),conn);
	return 1;
}

int cDCConsole::CmdReload(istringstream &cmd_line, cConnDC *conn)
{
	ostringstream os;

	os << "Reloading triggers ,configuration and reglist cache." << endl;
	mTriggers.ReloadAll();
	mS->mC.Load();
	mS->DCPublicHS(os.str().data(),conn);
	if (mS->mC.use_reglist_cache) mS->mR.UpdateCache();
	return 1;
}

bool cDCConsole::cfReport::operator()()
{
	ostringstream os;
	string omsg, nick, reason;
	cUser *user;
	enum { eREP_ALL, eREP_NICK, eREP_RASONP, eREP_REASON };

	GetParOnlineUser(eREP_NICK, user, nick);
	GetParStr(eREP_REASON, reason);

	//-- to opchat
	os << "REPORT: user '" << nick <<"' ";
	if (user && user->mxConn)
	{
		os << "IP= '" << user->mxConn->AddrIP() << "' HOST='" << user->mxConn->AddrHost() << "' ";
	} else os << "which is offline ";
	os << "Reason='" << reason  << "'. reporter";
	//os << cmd_line.str().substr(cmd_line.tellg()) << "'.";
	mS->ReportUserToOpchat(mConn, os.str(), mS->mC.dest_report_chat);
	//-- to sender
	*mOS << "Thanx, your report has been accepted. ";
	return true;
}

bool cDCConsole::cfRaw::operator()()
{
	enum { eRW_ALL, eRW_USR, eRW_HELLO, eRW_PASSIVE , eRW_ACTIVE};
	static const char * actionnames [] = { "all","user","hello","active" };
	static const int actionids [] = { eRW_ALL, eRW_USR, eRW_HELLO, eRW_ACTIVE };

	enum { eRC_HUBNAME, eRC_HELLO, eRC_QUIT, eRC_ANY , eRC_REDIR, eRC_PM, eRC_CHAT };
	static const char * cmdnames [] = { "hubname","hello","quit", "any", "redir", "pm", "chat" };
	static const int cmdids [] = { eRC_HUBNAME, eRC_HELLO, eRC_QUIT, eRC_ANY , eRC_REDIR , eRC_PM, eRC_CHAT};

	int Action = -1;
	int CmdID = -1;

	string tmp;

   //@todo eventualy use cUser::Can
	if (this->mConn->mpUser->mClass < eUC_ADMIN) return false;
	mIdRex->Extract(1,mIdStr,tmp);
	Action = this->StringToIntFromList(tmp, actionnames, actionids, sizeof(actionnames)/sizeof(char*));
	if (Action <0) return false;

	mIdRex->Extract(2,mIdStr,tmp);
	CmdID  = this->StringToIntFromList(tmp, cmdnames, cmdids, sizeof(cmdnames)/sizeof(char*));
	if (CmdID <0) return false;

	string theCommand, endOfCommand;
	string param, nick;
	GetParStr(1,param);
	bool WithNick = false;
	int pos = 0;

	switch (CmdID)
	{
		case eRC_HUBNAME: theCommand = "$HubName "; break;
		case eRC_HELLO: theCommand = "$Hello "; break;
		case eRC_QUIT: theCommand = "$Quit "; break;
		case eRC_REDIR: theCommand = "$ForceMove "; break;
		case eRC_PM:
			mS->mP.Create_PMForBroadcast(
				theCommand,
				endOfCommand,
				mS->mC.hub_security,
				mConn->mpUser->mNick,
				param);
			WithNick = true;
		break;
		case eRC_CHAT: theCommand = "<" + mConn->mpUser->mNick +"> "; break;
		case eRC_ANY:
			cDCProto::UnEscapeChars(param, param);
			break;
		default : return false; break;
	}

	if (!WithNick)
	{
		theCommand += param;
		theCommand += "|";
	}

	cUser *target_usr = NULL;
	switch (Action)
	{
		case eRW_ALL: if(!WithNick) mS->mUserList.SendToAll(theCommand);
			else mS->mUserList.SendToAllWithNick(theCommand, endOfCommand); break;
		case eRW_HELLO: if(!WithNick) mS->mHelloUsers.SendToAll(theCommand);
			else mS->mHelloUsers.SendToAllWithNick(theCommand, endOfCommand);break;
		case eRW_ACTIVE: if(!WithNick) mS->mActiveUsers.SendToAll(theCommand);
			else mS->mActiveUsers.SendToAllWithNick(theCommand, endOfCommand); break;
		case eRW_USR:
			target_usr = mS->mUserList.GetUserByNick(nick);
			if (target_usr && target_usr->mxConn)
			{
				if( WithNick)
				{
					theCommand += nick;
					theCommand += endOfCommand;
				}
				target_usr->mxConn->Send(theCommand);
			}
		break;
		default: return false; break;
	}
	return true;
}

bool cDCConsole::cfBan::operator()()
{

	static const char *bannames[]={"nick", "ip", "nickip", "", "range", "host1", "host2" , "host3", "hostr1",  "share", "email" , "prefix"};
	static const int banids[]= {cBan::eBF_NICK, cBan::eBF_IP, cBan::eBF_NICKIP, cBan::eBF_NICKIP, cBan::eBF_RANGE,
      cBan::eBF_HOST1, cBan::eBF_HOST2, cBan::eBF_HOST3, cBan::eBF_HOSTR1, cBan::eBF_SHARE, cBan::eBF_EMAIL, cBan::eBF_PREFIX };

	enum { BAN_BAN, BAN_UNBAN, BAN_INFO, BAN_LIST };
	static const char *prefixnames[]={"add", "new", "rm", "del", "un", "info", "check", "list", "ls" };
	static const int prefixids[]= { BAN_BAN, BAN_BAN, BAN_UNBAN, BAN_UNBAN, BAN_UNBAN, BAN_INFO, BAN_INFO, BAN_LIST, BAN_LIST};

	cBan Ban(mS);
	int BanType = cBan::eBF_NICKIP;
	cKick Kick;
	time_t BanTime = 0;
	string tmp;
	int Count = 0;
	int MyClass = 0;
	if( !mConn->mpUser ) return false;
	MyClass = mConn->mpUser->mClass;
	if( MyClass < eUC_OPERATOR ) return false;

	//"!(un)?ban([^_\\s]+)?(_(\\d+\\S))?( this (nick|ip))? ", "(\\S+)( (.*)$)?"

	enum { BAN_PREFIX = 1, BAN_TYPE = 2, BAN_LENGTH = 4, BAN_THIS = 6, BAN_WHO = 1, BAN_REASON = 3};
	bool IsNick = false;
	bool IsPerm = !mIdRex->PartFound(BAN_LENGTH);

	int BanAction = BAN_BAN;
	if( mIdRex->PartFound(BAN_PREFIX) )
	{
		mIdRex->Extract( BAN_PREFIX, mIdStr, tmp);
		BanAction = this->StringToIntFromList(tmp, prefixnames, prefixids, sizeof(prefixnames)/sizeof(char*));
		if (BanAction < 0) return false;
	}

	if(mIdRex->PartFound(BAN_TYPE))
	{
		mIdRex->Extract( BAN_TYPE, mIdStr, tmp);
		BanType = this->StringToIntFromList(tmp, bannames, banids, sizeof(bannames)/sizeof(char*));
		if (BanType < 0) return false;
	}

	if (BanType == cBan::eBF_NICK) IsNick = true;

	if ( mIdRex->PartFound(BAN_THIS) )
		IsNick = ((0 == mIdRex->Compare( BAN_TYPE, mIdStr, "nick")) || (BanType == cBan::eBF_NICK));

	string Who;
	GetParUnEscapeStr(BAN_WHO, Who);

	if(!IsPerm)
	{
		mIdRex->Extract(BAN_LENGTH, mIdStr,tmp);
		if(tmp != "perm")
		{
			BanTime = mS->Str2Period(tmp, *mOS);
			if(BanTime < 0)
			{
				(*mOS) << "Negative ban-time ... are you fool?";
				return false;
			}
		} else IsPerm = true;
	}

	bool unban = (BanAction == BAN_UNBAN);
	cUser *user = NULL;

	switch (BanAction)
	{
	case BAN_UNBAN:
	case BAN_INFO:
		if (unban)
		{
			//if ( ! mParRex->PartFound(BAN_REASON) )
			if( !GetParStr(BAN_REASON,tmp))
			{
				(*mOS) << "Why?? Gimme one good reason..";
				return false;
			}
			//mParRex->Extract(BAN_REASON, mParStr,tmp);

			(*mOS) << "Unbanning...\r\n";
		}

		if(BanType == cBan::eBF_NICKIP)
		{
			Count += mS->mBanList.Unban(*mOS, Who, tmp, mConn->mpUser->mNick, cBan::eBF_NICK, unban);
			Count += mS->mBanList.Unban(*mOS, Who, tmp, mConn->mpUser->mNick, cBan::eBF_IP, unban);
			if(!unban)
			{
				Count += mS->mBanList.Unban(*mOS, Who, tmp, mConn->mpUser->mNick, cBan::eBF_RANGE, false);
				string Host;
				if (mConn->DNSResolveReverse(Who, Host)) {
					Count += mS->mBanList.Unban(*mOS, Host, tmp, mConn->mpUser->mNick, cBan::eBF_HOSTR1, false);
					Count += mS->mBanList.Unban(*mOS, Host, tmp, mConn->mpUser->mNick, cBan::eBF_HOST3, false);
					Count += mS->mBanList.Unban(*mOS, Host, tmp, mConn->mpUser->mNick, cBan::eBF_HOST2, false);
					Count += mS->mBanList.Unban(*mOS, Host, tmp, mConn->mpUser->mNick, cBan::eBF_HOST1, false);
				}
			}
		}
		else if(BanType == cBan::eBF_NICK) {
			Count += mS->mBanList.Unban(*mOS, Who, tmp, mConn->mpUser->mNick, cBan::eBF_NICK, unban);
			Count += mS->mBanList.Unban(*mOS, Who, tmp, mConn->mpUser->mNick, cBan::eBF_NICKIP, unban);
		}
		else
		{
			Count += mS->mBanList.Unban(*mOS, Who, tmp, mConn->mpUser->mNick, BanType, unban);
		}
		(*mOS) << endl << "Total : " << Count << " bans.";
		break;
	case BAN_BAN:
		Ban.mNickOp = mConn->mpUser->mNick;
		mParRex->Extract(BAN_REASON, mParStr,Ban.mReason);
		Ban.mDateStart = cTime().Sec();
		if(BanTime)
			Ban.mDateEnd = Ban.mDateStart+BanTime;
		else
			Ban.mDateEnd = 0;
		Ban.SetType(BanType);

		switch (BanType)
		{
		case cBan::eBF_NICKIP:
		case cBan::eBF_NICK:
		case cBan::eBF_IP:
			if( mS->mKickList.FindKick(Kick, Who, mConn->mpUser->mNick, 3000, true, true, IsNick) )
			{
				mS->mBanList.NewBan(Ban, Kick, BanTime, BanType );
				if( mParRex->PartFound(BAN_REASON) )
				{
					mParRex->Extract(BAN_REASON, mParStr,tmp);
					Ban.mReason += "\r\n";
					Ban.mReason += tmp;
				}
			} else {
				if ( !mParRex->PartFound(BAN_REASON) )
				{
					(*mOS) << "and what is the reason ???";
					return false;
				}
				if (BanType == cBan::eBF_NICKIP) BanType = cBan::eBF_IP;
				mParRex->Extract(BAN_REASON, mParStr,Kick.mReason);
				Kick.mOp = mConn->mpUser->mNick;
				Kick.mTime = cTime().Sec();

				if (BanType == cBan::eBF_NICK)
					Kick.mNick = Who;
				else
					Kick.mIP = Who;

				mS->mBanList.NewBan(Ban, Kick, BanTime, BanType);
			}
			break;

		case cBan::eBF_HOST1:
		case cBan::eBF_HOST2:
		case cBan::eBF_HOST3:
		case cBan::eBF_HOSTR1:
			if ( !mParRex->PartFound(BAN_REASON) )
			{
				(*mOS) << "and what is the reason ???";
				return false;
			}
			if ( MyClass < (eUC_ADMIN - (BanType - cBan::eBF_HOST1) ) ) //@todo rights
			{
				(*mOS) << "Not priviledged, sorry";
				return false;
			}
			Ban.mHost = Who;
			Ban.mIP = Who;
			break;
		case cBan::eBF_RANGE:
			if(! cDCConsole::GetIPRange(Who, Ban.mRangeMin, Ban.mRangeMax) )
			{
				(*mOS) << "Unknown Range format '" << Who << "'";
				return false;
			}
			Ban.mIP=Who;
			break;
		case cBan::eBF_PREFIX:
			if ( !mParRex->PartFound(BAN_REASON) )
			{
				(*mOS) << "and what is the reason ???";
				return false;
			}
			Ban.mNick = Who;
			break;
		default: break;
		}

		user = mS->mUserList.GetUserByNick(Ban.mNick);
		if (user != NULL)
		{
			mS->DCKickNick(mOS, mConn->mpUser, Ban.mNick, Ban.mReason, cServerDC::eKCK_Reason | cServerDC::eKCK_Drop);
		}

		mS->mBanList.AddBan(Ban);
		(*mOS) << "Adding ban: ";
		Ban.DisplayComplete(*mOS);
		break;
	case BAN_LIST:
		mS->mBanList.List(*mOS);
	break;
	default: break;
	}
	return true;
}

bool cDCConsole::cfInfo::operator()()
{
	enum {eINFO_SERVER };
	static const char * infonames [] = { "hub","server" };
	static const int infoids [] = { eINFO_SERVER, eINFO_SERVER };

	string tmp;
	mIdRex->Extract(1,mIdStr,tmp);

	int InfoType = this->StringToIntFromList(tmp, infonames, infoids, sizeof(infonames)/sizeof(char*));
	if (InfoType < 0) return false;

	int MyClass = mConn->mpUser->mClass;
	if( MyClass < eUC_VIPUSER ) return false;

	switch(InfoType)
	{
		case eINFO_SERVER: mInfoServer.Output(*mOS, MyClass); break;
		default : (*mOS) << "Sorry, not implemented yet" << endl;
			return false;
	}

	return true;
}

bool cDCConsole::cfTrigger::operator()()
{
	string ntrigger;
	string text, cmd;

   //@todo Use cUser::Can
	if(mConn->mpUser->mClass < eUC_ADMIN) return false;
   mIdRex->Extract(2,mIdStr,cmd);

	enum {eAC_ADD, eAC_DEL, eAC_EDIT, eAC_DEF, eAC_FLAGS};
	static const char *actionnames[]={"new","add","del","edit","def", "setflags"};
	static const int actionids[]={eAC_ADD, eAC_ADD, eAC_DEL, eAC_EDIT, eAC_DEF, eAC_FLAGS};
	int Action = this->StringToIntFromList(cmd, actionnames, actionids, sizeof(actionnames)/sizeof(char*));
	if (Action < 0) return false;

	mParRex->Extract(1,mParStr,ntrigger);
	mParRex->Extract(2,mParStr,text);
	int i;
	int flags = 0;
	istringstream is(text);
	bool result = false;
	cTrigger *tr;

	switch(Action)
	{
	case eAC_ADD:
		tr = new cTrigger;
		tr->mCommand = ntrigger;
		tr->mDefinition = text;
		//mCo->mTriggers.AddTrigger(tr);
		//mCo->mTriggers.
		break;

		case eAC_EDIT:
		for( i = 0; i < ((cDCConsole*)mCo)->mTriggers.Size(); ++i )
		{
			if( ntrigger == ((cDCConsole*)mCo)->mTriggers[i]->mCommand )
			{
				mS->SaveFile((((cDCConsole*)mCo)->mTriggers[i])->mDefinition,text);
				result = true;
				break;
			}
		}
		break;
	case eAC_FLAGS:
		flags = -1;
		is >> flags;
		if (flags >= 0) {
			for( i = 0; i < ((cDCConsole*)mCo)->mTriggers.Size(); ++i )
			{
				if( ntrigger == ((cDCConsole*)mCo)->mTriggers[i]->mCommand )
				{
				((cDCConsole*)mCo)->mTriggers[i]->mFlags = flags;
				((cDCConsole*)mCo)->mTriggers.SaveData(i);
				result = true;
				break;
				}
			}
		}

		break;
	default: (*mOS) << "Not implemented" << endl;
		break;
	};
		return result;
}

bool cDCConsole::cfSetVar::operator()()
{
	string file(mS->mDBConf.config_name),var,val;

   //@todo use cUser::Can
   //@todo per-variable rights
	if(mConn->mpUser->mClass < eUC_ADMIN) return false;

	if (mParRex->PartFound(1)) mParRex->Extract(1,mParStr,file);
	mParRex->Extract(2,mParStr,var);
	mParRex->Extract(3,mParStr,val);

	cConfigItemBase *ci = NULL;
	if (file == mS->mDBConf.config_name)
	{
		ci = mS->mC[var];

		if( !ci )
		{
			(*mOS) << "Undefined variable: " << var;
			return false;
		}
	}

	if (ci)
	{
		(*mOS) << "Changing " << var << " from: '" << *ci << "'";
		ci->ConvertFrom(val);
		(*mOS) << " => '" << *ci << "'";
		mS->mSetupList.SaveItem(file.data(), ci);
	}

	return true;
}


bool cDCConsole::cfGag::operator()()
{
	string cmd, nick, howlong;
	time_t period = 24*3600*7;
	time_t Now = 1;

	bool isUn = false;

   //@todo use cUser::Can
	if(mConn->mpUser->mClass < eUC_OPERATOR) return false;

	isUn = mIdRex->PartFound(1);
	mIdRex->Extract(2, mIdStr, cmd);

	mParRex->Extract(1, mParStr, nick);
	if (mParRex->PartFound(3))
	{
		mParRex->Extract(3, mParStr, howlong);
		period = mS->Str2Period(howlong, *mOS);
		if (!period) return false;
	}

	cPenaltyList::sPenalty penalty;
	penalty.mNick = nick;

	if(!isUn) Now = cTime().Sec() + period;

	enum {eAC_GAG, eAC_NOPM, eAC_NODL, eAC_NOSEARCH, eAC_KVIP, eAC_NOSHARE, eAC_CANREG};
	static const char *actionnames[]={"gag","nochat","nopm","noctm","nodl","nosearch","kvip", "maykick", "noshare", "mayreg"};
	static const int actionids[]={eAC_GAG, eAC_GAG,eAC_NOPM, eAC_NODL, eAC_NODL, eAC_NOSEARCH, eAC_KVIP, eAC_KVIP, eAC_NOSHARE, eAC_CANREG};
	int Action = this->StringToIntFromList(cmd, actionnames, actionids, sizeof(actionnames)/sizeof(char*));
	if (Action < 0) return false;

	switch(Action)
	{
		case eAC_GAG: penalty.mStartChat = Now; break;
		case eAC_NOPM: penalty.mStartPM = Now; break;
		case eAC_NODL: penalty.mStartCTM = Now; break;
		case eAC_NOSEARCH: penalty.mStartSearch = Now; break;
		case eAC_KVIP: penalty.mStopKick = Now; break;
		case eAC_NOSHARE: penalty.mStopShare0 = Now; break;
		case eAC_CANREG: penalty.mStopReg = Now; break;
		default: return false;
	};

	bool ret = false;
	if(!isUn) ret = mS->mPenList.AddPenalty(penalty);
	else ret = mS->mPenList.RemPenalty(penalty);

	cUser *usr = mS->mUserList.GetUserByNick(nick);
	if (usr != NULL)
	{
		switch(Action)
		{
			case eAC_GAG: usr->SetRight(eUR_CHAT, penalty.mStartChat, isUn); break;
			case eAC_NOPM: usr->SetRight(eUR_PM, penalty.mStartPM, isUn); break;
			case eAC_NODL: usr->SetRight(eUR_CTM, penalty.mStartCTM, isUn); break;
			case eAC_NOSEARCH: usr->SetRight(eUR_SEARCH, penalty.mStartSearch, isUn); break;
			case eAC_NOSHARE: usr->SetRight(eUR_NOSHARE, penalty.mStopShare0, isUn); break;
			case eAC_CANREG: usr->SetRight(eUR_REG, penalty.mStopReg, isUn); break;
			case eAC_KVIP: usr->SetRight(eUR_KICK, penalty.mStopKick, isUn); break;
			default: break;
		};
	}

	(*mOS) << penalty ;
	if (ret) (*mOS) << " saved OK ";
	else (*mOS) << " save error ";
	return true;
}

bool cDCConsole::cfCmd::operator()()
{
	enum { eAC_LIST };
	static const char * actionnames [] = { "list", "lst" };
	static const int actionids [] = { eAC_LIST, eAC_LIST };

	string tmp;
	mIdRex->Extract(1,mIdStr,tmp);
	int Action = this->StringToIntFromList(tmp, actionnames, actionids, sizeof(actionnames)/sizeof(char*));
	if (Action < 0) return false;

	
	switch(Action)
	{
//		case eAC_LIST: this->mS->mCo.mCmdr.List(mOS); break;
		default: return false;
	}
	return true;
}

bool cDCConsole::cfWho::operator()()
{
	enum { eAC_IP, eAC_RANGE };
	static const char * actionnames [] = { "ip" , "range", "subnet" };
	static const int actionids [] = { eAC_IP, eAC_RANGE, eAC_RANGE };

   //@todo use cUser::Can 
	if (this->mConn->mpUser->mClass < eUC_OPERATOR) return false;

   string tmp;
	mIdRex->Extract(2,mIdStr,tmp);
	int Action = this->StringToIntFromList(tmp, actionnames, actionids, sizeof(actionnames)/sizeof(char*));
	if (Action < 0) return false;

	string separator("\r\n\t");
	string userlist;

	mParRex->Extract(0, mParStr,tmp);
	unsigned long ip_min, ip_max;
	int cnt = 0;

	switch(Action)
	{
		case eAC_IP:
			ip_min = cBanList::Ip2Num(tmp);
			ip_max = ip_min;
			cnt = mS->WhoIP(ip_min, ip_max, userlist, separator, true);
			break;
		case eAC_RANGE:
			if(! cDCConsole::GetIPRange(tmp, ip_min, ip_max) ) return false;
			cnt = mS->WhoIP(ip_min, ip_max, userlist, separator, false);
			break;
		default: return false;
	}


	if(!cnt) (*mOS) << "No user with " << tmp;
	else (*mOS) << "Users with " << actionnames[Action] << " " << tmp << ":\r\n\t" << userlist << "Total: " << cnt;
	return true;
}

bool cDCConsole::cfKick::operator()()
{
	enum { eAC_KICK, eAC_DROP, eAC_FLOOD };
	static const char * actionnames [] = { "kick", "drop", "flood" };
	static const int actionids [] = { eAC_KICK, eAC_DROP, eAC_FLOOD };

	if (this->mConn->mpUser->mClass < eUC_VIPUSER) return false;
	string tmp;
	mIdRex->Extract(1,mIdStr,tmp);
	int Action = this->StringToIntFromList(tmp, actionnames, actionids, sizeof(actionnames)/sizeof(char*));
	if (Action < 0) return false;

	string nick, text;

	mParRex->Extract(1,mParStr,nick);

	ostringstream os;
	string CoolNick, ostr;
	int i;
	cUser *other;

	switch(Action)
	{
		case eAC_KICK:
			if (!mParRex->PartFound(2))
			{
				(*mOS) << "What about the reason ??" << endl;
				return false;
			}
			mParRex->Extract(2,mParStr,text);
		case eAC_DROP:
			mS->DCKickNick(mOS, this->mConn->mpUser, nick, text,
				(Action == eAC_KICK)?
				(cServerDC::eKCK_Drop|cServerDC::eKCK_Reason|cServerDC::eKCK_PM|cServerDC::eKCK_TBAN):
				(cServerDC::eKCK_Drop|cServerDC::eKCK_Reason));
		break;
		case eAC_FLOOD:
			text += "\r\n";
			other = mS->mUserList.GetUserByNick(nick);
			if (
				other && other->mxConn &&
				(other->mClass < mConn->mpUser->mClass) &&
				(other->mProtectFrom < mConn->mpUser->mClass))
			{
				for (i = 0; i < 10000; i++)
				{
					os.str(string(""));
					os << 1000+rand()%9000 << "Flood" << i;
					CoolNick = os.str();
					os.str(string(""));
					os << "$Hello " << CoolNick << "|";
					mS->mP.Create_PM(ostr, CoolNick, nick, CoolNick, text);
					os << ostr << "|";
					ostr = os.str();
					other->mxConn->Send(ostr, false);
				}
			}
		break;
		default: (*mOS) << "Not implemented" << endl;
		return false;
	};
	return true;
}

bool cDCConsole::cfPlug::operator()()
{
	enum { eAC_IN, eAC_OUT, eAC_LIST, eAC_REG, eAC_RELAOD };
	static const char * actionnames [] = { "in","out","list","reg","reload"};
	static const int actionids [] = { eAC_IN, eAC_OUT, eAC_LIST, eAC_REG, eAC_RELAOD };

	string tmp;
	mIdRex->Extract(1,mIdStr,tmp);
	int Action = this->StringToIntFromList(tmp, actionnames, actionids, sizeof(actionnames)/sizeof(char*));
	if (Action < 0) return false;

	switch (Action)
	{
	case eAC_LIST:
		(*mOS) << "Plugins loaded: \r\n";
		mS->mPluginManager.List(*mOS);
		break;
	case eAC_REG:
		(*mOS) << "Callbacks available: \r\n";
		mS->mPluginManager.ListAll(*mOS);
		break;
	case eAC_OUT:
		if (mParRex->PartFound(1))
		{
			mParRex->Extract(1, mParStr, tmp);
			if(!mS->mPluginManager.UnloadPlugin(tmp)) return false;
		}
		break;
	case eAC_IN:
		if (mParRex->PartFound(1))
		{
			mParRex->Extract(1, mParStr, tmp);
			if(!mS->mPluginManager.LoadPlugin(tmp))
			{
				(*mOS) << mS->mPluginManager.GetError() << "\r\n";
				return false;
			}
		}
		break;
	case eAC_RELAOD:
		if (GetParStr(1, tmp))
		{
			if(!mS->mPluginManager.ReloadPlugin(tmp))
			{
				(*mOS) << mS->mPluginManager.GetError() << "\r\n";
				return false;
			}
		}
		break;
	default: break;
	}
	return true;
}

bool cDCConsole::cfRegUsr::operator()()
{
	enum { eAC_NEW, eAC_DEL, eAC_PASS, eAC_ENABLE, eAC_DISABLE, eAC_CLASS, eAC_PROTECT, eAC_HIDEKICK, eAC_SET, eAC_INFO };
	static const char * actionnames [] = { "n","new","newuser", "del","delete", "pass","passwd", "enable",
		"disable", "class", "setclass", "protect", "protectclass", "hidekick", "hidekickclass", "set","=",
		"info"  };
	static const int actionids [] = { eAC_NEW, eAC_NEW, eAC_NEW, eAC_DEL, eAC_DEL, eAC_PASS, eAC_PASS, eAC_ENABLE,
		eAC_DISABLE, eAC_CLASS, eAC_CLASS, eAC_PROTECT, eAC_PROTECT, eAC_HIDEKICK, eAC_HIDEKICK, eAC_SET, eAC_SET,
		eAC_INFO };

	string tmp;
	mIdRex->Extract(2,mIdStr,tmp);
	int Action = this->StringToIntFromList(tmp, actionnames, actionids, sizeof(actionnames)/sizeof(char*));
	if (Action < 0) return false;

//	"!r(eg)?(\S+) ", "(\\S+)( (((\\S+) )?(.*)))?"
	string nick, par, field;

	int ParClass = 1;
	int MyClass = this->mConn->mpUser->mClass;
	if ((Action != eAC_INFO) && (! this->mConn->mpUser->Can(eUR_REG,mS->mTime.Sec()))) return false;

	mParRex->Extract(1,mParStr,nick);
	bool WithPar = false;

 	WithPar=mParRex->PartFound(3);
	if( Action != eAC_SET && WithPar)	mParRex->Extract(3,mParStr,par);

	if( Action == eAC_SET )
	{
		WithPar = WithPar && mParRex->PartFound(5);
		if( !WithPar )
		{
			(*mOS) << "Missing parameter(s)";
			return false;
  		}
		mParRex->Extract(5,mParStr,field);
		if(WithPar) mParRex->Extract(6,mParStr,par);
 	}


	cUser *user = mS->mUserList.GetUserByNick(nick);
	cRegUserInfo ui;
	ostringstream ostr;
	bool RegFound = mS->mR.FindRegInfo(ui, nick);
	bool authorized = false;

	// check rights

	if (RegFound)
	{
		if ((MyClass < eUC_MASTER) && !(
			(MyClass >= (ui.mClass+mS->mC.classdif_reg) &&
			MyClass >= (ui.mClassProtect)) ||
			((Action == eAC_INFO) &&(MyClass >= (ui.mClass - 1)))
		 ))
		{
			(*mOS) << "You are not allowed to touch him..";
			return false;
		}
	}

	switch(Action)
	{
		case eAC_CLASS: case eAC_PROTECT: case eAC_HIDEKICK: case eAC_NEW:
		 	std::istringstream lStringIS(par);
			lStringIS >> ParClass;
		break;
	};

	switch(Action)
	{
		case eAC_SET: authorized = RegFound && (( MyClass >= eUC_ADMIN ) && (MyClass > ui.mClass)); break;
		case eAC_NEW:
			authorized = !RegFound  && (MyClass >= (ParClass + mS->mC.classdif_reg));
			break;
		case eAC_PASS: case eAC_HIDEKICK: case eAC_ENABLE: case eAC_DISABLE: case eAC_DEL:
			authorized = RegFound && (MyClass >= (ui.mClass+mS->mC.classdif_reg));
			break;
		case eAC_CLASS:
			authorized = RegFound && (MyClass >= (ui.mClass+mS->mC.classdif_reg)) && (MyClass >= (ParClass + mS->mC.classdif_reg));
			break;
		case eAC_PROTECT:
			authorized = RegFound && (MyClass >= (ui.mClass+mS->mC.classdif_reg)) && (MyClass >= (ParClass + 1));
			break;
		case eAC_INFO : authorized = RegFound && (MyClass >= eUC_OPERATOR); break;
	};

	if (MyClass == eUC_MASTER) authorized = true;

	if (!authorized)
	{
		if (!RegFound) *mOS << " No user '" << nick << "' is registered in database..";
		else if (Action == eAC_NEW) *mOS << "User '" << nick << "' already exists";
		else *mOS << "You have insufficielnt rights to do this.";
		return false;
	}

 	if( Action >= eAC_CLASS && Action <= eAC_SET && !WithPar)
 	{
 		(*mOS) << "Missing Parameter";
 		return false;
  	}

	switch (Action)
	{
	case eAC_NEW: // new
		if (RegFound)
		{
			(*mOS) << "User already registered.";
			return false;
		}

		if (mS->mR.AddRegUser(nick, mConn, ParClass))
		{
			if(user && user->mxConn)
			{
				ostr.str(mS->mEmpty);
				ostr << mS->mL.pwd_setup;
				mS->DCPrivateHS(ostr.str(), user->mxConn);
			}
			(*mOS) << "User added, tell him to change his password, I did so.";
		}
		else
		{
			(*mOS) << "Strange error..";
			return false;
		}
		break;
	case eAC_DEL: // delete
		if (mS->mR.DelReg(nick))
		{
			(*mOS) << "Deleted reg user '" << nick << "' from database..\r\n"
				<< "His info: " << ui <<"\r\n";
		}
		else
		{
			(*mOS) << "Some error occured while deleting '" << nick << "' , probably bug.\r\n"
				<< "User's info is: " << ui <<"\r\n";
			return false;
		}
		break;
	case eAC_PASS: // pass
		if (WithPar)
		{
			#if ! defined _WIN32
			if ( mS->mR.ChangePwd(nick, par, 1) )
			#else
			if ( mS->mR.ChangePwd(nick, par, 0) )
			#endif
				(*mOS) << "Success";
			else
			{
				(*mOS) << "Error";
				return false;
			}
		} else {
			field="pwd_change";
			par="1";
			ostr << mS->mL.pwd_can;
		}
		break;
	case eAC_CLASS: // class
		field="class";
		ostr << "Your class has been changed to :" << par << ", takes effect on next login.";
		break;
	case eAC_ENABLE: //enable
		field="enabled";
		par="1";
		WithPar= true;
		ostr << "Your registration has been enabled";
		break;
	case eAC_DISABLE: // disable
		field="enabled";
		par="0";
		WithPar= true;
		ostr << "Your registration has been (temporarily?) disabled";
		break;
	case eAC_PROTECT: // protect
		field="class_protect";
		ostr << "You are now on protected by level: " << par;
      if (user) user->mProtectFrom = ParClass;
		break;
	case eAC_HIDEKICK: // hidekick
		field="class_hidekick";
		ostr << "You are now (in DB) on the hidekick level: " << par;
		break;
	case eAC_SET: break; // set
	case eAC_INFO: (*mOS) << ui << endl; break;
	default:
		mIdRex->Extract(1,mIdStr,par);
		(*mOS) << "Verliba is extrememly sorry, He forgot to implement this '" << par << "' command";
		return false;
		break;
	}

	if( (WithPar && (Action >=eAC_ENABLE) && (Action <=eAC_SET)) || ( (Action==eAC_PASS) && !WithPar ))
	{
		if (mS->mR.SetVar(nick, field, par))
  		{
  			(*mOS) << "Success: seting variable " << field << " to value " << par << " for user " << nick;
			if(user && user->mxConn) mS->DCPrivateHS(ostr.str(), user->mxConn);
    	}
    	else
    	{
			(*mOS) << "error setting variable " << field << " to value " << par << " for user " << nick;
     		return false;
  		}
	}
	(*mOS) << "OK";
	return true;
}

};


/*!
    \fn nDirectConnect::cDCConsole::GetIPRange(const string &range, unsigned long &from, unsigned long &to)
 */
bool nDirectConnect::cDCConsole::GetIPRange(const string &range, unsigned long &from, unsigned long &to)
{
	//"^(\\d+\\.\\d+\\.\\d+\\.\\d+)((\\/(\\d+))|(\\.\\.|-)(\\d+\\.\\d+\\.\\d+\\.\\d+))?$"
	enum {R_IP1 = 1, R_RANGE = 2, R_BITS=4, R_DOTS = 5, R_IP2 = 6};
	if (!mIPRangeRex.Exec(range)) return false;
	string tmp;
	// easy : from..to
	if (mIPRangeRex.PartFound(R_RANGE))
	{
		if (mIPRangeRex.PartFound(R_DOTS))
		{
			mIPRangeRex.Extract(R_IP1, range, tmp);
			from = cBanList::Ip2Num(tmp);
			mIPRangeRex.Extract(R_IP2, range, tmp);
			to = cBanList::Ip2Num(tmp);
			return true;
		}
		// the more complicated 1.2.3.4/16 style mask
		else
		{
			unsigned long mask = 0;
			unsigned long addr1 = 0;
			unsigned long addr2 = 0xFFFFFFFF;
			mIPRangeRex.Extract(0, range, tmp);
			from = cBanList::Ip2Num(tmp);
			int i;
			i = tmp.find_first_of("/\\");
			istringstream is(tmp.substr(i+1));
			mask = from;
			is >> i;
			addr1 = mask & (0xFFFFFFFF << (32-i));
			addr2 = addr1 + (0xFFFFFFFF >> i);
			from = addr1;
			to   = addr2;
			/*
			ostringstream os;
			unsigned char *arr= (unsigned char *)&addr1;
			os << (int)arr[3] << "." << (int)arr[2] << "." << (int)arr[1] << "." << (int)arr[0];
			from = os.str();
			os.str(string());
			arr = (unsigned char *)&addr2;
			os << (int)arr[3] << "." << (int)arr[2] << "." << (int)arr[1] << "." << (int)arr[0];
			to = os.str();
			*/
			return true;
		}
	} else
	{
		mIPRangeRex.Extract(R_IP1, range, tmp);
		from = cBanList::Ip2Num(tmp);
		to = from;
		return true;
	}
	return false;
}
