/***************************************************************************
                          cdcproto.h  -  description
                             -------------------
    begin                : Wed Jul 2 2003
    copyright            : (C) 2003 by Daniel Muller
    email                : dan at verliba dot cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDCPROTO_H
#define CDCPROTO_H

#include <string>
#include "cpcre.h"

using nUtils::cPCRE;
using namespace std;
/**
  * \brief Encaplulates all Direct Connect related classes methods etc..
  */
namespace nDirectConnect {

class cConnDC;
class cServerDC;
class cUser;

/**
  * \brief Mostly DC protocol related stuff
  */
namespace nProtocol {

class cMessageDC;

/**protocol part of the server
  *@author Daniel Muller
  */
class cDCProto
{
	friend class cServerDC;
public:
	cDCProto(cServerDC &serv);
	/** sends userlist and oplist */
	int NickList(cConnDC *);
	/** test if text is a console command and parse it by console eventually
	return 1 if it was a command else return 0 */
 	int ParseForCommands(const string &, cConnDC *);
protected:
	cServerDC &mS;
	/** Treat the DC message in a appropriate way */
	int DC_ValidateNick(cMessageDC *msg, cConnDC *conn);
	/** Treat the DC message in a appropriate way */
	int DC_Key(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_MyPass(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_GetNickList(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_Version(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_Chat(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_To(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_GetINFO(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_MyINFO(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_ConnectToMe(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_Kick(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_OpForceMove(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_RevConnectToMe(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_MultiConnectToMe(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_Search(cMessageDC * msg, cConnDC * conn);
	/** Treat the DC message in a appropriate way */
	int DC_SR(cMessageDC * msg, cConnDC * conn);

	/****************************/
	/** extended supports features */
	int DCE_Supports(cMessageDC * msg, cConnDC * conn);
	/** Network info (neo Modus) */
	int DCM_NetInfo(cMessageDC * msg, cConnDC * conn);
	/** operator ban */
	int DCO_TempBan(cMessageDC * msg, cConnDC * conn);
	/** operator unban */
	int DCO_UnBan(cMessageDC * msg, cConnDC * conn);
	/** operator getbanlist */
	int DCO_GetBanList(cMessageDC * msg, cConnDC * conn);
	/** Bot information */
	int DCB_BotINFO(cMessageDC * msg, cConnDC * conn);
	/** who is with given ip */
	int DCO_WhoIP(cMessageDC * msg, cConnDC * conn);
	/** operator getbanlist filtered by the parameter */
	int DCO_Banned(cMessageDC * msg, cConnDC * conn);
	/** get hub topic */
	int DCO_GetTopic(cMessageDC * msg, cConnDC * conn);
	/** operator set hub topic */
	int DCO_SetTopic(cMessageDC * msg, cConnDC * conn);public: // Public attributes
	const string &GetMyInfo(cUser * User, int ForClass);
	static void Create_MyINFO(string &dest, const string&nick, const string &desc, const string&speed, const string &mail, const string &share);
	void Append_MyInfoList(string &dest, const string &MyINFO, const string &MyINFO_basic, bool DoBasic);
	static void Create_PM(string &dest,const string &from, const string &to, const string &sign, const string &text);
	static void Create_PMForBroadcast(string &start,string &end, const string &from, const string &sign, const string &text);
	static int ParseSpeed(const std::string &speed);
	static void EscapeChars(const string &, string &);
	static void UnEscapeChars(const string &, string &);
	/** regex for kick chat messages */
	cPCRE mKickChatPattern;
	cPCRE mKickBanPattern;

};
};
};
#endif
