/***************************************************************************
                          cdctag.h  -  description
                             -------------------
    begin                : Sun Aug 24 2003
    copyright            : (C) 2003 by Daniel Muller
    email                : dan at verliba dot cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDCTAG_H
#define CDCTAG_H

#include <sstream>
#include "cpcre.h"
#include "cdcconf.h"


using namespace std;
// forward declarations
namespace nUtils { class cPCRE; };

namespace nDirectConnect
{
   namespace nTables { class cDCConf; };
   using nDirectConnect::nTables::cDCConf;

/** a parser for the dc info tag
  *@author Daniel Muller
  */
class cDCTagParser
{
	public:
	// the constructor
	cDCTagParser();
	/** the global teg's regular expression */
	nUtils::cPCRE mTagRE;
	nUtils::cPCRE mModeRE;
	nUtils::cPCRE mHubsRE;
	nUtils::cPCRE mSlotsRE;
	nUtils::cPCRE mLimitRE;
};

/**dc info tag the <++ V:0.00,S:0,H:1> thing
  *@author Daniel Muller
  */

class cDCTag
{
public:
	cDCTag(const std::string &desc, cDCConf &);
	~cDCTag();
	bool ValidateTag(ostream &os, int, int&);

	// tag parser static - one for all
	static cDCTagParser mParser;
	cDCConf &mC;

	typedef enum{ eCT_NOTAG, eCT_PLUSPLUS, eCT_DCGUI, eCT_ODC, eCT_DC, eCT_DCPRO, eCT_STRONGDC, eCT_IDC, eCT_ZDC, eCT_UNKNOWN } tClientType;
	typedef enum{ eCM_NOTAG, eCM_ACTIVE, eCM_PASSIVE, eCM_SOCK5} tClientMode;

	enum {
		eTC_PARSE, //< tag parse error
		eTC_MAX_HUB, //< too many hubs
		eTC_MAX_SLOTS, //< too many slots
		eTC_MIN_SLOTS, //< too few slots
		eTC_MAX_HS_RATIO, //< hubs per slot
		eTC_MIN_LIMIT, //< small upload limiter
		eTC_MIN_LS_RATIO, //< small limiter per slot
		eTC_MIN_VERSION, //< version too old
		eTC_MAX_VERSION, //< version too recent
	};
	// tag's starting position in desc
	int mPositionInDesc;

	/** the client's type */
	tClientType mClientType;

	/** client's version */
	double mClientVersion;

	/** the client's mode */
	tClientMode mClientMode;

	/** the tag string */
	std::string mTag;
	/** the rest of tag after the Mode until the end*/
	std::string mTagBody;

};

};
#endif
