/***************************************************************************
 *   Copyright (C) 2003 by Dan Muller                                      *
 *   dan at verliba dot cz                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "cinfoserver.h"
#include "cserverdc.h"

namespace nDirectConnect {
namespace nInfo {

cInfoServer::cInfoServer()
{
	mServer = NULL;
}

void cInfoServer::SetServer(cServerDC *Server)
{
	mServer = Server;
	Add("Hub name", mServer->mC.hub_name);
	Add("Online users",mServer->mUserCountTot);
	Add("Total limit",mServer->mC.max_users_total);
	Add("Total share",mServer->mTotalShare);
}

void cInfoServer::Output(ostream &os, int Class)
{
	iterator it;
	cTime theTime;

	for(it = begin(); it != end(); ++it)
		os << (*it)->mName << " : " << *(*it) << "\r\n";
	theTime = mServer->mTime;
	theTime -= mServer->mStartTime;
	os << "Users in list : " << mServer->mUserList.size() << "\r\n";
	os << "Uptime : " << theTime.AsPeriod() << "\r\n";
	os << "Frequency: " << mServer->mFrequency.GetMean(mServer->mTime) << "\r\n";
	os << "Active users: " << mServer->mActiveUsers.size() << "\r\n";
	os << "Hello users: " << mServer->mHelloUsers.size() << "\r\n";
	os << "Operator users: " << mServer->mOpchatList.size() << "\r\n";
	double total = 0, curr;
	int i = 0;
	for( i =0; i <= USER_ZONES; i++)
	{
		curr = mServer->mUploadZone[i].GetMean(mServer->mTime);
		os << "Upload zone " << i << " [B/s] : " << curr << "\r\n";
		total += curr;
	}
	os << "Upload all zones total [B/s]" << total << "\r\n";
 	for( i =0; i < 4; i++) {
		os << "Zone (" << i << ") ";
		if(i > 0) os << mServer->mC.cc_zone[i-1];
		else os << ":all:";
		os << " users :" << mServer->mUserCount[i] << " / " <<mServer->mC.max_users[i] << "\r\n";
	}
	for (i=4; i <= USER_ZONES; i++)
		os << " Zone (" << i << ") IP-Range : " << mServer->mUserCount[i] << " / " <<mServer->mC.max_users[i] << "\r\n";
}

cInfoServer::~cInfoServer(){}
};
};

