/***************************************************************************
                          cmessagedc.cpp  -  description
                             -------------------
    begin                : Fri May 9 2003
    copyright            : (C) 2003 by Daniel Muller
    email                : dan at verliba dot cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cmessagedc.h"
#include <iostream>

using namespace std;
namespace nDirectConnect {
namespace nProtocol {

#define __msBuffSize 10240
const int cMessageDC::msBuffSize=__msBuffSize;
char *cMessageDC::mBuffer = new char[__msBuffSize];
int cMessageDC::msCounterMessageDC  = 0;

// these strings correspond to the enum tDCMsg in th .h file
cProtoCommand /*cMessageDC::*/sDC_Commands[]=
{
	cProtoCommand(string("$GetINFO ")),  // check: logged_in(FI), nick
	cProtoCommand(string("$Search Hub:")), // check: nick, delay //this must be first!! before the nex one
	cProtoCommand(string("$Search ")), // check: ip, delay
	cProtoCommand(string("$SR ")), // check: nick
	cProtoCommand(string("$MyINFO ")), // check: after_nick, nick, share_min_max
	cProtoCommand(string("$Key ")),
	cProtoCommand(string("$ValidateNick ")),
	cProtoCommand(string("$MyPass ")),
	cProtoCommand(string("$Version ")),
	cProtoCommand(string("$GetNickList")), // 
	cProtoCommand(string("$ConnectToMe ")), // check: ip, nick
	cProtoCommand(string("$MultiConnectToMe ")),  // not implemented
	cProtoCommand(string("$RevConnectToMe ")), // check: nick, other_nick
	cProtoCommand(string("$To: ")), // check: nick, other_nick
	cProtoCommand(string("<")), // check: nick, delay, size, line_count
	cProtoCommand(string("$Quit ")), // no chech necessary
	cProtoCommand(string("$OpForceMove $Who:")), // check: op, nick
	cProtoCommand(string("$Kick ")), // check: op, nick, conn
	cProtoCommand(string("$MultiSearch Hub:")), // check: nick, delay
	cProtoCommand(string("$MultiSearch ")),  // check: ip, delay
	cProtoCommand(string("$Supports ")),
	cProtoCommand(string("$NetInfo ")),
	cProtoCommand(string("$Ban ")),
	cProtoCommand(string("$TempBan ")),
	cProtoCommand(string("$UnBan ")),
	cProtoCommand(string("$GetBanList")),
	cProtoCommand(string("$WhoIP ")),
	cProtoCommand(string("$Banned ")),
	cProtoCommand(string("$SetTopic ")),
	cProtoCommand(string("$GetTopic ")),
	cProtoCommand(string("$BotINFO ")),
};

using namespace ::nDirectConnect::nProtocol::nEnums;

cMessageDC::cMessageDC()
	:
	cObj("MessageDC"),
	Overfill(false),
	Received(false),
	mError(false),
	mType(eDC_UNPARSED),
	mChunks(10)
	//,mChStrings(10,(string *)NULL)
{
	mLen=0;
	mChStrMap = 0l;
	//memset(mChStrings, 0, sizeof( mChStrings );
}

cMessageDC::~cMessageDC()
{
	mChunks.clear();
//	tSPLIt i;
//	for(i = mChStrings.begin(); i!= mChStrings.end(); i++)
//		if( *i != NULL ) delete *i;
//	mChStrings.clear();
//	for(i = 0; i!= 20; i++)
//		if( mChStrings[i] != NULL ) delete mChStrings[i];
}

/** reinitialize the structure */
void cMessageDC::ReInit()
{
	mChunks.clear();
	mLen=0;
	mChStrMap = 0l;
	Overfill=false;
	Received=false;
	mError=false;
	mType = eDC_UNPARSED;
	mChunks.resize(10);
	mStr.resize(0);
	mStr.reserve(512);
}

/** parses the string and sets the state variables */
int cMessageDC::Parse()    // this function call too many comparisons, it's to optimize by a tree
{// attention, AreYou returns true if the first part matches, so, somemessages may be confused
	for(int i=0; i < eDC_UNKNOWN; i++)
	{
		if ( sDC_Commands[i].AreYou(mStr) )  
		{
			mType=tDCMsg(i);
			mKWSize=sDC_Commands[i].mBaseLength;
			mLen=mStr.size();
			break;
		}
	}
	if(mType == eDC_UNPARSED) mType=eDC_UNKNOWN;
	return mType;
}

/** return the n'th chunk (as splited by SplitChunks) function */
string &cMessageDC::ChunkString(unsigned int n)
{
	if(!n) return mStr;  // the zero-th string is allways the complete one, and it's pointer is reserved for the empty string
	if(n > mChunks.size()) // this should never happen, but if it happens, we are prepared;
	{
		return mChStrings[0];
	}
	unsigned long flag = 1 << n;
	if(!(mChStrMap & flag))
	{
		mChStrMap |= flag;
		try
		{
			tChunk &chu=mChunks[n];
			//mChStrings[n]= new string(mStr, chu.first, chu.second);
			mChStrings[n] = mStr.substr(chu.first, chu.second);
			mChStrings[n].reserve(0);
		}
		catch(...)
		{
			if(ErrLog(1)) LogStream() << "Ecxeption in chunk string" << endl;
		}
	}
	return mChStrings[n];
}

/** apply the chunkstring ito the main string */
void cMessageDC::ApplyChunk(unsigned int n)
{
	if(!n) return;
	if(n > mChunks.size()) return;

	unsigned long flag = 1 << n;
	if(mChStrMap & flag)
	{
		tChunk &chu=mChunks[n];
		mStr.replace(chu.first, chu.second, mChStrings[n]);
	}
}

/** splits message to it's important parts and stores their info in the chunkset mChunks */
bool cMessageDC::SplitChunks()
{
 	SetChunk(0,0,mStr.length()); // the zeroth chunk is everywhere the same
	int chunkn;
	// Allocate chunks
	switch(mType)
	{
		case eDC_GETNICKLIST:
		case eDCO_GETTOPIC:
				chunkn=1;
			break;
		case eDC_KEY:
		case eDC_VALIDATENICK:
		case eDC_MYPASS:
		case eDC_VERSION:
		case eDC_KICK:
		case eDC_QUIT:
		case eDCE_SUPPORTS:
		case eDCO_UNBAN:
		case eDCO_SETTOPIC:
				chunkn=2;
			break;			
		case eDC_GETINFO:
		case eDC_RCONNECTTOME:
		case eDC_CHAT:
		case eDC_CONNECTTOME:
		case eDC_SEARCH_PAS:
		case eDCO_BAN:
				chunkn=3;
			break;
		case eDC_OPFORCEMOVE:
		case eDCM_NETINFO:
		case eDCO_TBAN:
				chunkn=4;	
			break;		
		case eDC_SEARCH:
		case eDC_MSEARCH:
				chunkn=5;
			break;			
		case eDC_TO:
				chunkn=6;
			break;
		case eDC_MYNIFO:
		case eDC_SR:
				chunkn=9;
			break;
		case eDC_MCONNECTTOME:
			break;
		default:
			break;
	}
	//mChunks.resize(chunkn,mcDefChunk);
	//mChStrings.resize(chunkn,NULL);

	// now try to find chunks one by one
	switch(mType)
	{
		case eDCE_SUPPORTS: break; // this has variable count of params
		case eDC_KEY:
		case eDC_VALIDATENICK:
		case eDC_MYPASS:
		case eDC_VERSION:
		case eDC_KICK:
		case eDC_QUIT:
		case eDCO_UNBAN:
		case eDCO_WHOIP:
		case eDCO_BANNED:
		case eDCO_SETTOPIC:
		case eDCB_BOTINFO:
			SetChunk(eCH_1_PARAM,mKWSize,mLen-mKWSize);
			break;
		case eDC_GETINFO:
			if(!SplitOnTwo(mKWSize,' ', eCH_GI_OTHER , eCH_GI_NICK)) mError =1;
			break;
		case eDC_RCONNECTTOME:
			if(!SplitOnTwo(mKWSize,' ', eCH_RC_NICK, eCH_RC_OTHER)) mError =1;
			break;
		case eDC_CHAT:
			if(!SplitOnTwo(mKWSize,'>', eCH_CH_NICK, eCH_CH_MSG)) mError =1;
			ChunkRedLeft( eCH_CH_MSG, 1);  // this is because of empty space after '>'
			break;
		case eDC_SEARCH_PAS:
			if(!SplitOnTwo(mKWSize,' ', eCH_PS_NICK, eCH_PS_QUERY)) mError =1;
			break;
		case eDC_CONNECTTOME:
			if(!SplitOnTwo(mKWSize,' ', eCH_CM_NICK, eCH_CM_ACTIVE)) mError =1;
			if(!SplitOnTwo(':', eCH_CM_ACTIVE, eCH_CM_IP, eCH_CM_PORT)) mError =1;
			break;
		case eDC_TO:
			// $To: <othernick> From: <nick> $<<nick>> <message>
			// eCH_PM_TO, eCH_PM_FROM, eCH_PM_CHMSG, eCH_PM_NICK, eCH_PM_MSG } ;
			if(!SplitOnTwo( mKWSize,' ', eCH_PM_TO, eCH_PM_FROM)) mError =1;
			ChunkRedLeft( eCH_PM_FROM, 6);  // skip the "From: " part
			if(!SplitOnTwo( ' ', eCH_PM_FROM, eCH_PM_FROM, eCH_PM_CHMSG)) mError =1;
			ChunkRedLeft( eCH_PM_CHMSG, 2);  // skip the "$<" part
			if(!SplitOnTwo( '>', eCH_PM_CHMSG, eCH_PM_NICK, eCH_PM_MSG)) mError =1;
			ChunkRedLeft( eCH_PM_MSG, 1);  // skip the " " part (after nick)
			break;
		case eDC_MYNIFO:
			// $MyINFO $ALL <nick> <interest>$ $<speed>$<e-mail>$<sharesize>$
			// eCH_MI_ALL, eCH_MI_DEST, eCH_MI_NICK, eCH_MI_INFO, eCH_MI_DESC, eCH_MI_SPEED, eCH_MI_MAIL, eCH_MI_SIZE
			if(!SplitOnTwo( mKWSize,' ', eCH_MI_DEST, eCH_MI_NICK)) mError =1;
			if(!SplitOnTwo( ' ', eCH_MI_NICK,eCH_MI_NICK, eCH_MI_INFO)) mError =1;
			if(!SplitOnTwo( '$', eCH_MI_INFO, eCH_MI_DESC, eCH_MI_SPEED)) mError =1;
			ChunkRedLeft( eCH_MI_SPEED, 2);
			if(!SplitOnTwo( '$', eCH_MI_SPEED, eCH_MI_SPEED, eCH_MI_MAIL)) mError =1;
			if(!SplitOnTwo( '$', eCH_MI_MAIL, eCH_MI_MAIL, eCH_MI_SIZE)) mError =1;
			ChunkRedRight(eCH_MI_SIZE,1);
			break;
		case eDC_MCONNECTTOME: // not implemented
			break;
		case eDC_OPFORCEMOVE:
			 //$OpForceMove $Who:<victimNick>$Where:<newIp>$Msg:<reasonMsg>
			 //NICK DEST REASON
			if(!SplitOnTwo( mKWSize,'$', eCH_FM_NICK, eCH_FM_DEST)) mError =1;
			ChunkRedLeft( eCH_FM_DEST, 6);  // skip the "Where:" part
			if(!SplitOnTwo( '$', eCH_FM_DEST, eCH_FM_DEST,eCH_FM_REASON)) mError =1;
			ChunkRedLeft( eCH_FM_REASON, 4);  // skip the "Msg:" part
			break;
		case eDC_MSEARCH: // not implemented, but should be same as search
		case eDC_SEARCH: // active
			// $Search <ip>:<port> <searchstring>
			//enum {eCH_AS_ALL, eCH_AS_ADDR, eCH_AS_IP, eCH_AS_PORT, eCH_AS_QUERY}
			if(!SplitOnTwo( mKWSize,' ', eCH_AS_ADDR, eCH_AS_QUERY)) mError =1;
			if(!SplitOnTwo( ':', eCH_AS_ADDR, eCH_AS_IP, eCH_AS_PORT)) mError =1;
			break;
		case eDC_SR:
			// search result $SR <resultNick> <filepath>^E<filesize> <freeslots>/<totalslots>^E<hubname> (<hubhost>[:<hubport>])^E<searchingNick>
			// enum {eCH_SR_FROM, eCH_SR_PATH, eCH_SR_SIZE, eCH_SR_SLOTS, eCH_SR_SL_FR, eCH_SR_SL_TO, eCH_SR_HUBINFO, eCH_SR_TO}
			if(!SplitOnTwo( mKWSize,' ', eCH_SR_FROM, eCH_SR_PATH)) mError =1;
			if(!SplitOnTwo( 0x05, eCH_SR_PATH, eCH_SR_PATH,  eCH_SR_SIZE)) mError =1;
			if(!SplitOnTwo( 0x05, eCH_SR_SIZE, eCH_SR_HUBINFO, eCH_SR_TO,false)) mError =1;
			if(SplitOnTwo( 0x05,eCH_SR_HUBINFO, eCH_SR_SIZE, eCH_SR_HUBINFO))
			{
				if(!SplitOnTwo( ' ', eCH_SR_SIZE, eCH_SR_SIZE, eCH_SR_SLOTS)) mError =1;
				if(!SplitOnTwo( '/', eCH_SR_SLOTS, eCH_SR_SL_FR, eCH_SR_SL_TO )) mError =1;
			}else
				SetChunk(eCH_SR_SIZE,0,0);
			break;
		case eDCM_NETINFO:
			if(!SplitOnTwo( mKWSize,'$', eCH_NI_HUBS, eCH_NI_SLOTS)) mError =1;
			if(!SplitOnTwo( '$', eCH_NI_SLOTS, eCH_NI_SLOTS,  eCH_NI_ACTIVE)) mError =1;
			break;
		case eDCO_BAN:
			if(!SplitOnTwo( mKWSize,'$', eCH_NB_NICK, eCH_NB_REASON)) mError =1;
			break;
		case eDCO_TBAN:
			if(!SplitOnTwo( mKWSize,'$', eCH_NB_NICK, eCH_NB_TIME)) mError =1;
			if(!SplitOnTwo( '$', eCH_NB_TIME, eCH_NB_TIME,  eCH_NB_REASON)) mError =1;
			break;
		default:
			break;
	}
	return mError;
}

/** splits message into two chunks by a delimiter adn stores them in the chunklist */
bool cMessageDC::SplitOnTwo(size_t start, const char lim, int cn1, int cn2, size_t len, bool left)
{
	if(!len) len = mLen;
	unsigned long i;
	if(left)
	{
		i = mStr.find_first_of(lim,start);
		if(i == mStr.npos || i-start >= len) return false;
	}
	else
	{
		i = mStr.find_last_of(lim,start+len-1);
		if(i == mStr.npos || i < start) return false;
	}
	SetChunk(cn1,start,i-start);
	SetChunk(cn2, i+1, mLen - i - 1);
	return true;
}

/** splits the chunk number "ch" into two chunks by a delimiter adn stores them in the chunklist under numbers cn1 and cn2 */
bool cMessageDC::SplitOnTwo(const char lim, int ch, int cn1, int cn2, bool left)
{
	tChunk &chu = mChunks[ch];
	return SplitOnTwo(chu.first, lim, cn1, cn2,chu.second, left );	
}

/** reduce the chunk from left by amount, cn is the chunk number */
void cMessageDC::ChunkRedLeft(int cn, int amount)
{
	tChunk &ch = mChunks[cn];
	ch.first += amount;
	ch.second -= amount;
}

/** reduce the chunk from right by amount, cn is the chunk number */
void cMessageDC::ChunkRedRight(int cn, int amount)
{
	mChunks[cn].second -= amount;
}

/** get string */
string & cMessageDC::GetStr()
{
	return mStr;
}

/** fill in a given chunk */
void cMessageDC::SetChunk(int n,int start,int len)
{
	tChunk &ch = mChunks[n];
	ch.first=start;
	ch.second=len;
}

};
};

