/***************************************************************************
 *   Copyright (C) 2003 by Dan Muller                                      *
 *   dan at verliba dot cz                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "cpcre.h"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

namespace nUtils {

cPCRE::cPCRE() { Clear();}
cPCRE::~cPCRE(){ }
};


/*!
    \fn nUtils::cPCRE::cPCRE(const char *)
 */
nUtils::cPCRE::cPCRE(const char *pat, unsigned int options)
{
	Clear();
	Compile(pat, options);
}


/*!
    \fn nUtils::cPCRE::cPCRE(const std::string&)
 */
nUtils::cPCRE::cPCRE(const std::string &str, unsigned int options)
{
	Clear();
	Compile(str.data(), options);
}


/*!
    \fn nUtils::cPCRE::Compile(const char *)
 */
bool nUtils::cPCRE::Compile(const char *pat, unsigned int options)
{
	char *errptr;
	int erroffset;
	mPattern = pcre_compile(pat,options,(const char **)&errptr,&erroffset,NULL);
	if(!mPattern) return false;
	//mPatternE = pcre_study(mPattern, 0, (const char **)&errptr);
	//if(!mPatternE) return false;
	return true;
}


/*!
    \fn nUtils::cPCRE::Clear()
 */
void nUtils::cPCRE::Clear()
{
	mPattern = NULL;
	mPatternE = NULL;
	mResult=0;
	memset(mCoords,0, sizeof(mCoords));
}


/*!
    \fn nUtils::cPCRE::Exec()
 */
int nUtils::cPCRE::Exec(const std::string &text)
{
	memset(mCoords,0, sizeof(mCoords));
	mResult = pcre_exec(mPattern, mPatternE, text.data(), text.size(), 0, 0, mCoords, 60);
	return mResult;
}


/*!
    \fn nUtils::cPCRE::Compare(int rank, const std::string &text)
    string compare the rank'th pat of text to text2 , return 0 on same strings
 */
int nUtils::cPCRE::Compare(int rank, const std::string &text, const char *text2)
{
	if(!this->PartFound(rank)) return -1;
	int start = mCoords[rank<<1];
	#if !defined OLD_STD_STRING
	return text.compare(start,mCoords[(rank<<1)+1]-start,text2);
	#else
	return text.compare(text2, start,mCoords[(rank<<1)+1]-start);
	#endif
}

int nUtils::cPCRE::Compare(int rank, const std::string &text, const std::string &text2)
{
	return Compare(rank, text, text2.data());
}


/*!
    \fn nUtils::cPCRE::Extract( int rank, std::string &)
 */
void nUtils::cPCRE::Extract(int rank, const std::string &src, std::string &dst)
{
	if(!this->PartFound(rank)) return;
	int start = mCoords[rank<<1];
	dst.assign(src, start, mCoords[(rank<<1)+1]-start);
}


/*!
    \fn nUtils::cPCRE::PartFound(int index)
 */
bool nUtils::cPCRE::PartFound(int rank)
{
	if((rank < 0)|| (rank >= mResult)) return false;

	return mCoords[rank<<1] >= 0;
}


/*!
    \fn nUtils::cPCRE::Replace(int rank, std::string &InString, const std::string &ByThis)
 */
void nUtils::cPCRE::Replace(int rank, std::string &InString, const std::string &ByThis)
{
	if(!this->PartFound(rank)) return;
	int start = mCoords[rank<<1];
	InString.replace(start, mCoords[(rank<<1)+1]-start, ByThis);
}
