/***************************************************************************
 *   Copyright (C) 2003 by Dan Muller                                      *
 *   dan@verliba.cz                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "cpenaltylist.h"

namespace nDirectConnect {

namespace nTables {

cPenaltyList::cPenaltyList(cMySQL &mysql) : cConfMySQL(mysql), mCache(mysql, "temp_rights", "nick")
{
	mMySQLTable.mName = "temp_rights";
	AddCol("nick", "varchar(15)", "", true, mModel.mNick);
	AddPrimaryKey("nick");
	AddCol("since", "int(11)", "", true, mModel.mSince);
	AddCol("st_chat", "int(11)", "", true, mModel.mStartChat);
	AddCol("st_search", "int(11)", "", true, mModel.mStartSearch);
	AddCol("st_ctm", "int(11)", "", true, mModel.mStartCTM);
	AddCol("st_pm", "int(11)", "", true, mModel.mStartPM);
	AddCol("st_kick", "int(11)", "", true,mModel.mStopKick);
	AddCol("st_share0", "int(11)", "", true, mModel.mStopShare0);
	AddCol("st_reg", "int(11)", "", true, mModel.mStopReg);
	mMySQLTable.mExtra = "PRIMARY KEY(nick), ";
	mMySQLTable.mExtra = "INDEX creation_index(since)";
	SetBaseTo(&mModel);
}


cPenaltyList::~cPenaltyList()
{
}

ostream &operator << (ostream &os, const cPenaltyList::sPenalty &penalty)
{
	time_t Now = cTime().Sec();
	os << penalty.mNick << " ";
	if(penalty.mStartChat > Now) os << "chat: " << penalty.mStartChat - Now << " ";
	if(penalty.mStartSearch > Now) os << "search: " << penalty.mStartSearch - Now << " ";
	if(penalty.mStartCTM > Now) os << "download: " << penalty.mStartCTM - Now << " ";
	if(penalty.mStartPM > Now) os << "PM: " << penalty.mStartPM - Now << " ";
	if(penalty.mStopKick > Now) os << "Kick: " << penalty.mStopKick - Now << " ";
	if(penalty.mStopShare0 > Now) os << "NoShare: " << penalty.mStopShare0 - Now << " ";
	if(penalty.mStopReg > Now) os << "Reg: " << penalty.mStopReg - Now << " ";
	return os;
}

void cPenaltyList::Cleanup()
{
	time_t Now = cTime().Sec();
	cQuery query(mMySQL);
	query.OStream() << "DELETE FROM " << mMySQLTable.mName << " WHERE since <" << Now - 3600*24*7 <<
		" AND st_kick != 0 AND st_share0 != 0";
	query.Query();
	query.Clear();
}

bool cPenaltyList::LoadTo(sPenalty &pen, const string &Nick)
{
	if(mCache.IsLoaded() && !mCache.Find(Nick)) return false;
	SetBaseTo(&pen);
	pen.mNick = Nick;
	return LoadPK();
}

bool cPenaltyList::AddPenalty(sPenalty &penal)
{
	SetBaseTo(&mModel);
	mModel.mNick = penal.mNick;
	bool keep = false;
	if (LoadPK())
	{
		if(penal.mStartChat > mModel.mStartChat) mModel.mStartChat = penal.mStartChat;
		if(penal.mStartCTM > mModel.mStartCTM) mModel.mStartCTM = penal.mStartCTM;
		if(penal.mStartPM > mModel.mStartPM) mModel.mStartPM = penal.mStartPM;
		if(penal.mStartSearch > mModel.mStartSearch) mModel.mStartSearch = penal.mStartSearch;
		if(penal.mStopKick > mModel.mStopKick) mModel.mStopKick = penal.mStopKick;
		if(penal.mStopShare0 > mModel.mStopShare0) mModel.mStopShare0 = penal.mStopShare0;
		if(penal.mStopReg > mModel.mStopReg) mModel.mStopReg = penal.mStopReg;
		keep = mModel.ToKeepIt();
	}
	else
	{
		SetBaseTo(&penal);
		keep = penal.ToKeepIt();
		if (keep)
		{
			mCache.Add(penal.mNick);
		}
	}

	if( keep )
		return SavePK(false);
	else
		return false;
}

bool cPenaltyList::RemPenalty(sPenalty &penal)
{
	SetBaseTo(&mModel);
	mModel.mNick = penal.mNick;
	time_t Now = cTime().Sec();
	if (LoadPK())
	{
		if(penal.mStartChat < Now) mModel.mStartChat = Now;
		if(penal.mStartCTM < Now) mModel.mStartCTM = Now;
		if(penal.mStartPM < Now) mModel.mStartPM = Now;
		if(penal.mStartSearch < Now) mModel.mStartSearch = Now;
		if(penal.mStopKick < Now) mModel.mStopKick = Now;
		if(penal.mStopShare0 < Now) mModel.mStopShare0 = Now;
		if(penal.mStopReg < Now) mModel.mStopReg = Now;
	}
	if( mModel.ToKeepIt() )
		return SavePK();
	else DeletePK();
	return true;
}

};

};
