/***************************************************************************
 *   Copyright (C) 2003 by Dan Muller                                      *
 *   dan@verliba.cz                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef NDIRECTCONNECT_NTABLESCPENALTYLIST_H
#define NDIRECTCONNECT_NTABLESCPENALTYLIST_H

#include <string>
#include "cconfmysql.h"
#include "ctime.h"
#include "tcache.h"

using std::string;
using nUtils::cTime;
using nConfig::cConfMySQL;
using namespace nUtils;

namespace nDirectConnect {

namespace nTables {

/**
has the list of temporary user penalties... that save in database

@author Daniel Muller
*/

class cPenaltyList : public cConfMySQL
{
public:
	/**structure representing the MySQL table data */
	struct sPenalty
	{
		string mNick;
		long mSince;
		long mStartChat;
		long mStartSearch;
		long mStartCTM;
		long mStartPM;
		long mStopKick;
		long mStopShare0;
		long mStopReg;

		sPenalty()
		{
			long Now = cTime().Sec();
			mSince = Now;
			mStartChat = 1;
			mStartSearch = 1;
			mStartCTM = 1;
			mStartPM = 1;
		}

		bool ToKeepIt()
		{
			long Now = cTime().Sec();
			if (mStartChat >  Now) return true;
			if (mStartSearch > Now) return true;
			if (mStartCTM > Now) return true;
			if (mStartPM > Now) return true;
			if (mStopKick > Now) return true;
			if (mStopShare0 > Now) return true;
			if (mStopReg > Now) return true;
			return false;
		}
		friend ostream &operator << (ostream &, const sPenalty &);
	};


	cPenaltyList(cMySQL &mysql);
	~cPenaltyList();
	void Cleanup(void);
	bool LoadTo(sPenalty &, const string &Nick);
	bool AddPenalty(sPenalty &);
	bool RemPenalty(sPenalty &);
	void ReloadCache(){mCache.Clear(); mCache.LoadAll();}
	tCache<string> mCache;
protected:
	sPenalty mModel;
};

};

};

#endif
