/***************************************************************************
                          creglist.cpp  -  description
                             -------------------
    begin                : Mon Jul 7 2003
    copyright            : (C) 2003 by Daniel Muller
    email                : dan at verliba dot cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cserverdc.h"
#include "creglist.h"
#include "cuser.h"
#include "creguserinfo.h"
#include <sstream>
#include <cctype>
#include <algorithm>
#include <unistd.h>

namespace nDirectConnect
{
namespace nTables
{


cRegList::cRegList(cMySQL &mysql): cConfMySQL(mysql)
	,mCache(mysql,"reglist", "nick", "reg_date")
{
	//cTime now;
	SetClassName("nDC::cRegList");
	mMySQLTable.mName="reglist";
	AddCol("nick", "varchar(30)", "", false, mModel.mNick);
	AddPrimaryKey("nick");
	AddCol("class", "int(2)", "1", true, mModel.mClass);
	AddCol("class_protect", "int(2)", "0", true, mModel.mClassProtect);
	AddCol("class_hidekick", "int(2)", "0", true, mModel.mClassHideKick);
	AddCol("hide_kick", "tinyint(1)", "0", true, mModel.mHideKick);
	AddCol("hide_keys", "tinyint(1)", "0", true, mModel.mHideKeys);
	AddCol("reg_date", "int(11)", "", true, mModel.mRegDate);
	AddCol("reg_op", "varchar(30)", "", true, mModel.mRegOp);
	AddCol("pwd_change", "tinyint(1)", "1", true, mModel.mPwdChange);
	AddCol("pwd_crypt", "tinyint(1)", "1", true, mModel.mPWCrypt);
	AddCol("login_pwd", "varchar(60)", "", true, mModel.mPasswd);
	AddCol("login_last", "int(11)", "0", true, mModel.mLoginLast);
	AddCol("logout_last", "int(11)", "0", true, mModel.mLogoutLast);
	AddCol("login_cnt", "int(11)", "0", true, mModel.mLoginCount);
	AddCol("login_ip", "varchar(16)", "", true, mModel.mLoginIP);
	AddCol("error_last", "int(11)", "", true, mModel.mErrorLast);
	AddCol("error_cnt", "int(11)", "0", true, mModel.mErrorCount);
	AddCol("error_ip", "varchar(16)", "", true, mModel.mErrorIP);
	AddCol("enabled", "tinyint(1)", "1", true, mModel.mEnabled);
	AddCol("email", "varchar(60)", "", true, mModel.mEmail);
	AddCol("note_op", "text", "", true, mModel.mNoteOp);
	AddCol("note_usr", "text", "", true, mModel.mNoteUsr);
	mMySQLTable.mExtra = "PRIMARY KEY(nick), ";
	mMySQLTable.mExtra+= "INDEX login_index (login_last), ";
	mMySQLTable.mExtra+= "INDEX logout_index (logout_last)";
	SetBaseTo(&mModel);
}

cRegList::~cRegList(){
}

/** find nick in reglist
if not foud return 0
else return 1 and fill in the reuserinfo parameter */
bool cRegList::FindRegInfo(cRegUserInfo &ui, const string &nick)
{
	if(mCache.IsLoaded() && !mCache.Find(nick)) return false;//@todo nick2dbkey
	SetBaseTo(&ui);
	ui.mNick = nick;//@todo nick2dbkey
	return LoadPK();
}

/** add registered user */
bool cRegList::AddRegUser(const string &nick, cConnDC *op, int cl, const char *password)
{
	cRegUserInfo ui;

	if(FindRegInfo(ui, nick)) return false;
	ui.mNick = nick;//@todo nick2dbkey
	if ((cl>=1 && cl<=5) || cl==10) ui.mClass = cl;
	else ui.mClass = 1;
	ui.mRegDate = cTime().Sec();
	ui.mRegOp   = (op && op->mpUser)?op->mpUser->mNick:string("hub-security");

	if(password) ui.SetPass(string(password));
	else ui.SetPass(string());

	if(mCache.IsLoaded()) mCache.Add(nick);//@todo nick2dbkey

	SetBaseTo(&ui);
	return SavePK();
}


/** No descriptions */
bool cRegList::ChangePwd(const string &nick, const string &pwd, int crypt)
{
	if(!FindRegInfo(mModel, nick)) return false;
	mModel.SetPass(pwd);
	return UpdatePK();
}

/** No descriptions */
bool cRegList::SetVar(const string &nick, string &field, string &value)
{
	SetBaseTo(&mModel);
	mModel.mNick = nick; //@todo nick2dbkey
	return UpdatePKVar(field.data(), value);
}

/** log that user logged in */
bool cRegList::Login(cConnDC *conn, const string &nick)
{
	cRegUserInfo ui;
	if(!FindRegInfo(ui, nick)) return false;
	ui.mLoginLast = cTime().Sec();
	ui.mLoginIP   = conn->AddrIP();
	ui.mLoginCount ++;
	return UpdatePK();
}

/** log that user logged in */
bool cRegList::Logout(const string &nick)
{
	if(!FindRegInfo(mModel, nick)) return false;
	mModel.mLogoutLast = cTime().Sec()-1; // this is a patch for users that connect twice
	return UpdatePKVar("logout_last");
}

/** log that user logged in with error*/
bool cRegList::LoginError(cConnDC *conn, const string &nick)
{
	if(!FindRegInfo(mModel, nick)) return false;
	mModel.mErrorLast = cTime().Sec();
	mModel.mErrorIP = conn->AddrIP();
	return UpdatePK();
}


/*!
    \fn nDirectConnect::nTables::cRegList::DelReg(const string &nick)
 */
bool cRegList::DelReg(const string &nick)
{
	if(!FindRegInfo(mModel, nick)) return false;
	DeletePK();
	return true;
}

/**

How registering works:
----------------------

1/ user <Nick> asks to be registered
2/ if operator is ok with it, he uses command !regnewuser <Nick> [<class>=1] to prepare an account for the user..
	* this checks if such user is registered (if so error occurs)
	* creates default reguser data into the reglist, which is marked as pwd_change
	* then it sends pm to the user asking him por passwrd and some other settings
3/ user provides password with +passwd <new_pass> [<crypt>=0], which is enabled only if pwd_change is marked
	* if user doesn't provide any password he won't be registered
	* if password is provided and is ok, user finishes his registration
4/ to change password user asks any op again, op uses command !regpasswd <Nick> to enable password changing
5/ to change user's class op uses commands !regclass <Nick> <new_class> ; new_class must be less then op's class
6/ to ungegiser use op command !regdeluser <Nick> - this disables the registration by setting a flag
7/ to purge a disabled record, admin can do !regpurge <Nick>

Note: registered users aren't banned by ip only, but by their nick too

1. method
---------
crypted=crypt("heslo"); // mysql: encrypt; php, perl, C : crypt
if(crypt("heslo2",crypted) == crypted) OK

md5
crypt
*/

};
};


