/***************************************************************************
                          creguserinfo.cpp  -  description
                             -------------------
    begin                : Mon Jun 16 2003
    copyright            : (C) 2003 by Daniel Muller
    email                : dan at verliba dot cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define _XOPEN_SOURCE
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <unistd.h>
#if HAVE_LIBSSL && HAVE_OPENSSL_MD5_H
#include <openssl/md5.h>
#endif
#include "creguserinfo.h"
#include "ctime.h"

using namespace ::nUtils;

namespace nDirectConnect {
namespace nTables {

cRegUserInfo::cRegUserInfo():
	mPWCrypt(eCRYPT_NONE),
	mClass(0),
	mClassProtect(0),
	mClassHideKick(0),
	mHideKick(false),
	mHideKeys(false),
	mRegDate(0),
	mLoginCount(0),
	mErrorCount(0),
	mLoginLast(0),
	mLogoutLast(0),
	mErrorLast(0),
	mEnabled(1)
{}

cRegUserInfo::~cRegUserInfo(){}

bool cRegUserInfo::PWVerify(string pass)
{
	string crypted_p;
#if HAVE_LIBSSL && HAVE_OPENSSL_MD5_H
	unsigned char buf[MD5_DIGEST_LENGTH+1];
#endif
	bool Result = false;
	switch (mPWCrypt)
	{
#if HAVE_LIBCRYPT
		case eCRYPT_ENCRYPT:
			crypted_p=crypt(pass.data(),mPasswd.data());
			Result = crypted_p == mPasswd;
			break;
#endif
#if HAVE_LIBSSL && HAVE_OPENSSL_MD5_H
		case eCRYPT_MD5:
			MD5((const unsigned char*)pass.data(), pass.length(), buf);
			buf[MD5_DIGEST_LENGTH] = 0;
			Result = mPasswd == string((const char*)buf);
			break;
#endif
		case eCRYPT_NONE:
			Result = pass == mPasswd;
			break;
	}
	return Result;
}

istream & operator >> (istream &is, cRegUserInfo &ui)
{
	int i;
	is >> ui.GetNick() >> i >> ui.mPasswd >> ui.mClass;
#if !HAVE_LIBCRYPT && !HAVE_LIBSSL
	ui.mPWCrypt = i;
#else
    ui.mPWCrypt = cRegUserInfo::eCRYPT_NONE;
#endif
	return is;
}

ostream & operator << (ostream &os, cRegUserInfo &ui)
{
	static const char *CryptNames[] = {"plain", "encrypted", "md5", "err", "err", "err"};
	os << "Nick: " << ui.mNick << "\tCrypt:" << CryptNames[ui.mPWCrypt] << "\tPwd set?:" << ((ui.mPasswd.size() != 0)?"yes":"no") << "\tClass:" << ui.mClass << "\r\n";
	os << "LastLogin: " << cTime(ui.mLoginLast,0).AsDate() << "\tLastIP:" << ui.mLoginIP << "\r\n";
	os << "LastError:" << cTime(ui.mErrorLast).AsDate() << "\tErrIP:" << ui.mErrorIP << "\r\n";
	os << "LoginCount: " << ui.mLoginCount << "\tErrorCOunt: " << ui.mErrorCount;
	os << "Protect: " << ui.mClassProtect << "\tHideKick: " << ui.mClassHideKick << "\tall: " << ui.mHideKick << "\r\n";
	os << "HideKeys: " << ui.mHideKeys << "\r\n";
	os << "Registered since: " << cTime(ui.mRegDate,0).AsDate() << "\tby: " << ui.mRegOp << "\r\n";
	return os;
}

/** nickname */
string & cRegUserInfo::GetNick(){
	return mNick;
}

};
};

/*!
    \fn nDirectConnect::nTables::cRegUserInfo::SetPass(const string &)
 */
void nDirectConnect::nTables::cRegUserInfo::SetPass(string str)
{
	string salt;
	mPwdChange = !str.size();
#if HAVE_LIBSSL && HAVE_OPENSSL_MD5_H
	unsigned char buf[MD5_DIGEST_LENGTH+1];
#endif
	if(str.size())
	{
#if HAVE_LIBCRYPT
		static const char *saltchars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmlopqrstuvwxyz0123456789./";
		static const int saltcharsnum = strlen(saltchars);

		unsigned char charsalt[2] = {((char*)&str)[0],((char*)&str)[1]};
		charsalt[0] = saltchars[charsalt[0] % saltcharsnum];
		charsalt[1] = saltchars[charsalt[1] % saltcharsnum];
		salt.assign((char *)charsalt,2);

		mPasswd = crypt(str.data(),salt.data());
		mPWCrypt = eCRYPT_ENCRYPT;
#else
#	if HAVE_LIBSSL && HAVE_OPENSSL_MD5_H
		MD5(str.data(), str.size(), buf);
		buf[MD5_DIGEST_LENGTH]=0;
		mPasswd = string((char*)buf);
		mPWCrypt = eCRYPT_MD5;
#	else
        mPasswd = str;
        mPWCrypt = eCRYPT_NONE;
#	endif
#endif
	}
	else mPasswd = str;
}
