/***************************************************************************
 *   Copyright (C) 2003 by Dan Muller                                      *
 *   dan at verliba dot cz                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "cserverdc.h"
#include "ctrigger.h"
#include "cconndc.h"

namespace nDirectConnect {

/// Constructor
cTrigger::cTrigger(){}
/// Destructor
cTrigger::~cTrigger(){}

/** \fn cTrigger::DoIt(istringstream &cmd_line, cConnDC *conn, cServerDC &server)
	\brief Send the defined file contents to the user connection
	\param conn the connecten that trigger the trigger
	\param server reference for the DC server
	\param cmd_line what user has writter
*/
int cTrigger::DoIt(istringstream &cmd_line, cConnDC *conn, cServerDC &server)
{
   if (conn && conn->mpUser && conn->mpUser->mClass >= this->mMinClass) {
      return server.SendFileHS(conn, mDefinition,(mFlags & eTF_SENDPM) != 0, mSendAs.data() );
   }
}

};
