/***************************************************************************
 *   Copyright (C) 2003 by Dan Muller                                      *
 *   dan at verliba dot cz                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef NDIRECTCONNECTCTRIGGER_H
#define NDIRECTCONNECTCTRIGGER_H

#include <sstream>
#include <string>

using namespace std;

namespace nDirectConnect {

class cConnDC;
class cServerDC;

namespace nTables {

/**
a trigger command ...
user defined string that triggers given action

@author Daniel Muller
*/

class cTrigger
{
public:
	cTrigger();
	~cTrigger();
	int DoIt(istringstream & cmd_line, cConnDC *conn, cServerDC &server);
	virtual void OnLoad(){};
	// the trigger
	string mCommand;
	// the nick for the response
	string mSendAs;
	enum
	{
		eTF_EXECUTE = 1 << 0,
      eTF_SENDPM = 1 << 1
	};
	// settings flags
	int mFlags;
	// the definition string (filename, program, etc..)
	string mDefinition;
	// description
	string mDescription;
	// minimum class that can trigger this
	int mMinClass;
	// max lines (0 = ilimited)
	int mMaxLines;
	// maximum length (0 ilimited)
	int mMaxSize;
	// min delay betwen triggering this for user [s]
	int mDelayUser;
	// min overall delay in seconds too
	int mDelayTotal;
};
};
};

#endif
