/***************************************************************************
 *   Copyright (C) 2003 by Dan Muller                                      *
 *   dan at verliba dot cz                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "cuser.h"
#include "cusercollection.h"

using namespace ::nUtils;

namespace nDirectConnect {

void cUserCollection::ufDoNickList::AppendList(string &List, cUser *User)
{
	List.append(User->mNick);
	List.append(mSep);
}

void cUserCollection::ufDoINFOList::AppendList(string &List, cUser *User)
{
	if(mComplete)
		List.append(User->mMyINFO);
	else
		List.append(User->mMyINFO_basic);
	List.append(mSep);
}

void cUserCollection::ufDoIpList::AppendList(string &List, cUser *User)
{
	if (User->mxConn)
	{
		List.append(User->mNick);
		List.append(" ");
		List.append(User->mxConn->AddrIP());
		List.append(mSep);
	}
}

cUserCollection::cUserCollection(bool KeepNickList, bool KeepInfoList) :
	tHashArray< cUser* > (512),
	mNickListMaker(mNickList),
	mINFOListMaker(mINFOList),
	mIpListMaker(mIpList),
	mKeepNickList(KeepNickList),
	mKeepInfoList(KeepInfoList),
	mRemakeNextNickList(true),
	mRemakeNextInfoList(true)
{
	SetClassName("cUsrColl");
}


cUserCollection::~cUserCollection()
{
}

void cUserCollection::Nick2Key(const std::string &Nick, std::string &Key)
{
	Key.assign(Nick);
	std::transform(Key.begin(), Key.end(), Key.begin(), ::tolower);
}

void cUserCollection::Nick2Hash(const std::string &Nick, size_t &Hash)
{
	string Key;
	Nick2Key(Nick,Key);
	Hash = Key2Hash(Key);
}

bool   cUserCollection::Add        (cUser *User                    )
{ if(User) return AddWithHash(User, Nick2Hash(User->mNick)); else return false; }


bool   cUserCollection::Remove      (cUser *User       )
{ if(User) return RemoveByHash(Nick2Hash(User->mNick)); else return false; }

////////////////////////////////// the rest
string &cUserCollection::GetNickList()
{
	if(mRemakeNextNickList && mKeepNickList )
	{
		mNickListMaker.Clear();
		for_each(begin(),end(),mNickListMaker);
		mRemakeNextNickList = false;
	}
	return mNickList;
}

string &cUserCollection::GetInfoList(bool complete)
{
	if(mRemakeNextInfoList && mKeepInfoList )
	{
		mINFOListMaker.Clear();
		mINFOListMaker.mComplete = complete;
		for_each(begin(),end(),mINFOListMaker);
		mRemakeNextInfoList = false;
	}
	return mINFOList;
}

string &cUserCollection::GetIPList()
{
	mIpListMaker.Clear();
	for_each(begin(),end(),mIpListMaker);
	return mIpList;
}

void cUserCollection::SendToAll(string &Data, bool UseCache, bool AddPipe)
{
	if(AddPipe) Data.append("|");
	if (UseCache)
		mSendAllCache.append(Data.data(),Data.size());
	else{
		//if(Log(4))CoutAllKeys();
		if(Log(4))LogStream() << "SendAll BEGIN" << endl;
		for_each(this->begin(),this->end(),ufSend<string>(Data));
		if(Log(4))LogStream() << "SendAll END" << endl;
	}
	if(AddPipe) Data.erase(Data.size()-1,1);
}

void cUserCollection::SendToAllWithNick(string &Start, string &End)
{
	for_each(this->begin(),this->end(),ufSendWithNick<std::string>(Start,End));
}

void cUserCollection::FlushCache()
{
	if(mSendAllCache.size())
	{
		SendToAll(mSendAllCache, false,false);
		mSendAllCache.erase(0,mSendAllCache.size());
	}
}

int cUserCollection::StrLog(ostream & ostr, int level)
{
	if(cObj::StrLog(ostr,level))
	{
		LogStream()   << "(" << mNickListMaker.mStart ;
		LogStream()   << ") "<< "[ " << size() /* << "/" << mUserList.size()*/ << " ] ";
		return 1;
	}
	return 0;
}

};
