/***************************************************************************
 *   Copyright (C) 2004 by Daniel Muller                                   *
 *   dan at verliba dot cz                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef NPLUGINTLISTPLUGIN_H
#define NPLUGINTLISTPLUGIN_H

#include "cvhplugin.h"
#include "tmysqlmemorylist.h"

using namespace nUtils;

namespace nDirectConnect
{
namespace nPlugin
{

template <class DATA_TYPE, class PLUGIN_TYPE>
class tList4Plugin : public tMySQLMemoryList<DATA_TYPE, PLUGIN_TYPE>
{
public:
	tList4Plugin(cVHPlugin *pi, const string & TableName):
		tMySQLMemoryList<DATA_TYPE,PLUGIN_TYPE>(pi->mServer->mMySQL, (PLUGIN_TYPE*)pi, TableName)
	{}
	virtual ~tList4Plugin() {}
};

template <class LIST_TYPE, class CONSOLE_TYPE>
class tpiListPlugin : public cVHPlugin
{
public:
	tpiListPlugin() : mConsole(this), mList(NULL) {}
	virtual ~tpiListPlugin() {
		if (mList != NULL) delete mList;
		mList = NULL;
	}
	
	virtual bool RegisterAll() {
		RegisterCallBack("VH_OnUserCommand");
	}
	
	virtual bool OnUserCommand(cConnDC *conn, string *str) {
		return !(mConsole.DoCommand(*str, conn));
	}

	virtual void OnLoad(cServerDC *server){
		cVHPlugin::OnLoad(server);
	
		mList = new LIST_TYPE(this);
		mList->OnStart();
	}
	CONSOLE_TYPE mConsole;
	LIST_TYPE* mList;
};
};
};

#endif
