#!/bin/sh
#set -x

VERSION=`sh ../../batch/getversion.sh`
MAYOR=`awk -v version=$VERSION -v col=pl 'BEGIN {split(version,a,col);print a[1]}'`
rm -rf /tmp/white_dune-$VERSION
(cd ../../.. && cp -r white_dune-$VERSION /tmp) && \
cd /tmp/white_dune-$VERSION && make realclean && \
./configure --with-optimization --with-buginlesstif --without-devil --with-helpurl="http://www.csv.ica.uni-stuttgart.de/vrml/dune/docs/index.html" && make &&
cp bin/dune desktop/macosx/white_dune.app/Contents/MacOS &&
strip desktop/macosx/white_dune.app/Contents/MacOS/dune &&
cp -r desktop/macosx/Droplet-Applet/build/dune-droplet.app desktop/macosx/white_dune.app/Contents/MacOS &&
chmod +x desktop/macosx/white_dune.app/Contents/MacOS/dune-droplet.app/Contents/MacOS/dune-droplet &&
chmod +x desktop/macosx/white_dune.app/Contents/MacOS/* &&
awk -v mayor=$MAYOR '{sub("<string>0.20</string>","<string>" mayor "</string>");print $0}' \
     desktop/macosx/white_dune.app/Contents/Info.plist > /tmp/$$_Info.plist &&
cp /tmp/$$_Info.plist desktop/macosx/white_dune.app/Contents/Info.plist &&
rm /tmp/$$_Info.plist &&
cp bin/dune4kids desktop/macosx/white_dune4kids.app/Contents/MacOS &&
strip desktop/macosx/white_dune4kids.app/Contents/MacOS/dune4kids &&
cp -r desktop/macosx/Droplet-Applet/build/dune-droplet.app desktop/macosx/white_dune4kids.app/Contents/MacOS &&
chmod +x desktop/macosx/white_dune4kids.app/Contents/MacOS/dune-droplet.app/Contents/MacOS/dune-droplet &&
chmod +x desktop/macosx/white_dune4kids.app/Contents/MacOS/* &&
awk -v mayor=$MAYOR '{sub("<string>0.20</string>","<string>" mayor "</string>");print $0}' \
     desktop/macosx/white_dune4kids.app/Contents/Info.plist > /tmp/$$_Info.plist &&
cp /tmp/$$_Info.plist desktop/macosx/white_dune4kids.app/Contents/Info.plist &&
rm /tmp/$$_Info.plist &&
cd desktop/macosx && 
tar -cf /tmp/white_dune4kids-MacOSX-$VERSION.tar white_dune4kids.app && 
gzip -9f /tmp/white_dune4kids-MacOSX-$VERSION.tar &&
echo stuffit expander compatible archive is /tmp/white_dune4kids-MacOSX-$VERSION.tar.gz 
tar -cf /tmp/white_dune-MacOSX-$VERSION.tar white_dune.app && 
gzip -9f /tmp/white_dune-MacOSX-$VERSION.tar &&
echo stuffit expander compatible archive is /tmp/white_dune-MacOSX-$VERSION.tar.gz 

