#!/bin/sh
#set -x

RPM_SRC_LIST="rpm RPM redhat packages"

unset MKRPM_SRC
for i in $RPM_SRC_LIST ; do 
   if test -d /usr/src/$i/SOURCES ; then
      MKRPM_SRC=/usr/src/$i/SOURCES
   fi
done
if test "$MKRPM_SRC" = "" ; then
   echo -n non of typical rpm source directories 1>&2
   for i in $RPM_SRC_LIST ; do 
       echo -n " " /usr/src/$i/SOURCES 1>&2 
   done
   echo " " found 1>&2 
   echo extend variable RPM_SRC_LIST in $0 for your system 1>&2
   exit 1
fi

VERSION=`sh ../../batch/getversion.sh`
(cd ../../.. && cp -r white_dune-$VERSION /tmp && \
cd /tmp/white_dune-$VERSION && make realclean && rm -rf desktop/macosx desktop/irix) && \
(cd /tmp && tar -cpf - white_dune-$VERSION) | \
gzip -c > $MKRPM_SRC/white_dune-$VERSION.tar.gz

RPM_BUILD_ROOT='$RPM_BUILD_ROOT'
RPM_OPT_FLAGS='$RPM_OPT_FLAGS'

rm -f /tmp/white_dune-$VERSION.spec
cat > /tmp/white_dune-$VERSION.spec << EOT 
Summary: A graphical VRML97 editor and animation tool in development
Name: white_dune
Version: $VERSION
Release: 1
Copyright: GPL
Group: Applications/Multimedia
Source: http://www.csv.ica.uni-stuttgart.de/vrml/dune/white_dune-$VERSION.tar.gz
BuildRoot: /var/tmp/%{name}-buildroot

%description
The white_dune program is a graphical VRML97 editor and animation tool.
VRML97 (Virtual Reality Modelling Language) is the ISO standard for
displaying 3D data over the web. It has support for animation, realtime
interaction and multimedia (image, movie, sound). VRML97 can be written
by popular programs like maya, catia, 3D Studio MAX, cinema4D and others. 
Dune can read VRML97 files, display and let the user change the 
scenegraph/fields. 
Some documentation how to use dune is included.
White_dune has only 3D modelling features via support for the VRML200x style 
NURBS nodes. This is mainly convenient for building some rounded shapes.
For artistic work, the usage of a static 3D modeller with VRML97 export 
features is recommended. 
Examples for free (speech) static 3D modellers available under Linux are 
wings3d or art of illusion.
Dune can load and store x3d (next generation VRML xml format) files, 
if configured to work with the nist.gov x3d translators.
Advanced features of dune like the usage of 3Drevelator shutterglases (e.g.
with the commercial Linux XIG X11 Server (DX/platium) or with the 
Nvidia Quadro drivers (Xfree86 based)) may require recompilation of the 
source package. 
%prep
%setup -q

%build
./configure --with-optimization --with-buginlesstif --without-devil --with-vrmlbrowser=mozilla --with-helpurl="/usr/share/doc/white_dune-$VERSION/docs/" --with-nurbscurveprotourl="/usr/share/misc/white_dune/NurbsCurvePROTO.wrl" --with-nurbsgroupprotourl="/usr/share/misc/white_dune/NurbsGroupPROTO.wrl" --with-nurbssurfaceprotourl="/usr/share/misc/white_dune/NurbsSurfacePROTO.wrl"
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS" 

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/X11R6/bin
mkdir -p $RPM_BUILD_ROOT/usr/share/man/man1
mkdir -p $RPM_BUILD_ROOT/usr/share/misc/white_dune

install -s -m 755 bin/dune $RPM_BUILD_ROOT/usr/X11R6/bin/dune
install -s -m 755 bin/dune4kids $RPM_BUILD_ROOT/usr/X11R6/bin/dune4kids
install -m 644 man/dune.1 $RPM_BUILD_ROOT/usr/share/man/man1/dune.1
install -m 644 docs/vrml200x_nurbssurface/NurbsCurvePROTO.wrl $RPM_BUILD_ROOT/usr/share/misc/white_dune/NurbsCurvePROTO.wrl
install -m 644 docs/vrml200x_nurbssurface/NurbsGroupPROTO.wrl $RPM_BUILD_ROOT/usr/share/misc/white_dune/NurbsGroupPROTO.wrl
install -m 644 docs/vrml200x_nurbssurface/NurbsSurfacePROTO.wrl $RPM_BUILD_ROOT/usr/share/misc/white_dune/NurbsSurfacePROTO.wrl

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README COPYING docs

/usr/X11R6/bin/dune
/usr/X11R6/bin/dune4kids
/usr/share/man/man1/dune.1*
/usr/share/misc/white_dune/NurbsCurvePROTO.wrl
/usr/share/misc/white_dune/NurbsGroupPROTO.wrl
/usr/share/misc/white_dune/NurbsSurfacePROTO.wrl

EOT

if rpm -ba /tmp/white_dune-$VERSION.spec ; then
   echo > /dev/null
else
   rpmbuild -ba /tmp/white_dune-$VERSION.spec
fi
