/*
 * Field.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "Field.h"
#include "Scene.h"
#include "FieldValue.h"

Field::Field(int type, const MyString &name, FieldValue *value, 
	     ExposedField *exposedField, FieldValue *min, FieldValue *max,
	     int nodeType, int flags, const char **strings)
{
    _name = name;
    _type = type;
    _value = value;
    if (_value) _value->ref();
    _exposedField = exposedField;
    _min = min;
    if (_min) _min->ref();
    _max = max;
    if (_max) _max->ref();
    _nodeType = nodeType;
    _flags = flags;
    _strings = strings;
}

Field::~Field()
{
    if (_value) _value->unref();
    if (_min) _min->unref();
    if (_max) _max->unref();
}

int Field::write(int f, int indent) const
{
    if (_flags & FF_HIDDEN) return(0);

    RET_ONERROR( indentf(f, indent) )
    RET_ONERROR( mywritestr(f ,"field ") )
    RET_ONERROR( mywritestr(f ,typeEnumToString(_type)) )
    RET_ONERROR( mywritestr(f ," ") )
    RET_ONERROR( mywritestr(f ,(const char *) _name) )
    RET_ONERROR( mywritestr(f ," ") )
    if (_value) RET_ONERROR( _value->write(f, indent) )
    return(0);
}

