/*
 * FieldValue.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _FIELDVALUE_H
#define _FIELDVALUE_H

#ifndef _ARRAY_H
#include "Array.h"
#endif
#ifndef _DUNE_STRING_H
#include "MyString.h"
#endif
#ifndef _ELEMENT_H
#include "Element.h"
#endif

class Scene;
class Node;

typedef Array<int>	IntArray;
typedef Array<float>	FloatArray;
typedef Array<MyString>	StringArray;

#include "Types.h"

class FieldValue {
public:
			FieldValue();
//			FieldValue(const FieldValue &value);
    virtual 	       ~FieldValue() {}
    virtual int		write(int filedes, int indent) const = 0;
    virtual int		getType() const = 0;
    virtual const char *getTypeName() const = 0;
    virtual bool	equals(const FieldValue *value) const = 0;
    virtual FieldValue *addNode(Node *node) const;
    virtual FieldValue *removeNode(Node *node) const;

    virtual void	clamp(const FieldValue *min, const FieldValue *max) {}

    void		ref() { _refs++; }
    void		unref() { if (--_refs == 0) delete this; }

    virtual FieldValue *copy() = 0;

    virtual MyString    getEcmaScriptComment(MyString name, int flags) 
                              const = 0;

    const char         *getEcmaScriptIndent(int flags);

    virtual bool        isAnimateable(void) const = 0;
    virtual bool        hasAnimationSupport(void) { return false; }

private:
    int			_refs;
};

class MFieldValue : public FieldValue
{
public:
    virtual int		getSFSize() const = 0;
    virtual FieldValue *getSFValue(int index) const = 0;
    virtual void	setSFValue(int index, FieldValue *value) = 0;
};

extern int indentf(int filedes, int indent);

#endif // _FIELDVALUE_H
