/*
 * FieldViewItem.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _FIELD_VIEW_ITEM_H
#define _FIELD_VIEW_ITEM_H

#ifndef _ARRAY_H
#include "Array.h"
#endif

#ifndef _RECT_H
#include "Rect.h"
#endif

#ifndef _POINT_H
#include "Point.h"
#endif

#ifndef STRING_H
#include "MyString.h"
#endif

class FieldView;
class FieldValue;
//class Field;
#include "Field.h"
#include "Types.h"

#include "swttypedef.h"

#define FVIS_SELECTED	    (1<<0)
#define FVIS_COLLAPSED	    (1<<1)

class FieldViewItem {
public:
				FieldViewItem(FieldView *view);
    virtual		       ~FieldViewItem();

    virtual void		CreateControl(const Rect & /*rect */) {}

    virtual void		SetValue(FieldValue *value);
    FieldValue		       *GetValue()		    { return _value; }

    FieldViewItem	       *GetParent() const	    { return _parent; }
    int				GetIndex() const	    { return _index; }
    int				GetState() const	    { return _state; }

    void			SetField(const Field *field) { _field = field; }

    virtual void		MoveControl(int x, int y)    {}

    void			SetParent(FieldViewItem *parent)
							    { _parent = parent; }
    void			SetIndex(int index)	    { _index = index; }
    void			SetFlag(int flag)	    { _state |= flag; }
    void			ClearFlag(int flag)	    { _state &= ~flag; }

    virtual FieldValue	       *OnCommand(int id)	    { return NULL; }
    virtual void		Draw(SDC, int, int)	    {}
    virtual FieldValue	       *OnMouseDown(int, int, int)   { return NULL; }

    virtual void		StartEditing(MyString &str, int offset) {}
    virtual FieldValue	       *StopEditing(const char *str, int offset) { return NULL; }

    virtual bool		IsGroup() const		    { return false; }
    bool			IsCollapsed() const	    { return (_state & FVIS_COLLAPSED) != 0; }

    void			SetCollapsed(bool collapsed) 
			        { if (collapsed) SetFlag(FVIS_COLLAPSED); 
				  else ClearFlag(FVIS_COLLAPSED); }
				
    virtual bool		IsTrackable() const	    { return false; }
    virtual bool		IsEditable() const  	    { return false; }
    virtual int			GetFieldOffset(int pos) const	    { return 0; }

    virtual void		UpdateControl() {}
    virtual FieldValue	       *OnMouseMove(FieldValue *value, int index, int delta) { return NULL; }
    static FieldViewItem       *CreateItem(const Field *field, FieldView *view);

protected:
    FieldView		       *_view;
    FieldViewItem	       *_parent;    // for items in an MField
    FieldValue		       *_value;
    int				_state;
    const Field		       *_field;

    int				_index;	    // field # for fields, index for MF's
};

class MFieldViewItem : public FieldViewItem {
public:
			MFieldViewItem(FieldView *view);
    virtual	       ~MFieldViewItem();

    int	  			GetNumChildren() const	    { return _children.size(); }
    FieldViewItem	       *GetChild(int index)	    { return _children[index]; }
    virtual bool		IsGroup() const		    { return true; }
    virtual FieldViewItem      *CreateSFItem() = 0;
    virtual void		SetValue(FieldValue *value);
    void                        InitIndexValue(int index, FieldValue *value);
    virtual void                InsertSFValue(int index) {}
    virtual void		InsertItem(FieldView *view, int index)      
                                    { 
// currently only MFString works
if (_field->getType()== MFSTRING) {
                                    InsertSFValue(index);
                                    _children.insert(new FieldViewItem(view),index); 
                                    InitIndexValue(index, _value);
}
                                    }
    virtual void                RemoveSFValue(int index) {}
    virtual void		RemoveItem(FieldView *view, int index)      
                                    { 
// currently only MFString works
if (_field->getType()== MFSTRING) {
                                    RemoveSFValue(index);
                                    _children.remove(index); 
}

                                    }

protected:
    Array<FieldViewItem *>	_children;
};

class SFBoolItem : public FieldViewItem {
public:
			SFBoolItem(FieldView *view);
    virtual	       ~SFBoolItem();
    virtual void	MoveControl(int x, int y);

    virtual void	CreateControl(const Rect &rect);
    virtual void	UpdateControl();
    void		OnClicked();
private:
    SWND		_button;
};

class SFColorItem : public FieldViewItem {
public:
		   	SFColorItem(FieldView *view);
    virtual	       ~SFColorItem();

    virtual void	Draw(SDC dc, int x, int y);
    virtual void	UpdateControl();
    virtual FieldValue *OnMouseDown(int x, int y, int modifiers);
    virtual FieldValue *OnMouseMove(FieldValue *value, int index, int delta);
    virtual bool	IsTrackable() const	    { return true; }
    virtual bool	IsEditable() const  	    { return true; }
    virtual int		GetFieldOffset(int xpos) const;
    virtual void	StartEditing(MyString &str, int offset);
    virtual FieldValue *StopEditing(const char *str, int offset);
};

class SFFloatItem : public FieldViewItem {
public:
			SFFloatItem(FieldView *view);

    virtual FieldValue *OnMouseMove(FieldValue *value, int index, int delta);
    virtual void	Draw(SDC dc, int x, int y);
    virtual bool	IsTrackable() const	    { return true; }
    virtual bool	IsEditable() const  	    { return true; }
    virtual void	StartEditing(MyString &str, int offset);
    virtual FieldValue *StopEditing(const char *str, int offset);
};
		    
class SFInt32Item : public FieldViewItem {
public:
			SFInt32Item(FieldView *view);

    virtual void	Draw(SDC dc, int x, int y);
    virtual FieldValue *OnMouseMove(FieldValue *value, int index, int delta);
    virtual bool	IsTrackable() const	    { return true; }
    virtual bool	IsEditable() const  	    { return true; }
    virtual void	StartEditing(MyString &str, int offset);
    virtual FieldValue *StopEditing(const char *str, int offset);
};

class SFNodeItem : public FieldViewItem {
public:
			SFNodeItem(FieldView *view);
    virtual void	Draw(SDC dc, int x, int y);

    virtual bool	IsTrackable() const	    { return false; }
    virtual bool	IsEditable() const  	    { return false; }
};

class SFRotationItem : public FieldViewItem {
public:
			SFRotationItem(FieldView *view);

    virtual void	Draw(SDC dc, int x, int y);
    virtual FieldValue *OnMouseMove(FieldValue *value, int index, int delta);
    virtual bool	IsTrackable() const	    { return true; }
    virtual bool	IsEditable() const  	    { return true; }
    virtual int		GetFieldOffset(int xpos) const;
    virtual void	StartEditing(MyString &str, int offset);
    virtual FieldValue *StopEditing(const char *str, int offset);
};

class SFStringItem : public FieldViewItem {
public:
			SFStringItem(FieldView *view);
		       ~SFStringItem();

    virtual void	CreateControl(const Rect &rect);
    virtual void	MoveControl(int x, int y);
    virtual void	Draw(SDC dc, int x, int y);
    virtual bool	IsTrackable() const	    { return false; }
    virtual bool	IsEditable() const  	    { return _comboBox == NULL; }
    virtual void	StartEditing(MyString &str, int offset);
    virtual FieldValue *StopEditing(const char *str, int offset);
    virtual FieldValue *OnCommand(int id);
    virtual FieldValue *OnMouseDown(int x, int y, int modifiers);
    virtual void	UpdateControl();

protected:
//    CComboBox	       *_comboBox;
    SWND		_comboBox;
    const char	      **_strings;
};

class SFTimeItem : public FieldViewItem {
public:
			SFTimeItem(FieldView *view);

    virtual void	Draw(SDC dc, int x, int y);
    virtual FieldValue *OnMouseMove(FieldValue *value, int index, int delta);
    virtual bool	IsTrackable() const	    { return true; }
    virtual bool	IsEditable() const  	    { return true; }
    virtual void	StartEditing(MyString &str, int offset);
    virtual FieldValue *StopEditing(const char *str, int offset);
};

class SFVec2fItem : public FieldViewItem {
public:
			SFVec2fItem(FieldView *view);

    virtual void	Draw(SDC dc, int x, int y);
    virtual FieldValue *OnMouseMove(FieldValue *value, int index, int delta);
    virtual bool	IsTrackable() const	    { return true; }
    virtual bool	IsEditable() const  	    { return true; }
    virtual int		GetFieldOffset(int xpos) const;
    virtual void	StartEditing(MyString &str, int offset);
    virtual FieldValue *StopEditing(const char *str, int offset);
};
		    
class SFVec3fItem : public FieldViewItem {
public:
			SFVec3fItem(FieldView *view);

    virtual void	Draw(SDC dc, int x, int y);
    virtual FieldValue *OnMouseMove(FieldValue *value, int index, int delta);
    virtual bool	IsTrackable() const	    { return true; }
    virtual bool	IsEditable() const  	    { return true; }
    virtual int		GetFieldOffset(int xpos) const;
    virtual void	StartEditing(MyString &str, int offset);
    virtual FieldValue *StopEditing(const char *str, int offset);
};
		    
class MFColorItem : public MFieldViewItem {
public:			
			MFColorItem(FieldView *view);

    virtual FieldViewItem   *CreateSFItem();
};

class MFFloatItem : public MFieldViewItem {
public:			
			        MFFloatItem(FieldView *view);

    virtual void		Draw(SDC dc, int x, int y);
    virtual FieldValue	       *OnMouseDown(int x, int y, int modifiers);
    virtual bool		IsEditable() const;
    virtual void		StartEditing(MyString &str, int offset);
    virtual FieldValue	       *StopEditing(const char *str, int offset);
    virtual FieldViewItem      *CreateSFItem();
};

class MFInt32Item : public MFieldViewItem {
public:			
			MFInt32Item(FieldView *view);

    virtual FieldViewItem   *CreateSFItem();
};

class MFNodeItem : public MFieldViewItem {
public:
			MFNodeItem(FieldView *view);

    virtual FieldViewItem   *CreateSFItem();
};

class MFRotationItem : public MFieldViewItem {
public:
			MFRotationItem(FieldView *view);

    virtual FieldViewItem   *CreateSFItem();
};

class MFStringItem : public MFieldViewItem {
public:
				MFStringItem(FieldView *view);

    virtual void		Draw(SDC dc, int x, int y);
    virtual bool		IsEditable() const;
    virtual void		StartEditing(MyString &str, int offset);
    virtual FieldValue	       *StopEditing(const char *str, int offset);
    virtual FieldViewItem      *CreateSFItem();
    virtual FieldValue	       *OnMouseDown(int x, int y, int modifiers);
    virtual void                InsertSFValue(int index);
    virtual void                RemoveSFValue(int index);
};

class MFTimeItem : public MFieldViewItem {
public:
			MFTimeItem(FieldView *view);

    virtual FieldViewItem   *CreateSFItem();
};

class MFVec2fItem : public MFieldViewItem {
public:			
			MFVec2fItem(FieldView *view);

    virtual FieldViewItem   *CreateSFItem();
};


class MFVec3fItem : public MFieldViewItem {
public:			
			MFVec3fItem(FieldView *view);

    virtual FieldViewItem   *CreateSFItem();
};

#endif // _FIELD_VIEW_ITEM_H
