/*
 * InputDeviceCommandline.cpp 
 * Commandline parser for InputDevice options
 * Copyright (c) 2003 J. "MUFTI" Scheurich, based on
 * 
 * main.cpp of dune/white_dune
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include "config.h" 
#include "TheApp.h" 

#define errorprintf fprintf

bool parseCommandlineArgumentInputDevice(int & i,int argc, char** argv)
{
    bool found=true;
    if (0 == 1) {
#ifdef LINUX_JOYSTICK
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-joystick")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new linux_joystick(argv[i]));
#endif
#ifdef WINDOWS_JOYSTICK
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-joystick")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new windows_joystick(argv[i]));
#endif
#ifdef HAVE_SDL_JOYSTICK
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-SDLjoystick")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new SDL_joystick(argv[i]));
#endif
#ifdef HAVE_LIBSBALL
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-spaceball")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new spaceball(argv[i]));
#endif
#ifdef HAVE_WINDOWS_SPACEBALL
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-spaceball")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new windowsspaceball(argv[i]));
#endif
#ifdef HAVE_XINPUT
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-xinput")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new xinput(argv[i]));
    } else if (strcmp(argv[i],"-xinputlist")==0) {
       swListXinputDevice();
       exit(0);
#endif
#ifdef HAVE_AFLOCK
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-aflock")==0) {
       if (i++>=argc) return found;
       TheApp->setAflockDevice(new AflockDevice(argv[i]));
    // zillions of flock of birds parameter
    } else if (strcmp(argv[i],"-baud")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setBaud(argv[i]);

    } else if (strcmp(argv[i],"-sync")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setSync(argv[i]);

    } else if (strcmp(argv[i],"-block")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setBlock(argv[i]);

    } else if (strcmp(argv[i],"-numbirds")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setNumBrds(argv[i]);


    } else if (strcmp(argv[i],"-master")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setTransmit(argv[i]);

    } else if (strcmp(argv[i],"-hemisphere")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setHemi(argv[i]);

    } else if (strcmp(argv[i],"-filter")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setFilt(argv[i]);

    } else if (strcmp(argv[i],"-suddenchangelock")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setSuddenChangeLock(argv[i]);

    } else if (strcmp(argv[i],"-report")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setReport(argv[i]);
    } else if (strcmp(argv[i],"-calfile")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setCalfile(argv[i]);

    } else if (strcmp(argv[i],"-wand")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()==0)
          errorprintf(stderr,"no -aflock option found\n"); 
       else
          TheApp->setInputDevice(new aflock(
                TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1),
                argv[i],false));

    } else if (strcmp(argv[i],"-tracker")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()==0)
          errorprintf(stderr,"no -aflock option found\n"); 
       else
          TheApp->setInputDevice(new aflock(
                TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1),
                argv[i],true));

    } else if (stringncmp(argv[i],"-headnavigation")==0) {
       if (i++>=argc) return found;
           if (TheApp->getNumberInputDevices()!=0)
              TheApp->getInputDevice(TheApp->getNumberInputDevices()-1)->
                      setHeadNavigation();
    } else if (stringncmp(argv[i],"-ignoresize")==0) {
       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()==0)
          errorprintf(stderr,"no -aflock option found\n"); 
       else
          if (TheApp->getNumberInputDevices()!=0)
              ((aflock *)TheApp->getInputDevice(TheApp->
                   getNumberInputDevices()-1))->
                   setIgnoreSize(argv[i]);
#endif
#ifdef HAS_INPUT_DEVICE 
    } else if ((stringncmp(argv[i],"-x")==0) ||
               (stringncmp(argv[i],"-y")==0) ||
               (stringncmp(argv[i],"-z")==0) ||
               (stringncmp(argv[i],"-all")==0) ||
               (stringncmp(argv[i],"-none")==0)) {
           if (TheApp->getNumberInputDevices()!=0)
              TheApp->getInputDevice(TheApp->getNumberInputDevices()-1)->
                      SetAxisInformation(argv[i]);
    } else if (stringncmp(argv[i],"-axes")==0) {
           if (TheApp->getNumberInputDevices()!=0)
              TheApp->getInputDevice(TheApp->getNumberInputDevices()-1)->
                      SetNumberAxes(argv[i]);
    } else if (stringncmp(argv[i],"-sendalways")==0) {
           if (TheApp->getNumberInputDevices()!=0)
              TheApp->getInputDevice(TheApp->getNumberInputDevices()-1)->
                      SetSendAlways(true);
#endif
#ifdef __APPLE__
    } else if (stringncmp(argv[i],"-psn_")==0) {
           // parse special MacOSX commandline parameters
#endif
    } else
       found=false;
    return found;    
}


